/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.firebirdsql.gds.ng.BatchCompletion;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.FbBatchConfig;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jdbc.Batch;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.Primitives;
import org.firebirdsql.util.SQLExceptionChainBuilder;

final class ServerBatch
implements Batch,
StatementListener {
    private static final Logger log = LoggerFactory.getLogger(ServerBatch.class);
    private volatile BatchState state = BatchState.INITIAL;
    private final FbBatchConfig batchConfig;
    private Deque<Batch.BatchRowValue> batchRowValues = new ArrayDeque<Batch.BatchRowValue>();
    private FbStatement statement;

    ServerBatch(FbBatchConfig batchConfig, FbStatement statement) throws SQLException {
        if (!statement.supportBatchUpdates()) {
            throw new FBDriverNotCapableException(String.format("FbStatement implementation %s does not support server-side batch updates", statement.getClass().getName()));
        }
        this.batchConfig = batchConfig.immutable();
        this.statement = statement;
        statement.addStatementListener(this);
    }

    @Override
    public void statementStateChanged(FbStatement sender, StatementState newState, StatementState previousState) {
        if (this.isClosed() || sender != this.statement) {
            sender.removeStatementListener(this);
            return;
        }
        switch (newState) {
            case ALLOCATED: 
            case PREPARING: {
                if (this.state == BatchState.INITIAL) break;
                this.state = BatchState.INITIAL;
                try {
                    this.clearBatch();
                }
                catch (SQLException e) {
                    log.debug("Unexpected exception clearing batch, this might indicate a bug in Jaybird", e);
                }
                break;
            }
            case CLOSED: {
                this.close();
                break;
            }
        }
    }

    @Override
    public void addBatch(Batch.BatchRowValue rowValue) throws SQLException {
        this.checkOpen();
        this.batchRowValues.addLast(rowValue);
    }

    private boolean isEmpty() throws SQLException {
        this.checkOpen();
        return this.batchRowValues.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> execute() throws SQLException {
        try {
            this.checkOpen();
            if (this.isEmpty()) {
                List<Long> list = Collections.emptyList();
                return list;
            }
            Collection<RowValue> rowValues = this.toRowValues();
            SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
            if (!this.state.isOpenOnServer()) {
                this.createBatch(chain);
            }
            this.sendBatch(rowValues, chain);
            BatchCompletion batchCompletion = this.executeBatch(chain);
            if (batchCompletion.hasErrors()) {
                throw chain.addFirst(this.toBatchUpdateException(batchCompletion)).getException();
            }
            if (chain.hasException()) {
                throw chain.getException();
            }
            int[] updateCounts = this.toJdbcUpdateCounts(batchCompletion);
            List<Long> list = Primitives.toLongList(updateCounts);
            return list;
        }
        finally {
            this.clearBatch();
        }
    }

    private void createBatch(SQLExceptionChainBuilder<SQLException> chain) throws SQLException {
        try {
            this.statement.deferredBatchCreate(this.batchConfig, new BatchDeferredAction(chain, "exception creating batch"){

                @Override
                public void onException(Exception exception) {
                    super.onException(exception);
                    ServerBatch.this.state = BatchState.INITIAL;
                }
            });
            this.state = this.state.onServerOpen();
        }
        catch (SQLException e) {
            chain.append(e);
            throw chain.getException();
        }
    }

    private void sendBatch(Collection<RowValue> rowValues, SQLExceptionChainBuilder<SQLException> chain) throws SQLException {
        try {
            this.statement.deferredBatchSend(rowValues, new BatchDeferredAction(chain, "exception sending batch message"){

                @Override
                public void onException(Exception exception) {
                    super.onException(exception);
                    ServerBatch.this.state = BatchState.SERVER_OPEN;
                }
            });
            this.state = this.state.onSend();
        }
        catch (SQLException e) {
            chain.append(e);
            throw chain.getException();
        }
    }

    private BatchCompletion executeBatch(SQLExceptionChainBuilder<SQLException> chain) throws SQLException {
        try {
            this.state = this.state.onExecute();
            BatchCompletion batchCompletion = this.statement.batchExecute();
            this.state = this.state.onBatchComplete();
            return batchCompletion;
        }
        catch (SQLException e) {
            chain.append(e);
            throw chain.getException();
        }
    }

    private Collection<RowValue> toRowValues() throws SQLException {
        Batch.BatchRowValue batchRowValue;
        Deque<Batch.BatchRowValue> batchRowValues = this.batchRowValues;
        ArrayList<RowValue> rowValues = new ArrayList<RowValue>(batchRowValues.size());
        while ((batchRowValue = batchRowValues.pollFirst()) != null) {
            rowValues.add(batchRowValue.toRowValue());
        }
        return rowValues;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        try {
            if (this.state.isBatchOnServer()) {
                this.statement.batchCancel();
                this.state = this.state.onServerCancel();
            }
        }
        finally {
            this.batchRowValues.clear();
        }
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("batch has been closed");
        }
    }

    boolean isClosed() {
        return this.state == BatchState.CLOSED;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.state = BatchState.CLOSED;
        this.batchRowValues = null;
        FbStatement copyStmt = this.statement;
        if (copyStmt != null) {
            this.statement = null;
            copyStmt.removeStatementListener(this);
        }
    }

    int[] toJdbcUpdateCounts(BatchCompletion batchCompletion) {
        int elementCount = batchCompletion.elementCount();
        int[] jdbcUpdateCounts = batchCompletion.updateCounts();
        List<BatchCompletion.DetailedError> detailedErrors = batchCompletion.detailedErrors();
        int[] simplifiedErrors = batchCompletion.simplifiedErrors();
        if (!batchCompletion.hasErrors()) {
            if (jdbcUpdateCounts.length == 0 && elementCount > 0) {
                jdbcUpdateCounts = new int[elementCount];
                Arrays.fill(jdbcUpdateCounts, -2);
            }
        } else if (jdbcUpdateCounts.length == 0 && elementCount > 0) {
            if (this.batchConfig.multiError()) {
                jdbcUpdateCounts = new int[elementCount];
                Arrays.fill(jdbcUpdateCounts, -2);
                for (BatchCompletion.DetailedError error : detailedErrors) {
                    jdbcUpdateCounts[error.element()] = -3;
                }
                for (Object element : (Object)simplifiedErrors) {
                    jdbcUpdateCounts[element] = -3;
                }
            } else {
                int firstErrorPosition;
                int n = firstErrorPosition = detailedErrors.isEmpty() ? simplifiedErrors[0] : detailedErrors.get(0).element();
                if (firstErrorPosition != 0) {
                    jdbcUpdateCounts = new int[firstErrorPosition];
                    Arrays.fill(jdbcUpdateCounts, -2);
                }
            }
        } else if (this.batchConfig.multiError()) {
            for (int i = 0; i < jdbcUpdateCounts.length; ++i) {
                if (jdbcUpdateCounts[i] != -1) continue;
                jdbcUpdateCounts[i] = -3;
            }
        } else if (jdbcUpdateCounts[jdbcUpdateCounts.length - 1] == -1) {
            jdbcUpdateCounts = Arrays.copyOf(jdbcUpdateCounts, jdbcUpdateCounts.length - 1);
        }
        return jdbcUpdateCounts;
    }

    BatchUpdateException toBatchUpdateException(BatchCompletion batchCompletion) {
        if (!batchCompletion.hasErrors()) {
            throw new IllegalStateException("toBatchUpdateException called while BatchCompletion has no errors");
        }
        int[] updateCounts = this.toJdbcUpdateCounts(batchCompletion);
        List<BatchCompletion.DetailedError> detailedErrors = batchCompletion.detailedErrors();
        if (detailedErrors.isEmpty()) {
            return new BatchUpdateException("Batch execution failed without detailed errors; this can happen when detailedErrors batch config is set to zero", "HY000", 0, updateCounts);
        }
        SQLException exception = detailedErrors.get(0).error();
        BatchUpdateException bue = new BatchUpdateException(exception.getMessage(), exception.getSQLState(), exception.getErrorCode(), updateCounts);
        detailedErrors.stream().map(BatchCompletion.DetailedError::error).forEach(bue::setNextException);
        return bue;
    }

    private static enum BatchState {
        INITIAL,
        SERVER_OPEN,
        PARTIAL_SEND,
        EXECUTING,
        CLOSED;


        boolean isOpenOnServer() {
            return this != INITIAL && this != CLOSED;
        }

        boolean isBatchOnServer() {
            return this == PARTIAL_SEND || this == EXECUTING;
        }

        BatchState onServerOpen() throws SQLException {
            if (this == INITIAL) {
                return SERVER_OPEN;
            }
            throw new SQLNonTransientException("Cannot server-open in state " + String.valueOf((Object)this));
        }

        BatchState onSend() throws SQLException {
            switch (this) {
                case INITIAL: 
                case SERVER_OPEN: 
                case PARTIAL_SEND: {
                    return PARTIAL_SEND;
                }
                case EXECUTING: {
                    return EXECUTING;
                }
                case CLOSED: {
                    throw new SQLNonTransientException("Cannot send in state CLOSED");
                }
            }
            throw new SQLNonTransientException("Unexpected state " + String.valueOf((Object)this));
        }

        BatchState onExecute() throws SQLException {
            switch (this) {
                case INITIAL: 
                case SERVER_OPEN: 
                case PARTIAL_SEND: 
                case EXECUTING: {
                    return EXECUTING;
                }
                case CLOSED: {
                    throw new SQLNonTransientException("Cannot execute in state CLOSED");
                }
            }
            throw new SQLNonTransientException("Unexpected state " + String.valueOf((Object)this));
        }

        BatchState onBatchComplete() throws SQLException {
            switch (this) {
                case EXECUTING: {
                    return SERVER_OPEN;
                }
                case CLOSED: {
                    throw new SQLNonTransientException("Cannot complete in state CLOSED");
                }
            }
            throw new SQLNonTransientException("Unexpected state " + String.valueOf((Object)this));
        }

        BatchState onServerCancel() throws SQLException {
            if (this == CLOSED || this == INITIAL) {
                return this;
            }
            return SERVER_OPEN;
        }
    }

    private static class BatchDeferredAction
    implements DeferredResponse<Void> {
        private final SQLExceptionChainBuilder<? super SQLException> chain;
        private final String genericExceptionMessage;

        BatchDeferredAction(SQLExceptionChainBuilder<? super SQLException> chain, String genericExceptionMessage) {
            this.chain = chain;
            this.genericExceptionMessage = genericExceptionMessage;
        }

        @Override
        public void onException(Exception exception) {
            if (exception instanceof SQLException) {
                this.chain.append((SQLException)exception);
            } else {
                this.chain.append(new SQLNonTransientException(this.genericExceptionMessage, exception));
            }
        }
    }
}

