/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.extern.decimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import org.firebirdsql.extern.decimal.DecimalOverflowException;

final class DecimalFormat
extends Enum<DecimalFormat> {
    public static final /* enum */ DecimalFormat Decimal32 = new DecimalFormat(32, 7, MathContext.DECIMAL32);
    public static final /* enum */ DecimalFormat Decimal64 = new DecimalFormat(64, 16, MathContext.DECIMAL64);
    public static final /* enum */ DecimalFormat Decimal128 = new DecimalFormat(128, 34, MathContext.DECIMAL128);
    private static final int SIGN_BITS = 1;
    private static final int COMBINATION_BITS = 5;
    final int formatBitLength;
    final int formatByteLength;
    final int coefficientDigits;
    final int exponentContinuationBits;
    final int coefficientContinuationBits;
    final int eLimit;
    private final int exponentBias;
    private final BigInteger maxCoefficient;
    private final BigInteger minCoefficient;
    private final MathContext mathContext;
    private static final /* synthetic */ DecimalFormat[] $VALUES;

    public static DecimalFormat[] values() {
        return (DecimalFormat[])$VALUES.clone();
    }

    public static DecimalFormat valueOf(String name) {
        return Enum.valueOf(DecimalFormat.class, name);
    }

    private DecimalFormat(int formatBitLength, int coefficientDigits, MathContext mathContext) {
        this.mathContext = mathContext;
        assert (formatBitLength > 0 && formatBitLength % 8 == 0);
        this.formatBitLength = formatBitLength;
        this.formatByteLength = formatBitLength / 8;
        this.coefficientDigits = coefficientDigits;
        this.coefficientContinuationBits = DecimalFormat.calculateCoefficientContinuationBits(coefficientDigits);
        this.exponentContinuationBits = DecimalFormat.calculateExponentContinuationBits(formatBitLength, this.coefficientContinuationBits);
        this.eLimit = DecimalFormat.calculateExponentLimit(this.exponentContinuationBits);
        int eMin = -this.eLimit / 2;
        this.exponentBias = -eMin + coefficientDigits - 1;
        char[] digits = new char[coefficientDigits];
        Arrays.fill(digits, '9');
        this.maxCoefficient = new BigInteger(new String(digits));
        this.minCoefficient = this.maxCoefficient.negate();
    }

    final MathContext getMathContext() {
        return this.mathContext;
    }

    final BigDecimal tryRound(BigDecimal value) {
        BigDecimal roundedToPrecision = value.round(this.mathContext);
        int scaleAdjustment = this.requiredScaleAdjustment(roundedToPrecision);
        if (scaleAdjustment == 0) {
            return roundedToPrecision;
        }
        if (scaleAdjustment < 0) {
            return roundedToPrecision.setScale(roundedToPrecision.scale() + scaleAdjustment, this.mathContext.getRoundingMode());
        }
        if (roundedToPrecision.compareTo(BigDecimal.ZERO) == 0 || scaleAdjustment <= this.coefficientDigits - roundedToPrecision.precision()) {
            return roundedToPrecision.setScale(roundedToPrecision.scale() + scaleAdjustment, RoundingMode.UNNECESSARY);
        }
        return roundedToPrecision;
    }

    final BigDecimal validate(BigDecimal value) {
        int precision = value.precision();
        if (precision > this.coefficientDigits) {
            throw new DecimalOverflowException("Precision " + precision + " exceeds the maximum of " + this.coefficientDigits + " for this type");
        }
        if (this.requiredScaleAdjustment(value) != 0) {
            throw new DecimalOverflowException("The scale " + value.scale() + " is out of range for this type");
        }
        return value;
    }

    final BigInteger validateCoefficient(BigInteger coefficient) {
        if (this.maxCoefficient.compareTo(coefficient) < 0 || this.minCoefficient.compareTo(coefficient) > 0) {
            throw new DecimalOverflowException("Value " + coefficient + " is out of range for this type [" + this.minCoefficient + ", " + this.maxCoefficient + "]");
        }
        return coefficient;
    }

    final boolean isOutOfRange(BigDecimal value) {
        return value.precision() > this.coefficientDigits || this.requiredScaleAdjustment(value) != 0;
    }

    private int requiredScaleAdjustment(BigDecimal value) {
        int biasedExponent = this.biasedExponent(-value.scale());
        if (biasedExponent >= 0) {
            if (biasedExponent <= this.eLimit) {
                return 0;
            }
            return biasedExponent - this.eLimit;
        }
        return biasedExponent;
    }

    final int biasedExponent(int unbiasedExponent) {
        return unbiasedExponent + this.exponentBias;
    }

    final int unbiasedExponent(int biasedExponent) {
        return biasedExponent - this.exponentBias;
    }

    final void validateByteLength(byte[] decBytes) {
        if (decBytes.length != this.formatByteLength) {
            throw new IllegalArgumentException("decBytes argument must be " + this.formatByteLength + " bytes");
        }
    }

    private static int calculateCoefficientContinuationBits(int coefficientDigits) {
        return 10 * (coefficientDigits - 1) / 3;
    }

    private static int calculateExponentContinuationBits(int formatBitLength, int coefficientContinuationBits) {
        return formatBitLength - 1 - 5 - coefficientContinuationBits;
    }

    private static int calculateExponentLimit(int exponentContinuationBits) {
        return 3 * (1 << exponentContinuationBits) - 1;
    }

    private static /* synthetic */ DecimalFormat[] $values() {
        return new DecimalFormat[]{Decimal32, Decimal64, Decimal128};
    }

    static {
        $VALUES = DecimalFormat.$values();
    }
}

