/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.firebirdsql.gds.impl.DbAttachInfo;
import org.firebirdsql.gds.impl.GDSFactoryPlugin;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.jaybird.props.DatabaseConnectionProperties;
import org.firebirdsql.jaybird.util.PluginLoader;

public final class GDSFactory {
    private static final Set<GDSFactoryPlugin> registeredPlugins = new HashSet<GDSFactoryPlugin>();
    private static final Map<GDSType, GDSFactoryPlugin> typeToPluginMap = new HashMap<GDSType, GDSFactoryPlugin>();
    private static final TreeMap<String, GDSFactoryPlugin> jdbcUrlToPluginMap = new TreeMap(Comparator.reverseOrder());
    private static GDSType defaultType;

    private GDSFactory() {
    }

    public static void registerPlugin(GDSFactoryPlugin plugin) {
        boolean newPlugin = registeredPlugins.add(plugin);
        if (!newPlugin) {
            return;
        }
        GDSType type = GDSType.registerType(plugin.getTypeName());
        typeToPluginMap.put(type, plugin);
        if (defaultType == null) {
            defaultType = type;
        }
        for (String alias : plugin.getTypeAliasList()) {
            GDSType aliasType = GDSType.registerType(alias);
            typeToPluginMap.put(aliasType, plugin);
        }
        for (String jdbcUrl : plugin.getSupportedProtocolList()) {
            GDSFactoryPlugin otherPlugin = jdbcUrlToPluginMap.put(jdbcUrl, plugin);
            if (otherPlugin == null || otherPlugin.equals(plugin)) continue;
            throw new IllegalArgumentException("Duplicate JDBC URL pattern detected: URL %s, plugin %s, other plugin %s".formatted(jdbcUrl, plugin.getTypeName(), otherPlugin.getTypeName()));
        }
    }

    public static GDSType getDefaultGDSType() {
        return defaultType;
    }

    public static FbDatabaseFactory getDatabaseFactoryForType(GDSType gdsType) {
        if (gdsType == null) {
            gdsType = defaultType;
        }
        return GDSFactory.getPlugin(gdsType).getDatabaseFactory();
    }

    public static String getDatabasePath(GDSType gdsType, String server, Integer port, String path) throws SQLException {
        return GDSFactory.getPlugin(gdsType).getDatabasePath(server, port, path);
    }

    public static String getDatabasePath(GDSType gdsType, String jdbcUrl) throws SQLException {
        return GDSFactory.getPlugin(gdsType).getDatabasePath(jdbcUrl);
    }

    public static Set<String> getSupportedProtocols() {
        return Collections.unmodifiableSet(jdbcUrlToPluginMap.keySet());
    }

    public static String getJdbcUrl(GDSType gdsType, DatabaseConnectionProperties dbConnectionProperties) throws SQLException {
        DbAttachInfo dbAttachInfo = DbAttachInfo.of(dbConnectionProperties);
        GDSFactoryPlugin plugin = GDSFactory.getPlugin(gdsType);
        return plugin.getDefaultProtocol() + plugin.getDatabasePath(dbAttachInfo);
    }

    public static GDSType getTypeForProtocol(String jdbcUrl) {
        for (Map.Entry<String, GDSFactoryPlugin> entry : jdbcUrlToPluginMap.entrySet()) {
            String jdbcProtocol = entry.getKey();
            if (!jdbcUrl.startsWith(jdbcProtocol)) continue;
            return GDSType.getType(entry.getValue().getTypeName());
        }
        return null;
    }

    public static Class<?> getConnectionClass(GDSType gdsType) {
        return GDSFactory.getPlugin(gdsType).getConnectionClass();
    }

    public static GDSFactoryPlugin getPlugin(GDSType gdsType) {
        GDSFactoryPlugin gdsPlugin = typeToPluginMap.get(gdsType);
        if (gdsPlugin == null) {
            throw new IllegalArgumentException("Specified GDS type " + gdsType + " is unknown.");
        }
        return gdsPlugin;
    }

    static {
        PluginLoader.findPlugins(GDSFactoryPlugin.class, List.of("org.firebirdsql.gds.impl.wire.WireGDSFactoryPlugin")).forEach(GDSFactory::registerPlugin);
        GDSType pureJavaType = GDSType.getType("PURE_JAVA");
        if (pureJavaType != null && defaultType != pureJavaType && typeToPluginMap.containsKey(pureJavaType)) {
            defaultType = pureJavaType;
        }
    }
}

