/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLWarning;
import java.util.Objects;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ng.BlobLengthProcessor;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.TransactionListener;

public abstract class AbstractFbBlob
implements FbBlob,
TransactionListener,
DatabaseListener {
    private static final System.Logger log = System.getLogger(AbstractFbBlob.class.getName());
    protected final ExceptionListenerDispatcher exceptionListenerDispatcher = new ExceptionListenerDispatcher(this);
    private final BlobParameterBuffer blobParameterBuffer;
    private final int maximumSegmentSize;
    private FbTransaction transaction;
    private FbDatabase database;
    private boolean open;
    private boolean eof;

    protected AbstractFbBlob(FbDatabase database, FbTransaction transaction, BlobParameterBuffer blobParameterBuffer) {
        this.database = database;
        this.transaction = transaction;
        this.blobParameterBuffer = blobParameterBuffer;
        this.maximumSegmentSize = AbstractFbBlob.maximumSegmentSize(database);
        transaction.addWeakTransactionListener(this);
    }

    @Override
    public final boolean isOpen() {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.open;
            return bl;
        }
    }

    @Override
    public final boolean isEof() {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.eof || !this.open;
            return bl;
        }
    }

    protected final void setEof() {
        if (this.isOutput()) {
            return;
        }
        try (LockCloseable ignored = this.withLock();){
            this.eof = true;
        }
    }

    protected final void resetEof() {
        try (LockCloseable ignored = this.withLock();){
            this.eof = false;
        }
    }

    protected final void setOpen(boolean open) {
        try (LockCloseable ignored = this.withLock();){
            FbTransaction transaction;
            FbDatabase database = this.database;
            if (database != null) {
                if (open) {
                    database.addWeakDatabaseListener(this);
                } else {
                    database.removeDatabaseListener(this);
                }
            }
            if (!open && (transaction = this.transaction) != null) {
                transaction.removeTransactionListener(this);
            }
            this.open = open;
        }
    }

    @Override
    public final void close() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (!this.open) {
                return;
            }
            try {
                if (this.isEndingTransaction()) {
                    this.releaseResources();
                } else {
                    this.checkDatabaseAttached();
                    this.checkTransactionActive();
                    this.closeImpl();
                }
            }
            finally {
                this.setOpen(false);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    protected abstract void closeImpl() throws SQLException;

    @Override
    public final void cancel() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                if (this.isEndingTransaction()) {
                    this.releaseResources();
                } else {
                    this.checkDatabaseAttached();
                    this.checkTransactionActive();
                    this.cancelImpl();
                }
            }
            finally {
                this.setOpen(false);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected abstract void cancelImpl() throws SQLException;

    @Override
    public void putSegment(byte[] segment) throws SQLException {
        this.put(segment, 0, segment.length);
    }

    @Override
    public final int get(byte[] b, int off, int len) throws SQLException {
        return this.get(b, off, len, len);
    }

    @Override
    public final int get(byte[] b, int off, int len, float minFillFactor) throws SQLException {
        if (minFillFactor <= 0.0f || minFillFactor > 1.0f || Float.isNaN(minFillFactor)) {
            SQLNonTransientException invalidFloatFactor = new SQLNonTransientException("minFillFactor out of range, must be 0 < minFillFactor <= 1, was: " + minFillFactor);
            this.exceptionListenerDispatcher.errorOccurred(invalidFloatFactor);
            throw invalidFloatFactor;
        }
        return this.get(b, off, len, len != 0 ? Math.max(1, (int)(minFillFactor * (float)len)) : 0);
    }

    protected abstract int get(byte[] var1, int var2, int var3, int var4) throws SQLException;

    protected abstract void releaseResources();

    protected final LockCloseable withLock() {
        FbDatabase database = this.database;
        if (database != null) {
            return database.withLock();
        }
        return LockCloseable.NO_OP;
    }

    @Override
    public void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
        if (this.getTransaction() != transaction) {
            transaction.removeTransactionListener(this);
            return;
        }
        switch (newState) {
            case COMMITTING: 
            case ROLLING_BACK: 
            case PREPARING: {
                try {
                    this.close();
                }
                catch (SQLException e) {
                    log.log(System.Logger.Level.ERROR, "Exception while closing blob during transaction end", (Throwable)e);
                }
                break;
            }
            case COMMITTED: 
            case ROLLED_BACK: {
                try (LockCloseable ignored = this.withLock();){
                    this.clearTransaction();
                    this.setOpen(false);
                    this.releaseResources();
                    break;
                }
            }
        }
    }

    @Override
    public void detaching(FbDatabase database) {
        if (this.database != database) {
            database.removeDatabaseListener(this);
            return;
        }
        try (LockCloseable ignored = this.withLock();){
            if (this.open) {
                log.log(System.Logger.Level.TRACE, "blob with blobId {0} still open on database detach", this.getBlobId());
                try {
                    this.close();
                }
                catch (SQLException e) {
                    log.log(System.Logger.Level.ERROR, "Blob close in detaching event failed", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detached(FbDatabase database) {
        try (LockCloseable ignored = this.withLock();){
            if (this.database == database) {
                this.open = false;
                this.clearDatabase();
                this.clearTransaction();
                this.releaseResources();
            }
        }
        finally {
            database.removeDatabaseListener(this);
        }
    }

    @Override
    public void warningReceived(FbDatabase database, SQLWarning warning) {
    }

    protected final boolean isEndingTransaction() {
        return TransactionHelper.isTransactionEnding(this.getTransaction());
    }

    protected final void checkTransactionActive() throws SQLException {
        TransactionHelper.checkTransactionActive(this.getTransaction(), 335544370);
    }

    protected void checkDatabaseAttached() throws SQLException {
        FbDatabase database = this.database;
        if (database == null || !database.isAttached()) {
            throw FbExceptionBuilder.toNonTransientException(335544372);
        }
    }

    protected void checkBlobOpen() throws SQLException {
        if (!this.isOpen()) {
            throw FbExceptionBuilder.toNonTransientException(335544328);
        }
    }

    protected void checkBlobClosed() throws SQLException {
        if (this.isOpen()) {
            throw FbExceptionBuilder.toNonTransientException(335544355);
        }
    }

    protected FbTransaction getTransaction() {
        try (LockCloseable ignored = this.withLock();){
            FbTransaction fbTransaction = this.transaction;
            return fbTransaction;
        }
    }

    protected final void clearTransaction() {
        FbTransaction transaction;
        try (LockCloseable ignored = this.withLock();){
            transaction = this.transaction;
            this.transaction = null;
        }
        if (transaction != null) {
            transaction.removeTransactionListener(this);
        }
    }

    @Override
    public FbDatabase getDatabase() {
        try (LockCloseable ignored = this.withLock();){
            FbDatabase fbDatabase = this.database;
            return fbDatabase;
        }
    }

    @Override
    public <T> T getBlobInfo(byte[] requestItems, int bufferLength, InfoProcessor<T> infoProcessor) throws SQLException {
        byte[] blobInfo = this.getBlobInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(blobInfo);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public long length() throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            this.checkDatabaseAttached();
            if (this.isOutput() && this.getBlobId() == 0L) {
                throw FbExceptionBuilder.toException(335544329);
            }
            BlobLengthProcessor blobLengthProcessor = this.createBlobLengthProcessor();
            long l = this.getBlobInfo(blobLengthProcessor.getBlobLengthItems(), 20, blobLengthProcessor);
            if (ignored != null) {
                ignored.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.exceptionListenerDispatcher.errorOccurred(e);
                throw e;
            }
        }
    }

    @Override
    public final void addExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.addListener(listener);
    }

    @Override
    public final void removeExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.removeListener(listener);
    }

    protected final void clearDatabase() {
        FbDatabase database;
        try (LockCloseable ignored = this.withLock();){
            database = this.database;
            this.database = null;
        }
        if (database != null) {
            database.removeDatabaseListener(this);
        }
    }

    protected BlobParameterBuffer getBlobParameterBuffer() {
        return this.blobParameterBuffer;
    }

    protected BlobLengthProcessor createBlobLengthProcessor() {
        return new BlobLengthProcessor();
    }

    @Override
    public int getMaximumSegmentSize() {
        return this.maximumSegmentSize;
    }

    private static int maximumSegmentSize(FbDatabase db) {
        if (db != null && db.getServerVersion().isEqualOrAbove(3)) {
            return 65535;
        }
        return 32765;
    }

    protected final void validateBufferLength(byte[] b, int off, int len) throws SQLException {
        try {
            Objects.checkFromIndexSize(off, len, b.length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLNonTransientException(e.toString(), "HY090");
        }
    }
}

