/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.ng.AbstractAttachProperties;
import org.firebirdsql.gds.ng.FbImmutableConnectionProperties;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jaybird.props.internal.ConnectionPropertyRegistry;

public final class FbConnectionProperties
extends AbstractAttachProperties<IConnectionProperties>
implements IConnectionProperties,
Serializable {
    private FbImmutableConnectionProperties immutableConnectionPropertiesCache;

    public FbConnectionProperties(IConnectionProperties src) {
        super(src);
    }

    public FbConnectionProperties() {
        this.setSessionTimeZone(FbConnectionProperties.defaultTimeZone());
        this.setSqlDialect(3);
        try {
            this.setReportSQLWarnings(JaybirdSystemProperties.getDefaultReportSQLWarnings());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Boolean asyncFetch = JaybirdSystemProperties.getDefaultAsyncFetch();
        if (asyncFetch != null) {
            this.setAsyncFetch(asyncFetch);
        }
    }

    private FbConnectionProperties(HashMap<ConnectionProperty, Object> propValues) {
        super(propValues);
    }

    @Override
    public IConnectionProperties asImmutable() {
        if (this.immutableConnectionPropertiesCache == null) {
            this.immutableConnectionPropertiesCache = new FbImmutableConnectionProperties(this);
        }
        return this.immutableConnectionPropertiesCache;
    }

    @Override
    public IConnectionProperties asNewMutable() {
        return new FbConnectionProperties(this);
    }

    @Override
    protected Object resolveStoredDefaultValue(ConnectionProperty property) {
        return switch (property.name()) {
            case "sessionTimeZone" -> FbConnectionProperties.defaultTimeZone();
            case "sqlDialect" -> 3;
            case "asyncFetch" -> JaybirdSystemProperties.getDefaultAsyncFetch();
            default -> super.resolveStoredDefaultValue(property);
        };
    }

    private static String defaultTimeZone() {
        return TimeZone.getDefault().getID();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected void dirtied() {
        this.immutableConnectionPropertiesCache = null;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, Serializable> propValues;

        private SerializationProxy(FbConnectionProperties fbConnectionProperties) {
            Map<ConnectionProperty, Object> srcProps = fbConnectionProperties.connectionPropertyValues();
            this.propValues = new HashMap<String, Serializable>(srcProps.size());
            srcProps.forEach((k, v) -> this.propValues.put(k.name(), (Serializable)v));
        }

        protected Object readResolve() {
            HashMap<ConnectionProperty, Object> targetProps = new HashMap<ConnectionProperty, Object>(this.propValues.size());
            ConnectionPropertyRegistry propertyRegistry = ConnectionPropertyRegistry.getInstance();
            this.propValues.forEach((k, v) -> targetProps.put(propertyRegistry.getOrUnknown((String)k), v));
            return new FbConnectionProperties(targetProps);
        }
    }
}

