/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.firebirdsql.gds.MessageTemplate;
import org.firebirdsql.gds.ng.wire.crypt.FBSQLEncryptException;
import org.firebirdsql.jaybird.util.CollectionUtils;
import org.firebirdsql.jaybird.util.SQLExceptionChainBuilder;
import org.firebirdsql.jdbc.FBSQLExceptionInfo;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class FbExceptionBuilder {
    private static final String SQLSTATE_FEATURE_NOT_SUPPORTED_PREFIX = "0A";
    private static final String SQLSTATE_SYNTAX_ERROR_PREFIX = "42";
    private static final String SQLSTATE_CONNECTION_ERROR_PREFIX = "08";
    private final List<ExceptionInformation> exceptionInfo = new ArrayList<ExceptionInformation>(1);
    private static final Map<Integer, CachedMessage> CACHED_MESSAGE_MAP = new ConcurrentHashMap<Integer, CachedMessage>(4, 1.0f, 1);
    private static final Set<Integer> UNINTERESTING_ERROR_CODES = Set.of(Integer.valueOf(0), Integer.valueOf(335544569), Integer.valueOf(336397208), Integer.valueOf(336397209), Integer.valueOf(335544436), Integer.valueOf(335544570), Integer.valueOf(0x14000001), Integer.valueOf(335544794));
    private static final String SQLSTATE_SUCCESS = "00000";

    public FbExceptionBuilder() {
    }

    private FbExceptionBuilder(Type type, int errorCode) {
        this.setNextExceptionInformation(type, errorCode);
    }

    public FbExceptionBuilder exception(int errorCode) {
        this.setNextExceptionInformation(Type.EXCEPTION, errorCode);
        return this;
    }

    public static FbExceptionBuilder forException(int errorCode) {
        return new FbExceptionBuilder(Type.EXCEPTION, errorCode);
    }

    public static SQLException toException(int errorCode) {
        return FbExceptionBuilder.forException(errorCode).toSQLException();
    }

    public static FbExceptionBuilder forTimeoutException(int errorCode) {
        return new FbExceptionBuilder(Type.TIMEOUT, errorCode);
    }

    public static SQLException toTimeoutException(int errorCode) {
        return FbExceptionBuilder.forTimeoutException(errorCode).toSQLException();
    }

    public static FbExceptionBuilder forNonTransientException(int errorCode) {
        return new FbExceptionBuilder(Type.NON_TRANSIENT, errorCode);
    }

    public static SQLException toNonTransientException(int errorCode) {
        return FbExceptionBuilder.forNonTransientException(errorCode).toSQLException();
    }

    public static FbExceptionBuilder forNonTransientConnectionException(int errorCode) {
        return new FbExceptionBuilder(Type.NON_TRANSIENT_CONNECT, errorCode);
    }

    public static SQLException toNonTransientConnectionException(int errorCode) {
        return FbExceptionBuilder.forNonTransientConnectionException(errorCode).toSQLException();
    }

    public static FbExceptionBuilder forTransientException(int errorCode) {
        return new FbExceptionBuilder(Type.TRANSIENT, errorCode);
    }

    public static SQLException toTransientException(int errorCode) {
        return FbExceptionBuilder.forTransientException(errorCode).toSQLException();
    }

    public static FbExceptionBuilder forWarning(int errorCode) {
        return new FbExceptionBuilder(Type.WARNING, errorCode);
    }

    public static SQLWarning toWarning(int errorCode) {
        return FbExceptionBuilder.forWarning(errorCode).toSQLException(SQLWarning.class);
    }

    private static CachedMessage getCachedMessage(int errorCode) {
        return CACHED_MESSAGE_MAP.computeIfAbsent(errorCode, CachedMessage::of);
    }

    public static SQLException ioWriteError(IOException e) {
        CachedMessage error = FbExceptionBuilder.getCachedMessage(335544727);
        return FbExceptionBuilder.stripBuilderStackTraceElements(new SQLNonTransientConnectionException(error.message, error.sqlState, 335544727, e));
    }

    public static SQLException ioReadError(IOException e) {
        CachedMessage error = FbExceptionBuilder.getCachedMessage(335544726);
        return FbExceptionBuilder.stripBuilderStackTraceElements(new SQLNonTransientConnectionException(error.message, error.sqlState, 335544726, e));
    }

    public static SQLException connectionClosed() {
        CachedMessage error = FbExceptionBuilder.getCachedMessage(337248336);
        return FbExceptionBuilder.stripBuilderStackTraceElements(new SQLNonTransientConnectionException(error.message, error.sqlState, 337248336));
    }

    public FbExceptionBuilder warning(int errorCode) {
        this.setNextExceptionInformation(Type.WARNING, errorCode);
        return this;
    }

    public FbExceptionBuilder timeoutException(int errorCode) {
        this.setNextExceptionInformation(Type.TIMEOUT, errorCode);
        return this;
    }

    public FbExceptionBuilder nonTransientException(int errorCode) {
        this.setNextExceptionInformation(Type.NON_TRANSIENT, errorCode);
        return this;
    }

    public FbExceptionBuilder nonTransientConnectionException(int errorCode) {
        this.setNextExceptionInformation(Type.NON_TRANSIENT_CONNECT, errorCode);
        return this;
    }

    public FbExceptionBuilder transientException(int errorCode) {
        this.setNextExceptionInformation(Type.TRANSIENT, errorCode);
        return this;
    }

    public FbExceptionBuilder messageParameter(int parameter) {
        this.requireExceptionInformation().addMessageParameter(parameter);
        return this;
    }

    public FbExceptionBuilder messageParameter(int param1, int param2) {
        return this.messageParameter((Object)param1, (Object)param2);
    }

    public FbExceptionBuilder messageParameter(@Nullable Object parameter) {
        this.requireExceptionInformation().addMessageParameter(parameter);
        return this;
    }

    public FbExceptionBuilder messageParameter(@Nullable Object param1, @Nullable Object param2) {
        ExceptionInformation current = this.requireExceptionInformation();
        current.addMessageParameter(param1);
        current.addMessageParameter(param2);
        return this;
    }

    public FbExceptionBuilder messageParameter(Object ... params) {
        ExceptionInformation current = this.requireExceptionInformation();
        for (int idx = 0; idx < params.length; ++idx) {
            current.addMessageParameter(params[idx]);
        }
        return this;
    }

    public FbExceptionBuilder sqlState(String sqlState) {
        this.requireExceptionInformation().setSqlState(sqlState);
        return this;
    }

    public FbExceptionBuilder cause(Throwable cause) {
        this.requireExceptionInformation().setCause(cause);
        return this;
    }

    public SQLException toSQLException() {
        this.checkNonEmpty();
        SQLExceptionChainBuilder chain = new SQLExceptionChainBuilder();
        for (ExceptionInformation info : this.exceptionInfo) {
            chain.append(info.toSQLException());
        }
        return chain.getException();
    }

    public SQLException toFlatSQLException() {
        this.checkNonEmpty();
        SQLExceptionChainBuilder chain = new SQLExceptionChainBuilder();
        StringBuilder fullExceptionMessage = new StringBuilder();
        ExceptionInformation interestingExceptionInfo = null;
        for (ExceptionInformation info : this.exceptionInfo) {
            if (interestingExceptionInfo == null && !UNINTERESTING_ERROR_CODES.contains(info.errorCode()) && !SQLSTATE_SUCCESS.equals(info.sqlState())) {
                interestingExceptionInfo = info;
            }
            if (!fullExceptionMessage.isEmpty()) {
                fullExceptionMessage.append("; ");
            }
            info.appendMessage(fullExceptionMessage);
            chain.append(info.toSQLExceptionInfo());
        }
        ExceptionInformation firstExceptionInfo = this.exceptionInfo.get(0);
        if (interestingExceptionInfo == null) {
            interestingExceptionInfo = firstExceptionInfo;
        }
        interestingExceptionInfo.appendErrorInfoSuffix(fullExceptionMessage);
        Type exceptionType = firstExceptionInfo.type != Type.EXCEPTION ? firstExceptionInfo.type : interestingExceptionInfo.type;
        SQLException exception = exceptionType.createSQLException(fullExceptionMessage.toString(), interestingExceptionInfo.sqlState(), interestingExceptionInfo.errorCode());
        exception.initCause(chain.getException());
        return FbExceptionBuilder.stripBuilderStackTraceElements(exception);
    }

    private void checkNonEmpty() {
        if (this.isEmpty()) {
            throw new IllegalStateException("No information available to build an SQLException");
        }
    }

    public <T extends SQLException> T toSQLException(Class<T> type) throws ClassCastException {
        return (T)((SQLException)type.cast(this.toSQLException()));
    }

    public <T extends SQLException> T toFlatSQLException(Class<T> type) throws ClassCastException {
        return (T)((SQLException)type.cast(this.toFlatSQLException()));
    }

    public boolean isEmpty() {
        return this.exceptionInfo.isEmpty();
    }

    public String toString() {
        if (this.exceptionInfo.isEmpty()) {
            return "empty";
        }
        return this.exceptionInfo.toString();
    }

    private void setNextExceptionInformation(Type type, int errorCode) {
        this.exceptionInfo.add(new ExceptionInformation(FbExceptionBuilder.upgradeType(type, errorCode), errorCode));
    }

    private static Type upgradeType(Type type, int errorCode) {
        if (type == Type.EXCEPTION) {
            static enum TypeUpgrades {
                NON_TRANSIENT(335545064, 335545065, 335545066, 335545067, 337248280, 337248281, 337248282, 335544472, 335544727, 335544726, 335544721),
                TIMEOUT(335545127, 335545128, 335545129);

                private final int[] errorCodes;

                private TypeUpgrades(int ... errorCodes) {
                    Arrays.sort(errorCodes);
                    this.errorCodes = errorCodes;
                }

                boolean contains(int errorCode) {
                    return Arrays.binarySearch(this.errorCodes, errorCode) >= 0;
                }
            }
            if (TypeUpgrades.NON_TRANSIENT.contains(errorCode)) {
                return Type.NON_TRANSIENT;
            }
            if (TypeUpgrades.TIMEOUT.contains(errorCode)) {
                return Type.TIMEOUT;
            }
        }
        return type;
    }

    private ExceptionInformation requireExceptionInformation() throws IllegalStateException {
        ExceptionInformation current = CollectionUtils.getLast(this.exceptionInfo);
        if (current == null) {
            throw new IllegalStateException("FbExceptionBuilder requires call to warning() or exception() first");
        }
        return current;
    }

    private static SQLException stripBuilderStackTraceElements(SQLException exception) {
        exception.setStackTrace(FbExceptionBuilder.stripBuilderStackTraceElements(exception.getStackTrace()));
        return exception;
    }

    private static StackTraceElement[] stripBuilderStackTraceElements(StackTraceElement[] stackTraceElements) {
        int startIndex = FbExceptionBuilder.findFirstNonBuilderElement(stackTraceElements);
        if (startIndex <= 0) {
            return stackTraceElements;
        }
        return Arrays.copyOfRange(stackTraceElements, startIndex, stackTraceElements.length);
    }

    private static int findFirstNonBuilderElement(StackTraceElement[] stackTraceElements) {
        String thisClassName = FbExceptionBuilder.class.getName();
        String nestedClassPrefix = thisClassName + "$";
        for (int idx = 0; idx < stackTraceElements.length; ++idx) {
            String className = stackTraceElements[idx].getClassName();
            if (className.equals(thisClassName) || className.startsWith(nestedClassPrefix)) continue;
            return idx;
        }
        return -1;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Type {
        EXCEPTION("HY000"){

            @Override
            public SQLException createSQLException(String message, @Nullable String sqlState, int errorCode) {
                if (sqlState != null) {
                    if (sqlState.startsWith(FbExceptionBuilder.SQLSTATE_FEATURE_NOT_SUPPORTED_PREFIX)) {
                        return new SQLFeatureNotSupportedException(message, sqlState, errorCode);
                    }
                    if (sqlState.startsWith(FbExceptionBuilder.SQLSTATE_SYNTAX_ERROR_PREFIX)) {
                        return new SQLSyntaxErrorException(message, sqlState, errorCode);
                    }
                }
                return new SQLException(message, sqlState, errorCode);
            }
        }
        ,
        WARNING("01000"){

            @Override
            public SQLException createSQLException(String message, @Nullable String sqlState, int errorCode) {
                return new SQLWarning(message, sqlState, errorCode);
            }
        }
        ,
        TIMEOUT("HY000"){

            @Override
            public SQLException createSQLException(String message, @Nullable String sqlState, int errorCode) {
                return new SQLTimeoutException(message, sqlState, errorCode);
            }
        }
        ,
        NON_TRANSIENT("HY000"){

            @Override
            public SQLException createSQLException(String message, @Nullable String sqlState, int errorCode) {
                return switch (errorCode) {
                    case 335545064, 335545065, 335545066, 335545067, 337248280, 337248281, 337248282 -> new FBSQLEncryptException(message, sqlState, errorCode);
                    case 335544472 -> new SQLInvalidAuthorizationSpecException(message, sqlState, errorCode);
                    default -> {
                        if (sqlState != null) {
                            if (sqlState.startsWith(FbExceptionBuilder.SQLSTATE_FEATURE_NOT_SUPPORTED_PREFIX)) {
                                yield new SQLFeatureNotSupportedException(message, sqlState, errorCode);
                            }
                            if (sqlState.startsWith(FbExceptionBuilder.SQLSTATE_SYNTAX_ERROR_PREFIX)) {
                                yield new SQLSyntaxErrorException(message, sqlState, errorCode);
                            }
                            if (sqlState.startsWith(FbExceptionBuilder.SQLSTATE_CONNECTION_ERROR_PREFIX)) {
                                yield new SQLNonTransientConnectionException(message, sqlState, errorCode);
                            }
                        }
                        yield new SQLNonTransientException(message, sqlState, errorCode);
                    }
                };
            }
        }
        ,
        NON_TRANSIENT_CONNECT("08000"){

            @Override
            public SQLException createSQLException(String message, @Nullable String sqlState, int errorCode) {
                return new SQLNonTransientConnectionException(message, sqlState, errorCode);
            }
        }
        ,
        TRANSIENT("HY000"){

            @Override
            public SQLException createSQLException(String message, @Nullable String sqlState, int errorCode) {
                return new SQLTransientException(message, sqlState, errorCode);
            }
        };

        private final String defaultSQLState;

        private Type(String defaultSQLState) {
            this.defaultSQLState = Objects.requireNonNull(defaultSQLState, "defaultSQLState");
        }

        public final String getDefaultSQLState() {
            return this.defaultSQLState;
        }

        public abstract SQLException createSQLException(String var1, @Nullable String var2, int var3);
    }

    private record CachedMessage(String message, String sqlState) {
        private static CachedMessage of(int errorCode) {
            SQLException exception = FbExceptionBuilder.toException(errorCode);
            return new CachedMessage(exception.getMessage(), exception.getSQLState());
        }
    }

    private static final class ExceptionInformation {
        private final Type type;
        private final List<@Nullable Object> messageParameters = new ArrayList<Object>();
        private MessageTemplate messageTemplate;
        private @Nullable Throwable cause;

        ExceptionInformation(Type type, int errorCode) {
            this.type = Objects.requireNonNull(type, "type");
            this.messageTemplate = MessageTemplate.of(errorCode).withDefaultSqlState(type.getDefaultSQLState());
        }

        int errorCode() {
            return this.messageTemplate.errorCode();
        }

        @Nullable String sqlState() {
            return this.messageTemplate.sqlState();
        }

        void setSqlState(String sqlState) {
            this.messageTemplate = this.messageTemplate.withSqlState(sqlState);
        }

        void setCause(Throwable cause) {
            this.cause = cause;
        }

        void addMessageParameter(@Nullable Object argument) {
            this.messageParameters.add(argument);
        }

        String toMessage() {
            return this.messageTemplate.toMessage(this.messageParameters);
        }

        void appendMessage(StringBuilder messageBuffer) {
            this.messageTemplate.appendMessage(messageBuffer, this.messageParameters);
        }

        void appendErrorInfoSuffix(StringBuilder messageBuffer) {
            this.messageTemplate.appendErrorInfoSuffix(messageBuffer);
        }

        SQLException toSQLException() {
            StringBuilder messageBuffer = new StringBuilder(0);
            this.appendMessage(messageBuffer);
            this.appendErrorInfoSuffix(messageBuffer);
            SQLException result = this.type.createSQLException(messageBuffer.toString(), this.sqlState(), this.errorCode());
            if (this.cause != null) {
                result.initCause(this.cause);
            }
            return FbExceptionBuilder.stripBuilderStackTraceElements(result);
        }

        FBSQLExceptionInfo toSQLExceptionInfo() {
            FBSQLExceptionInfo result = new FBSQLExceptionInfo(this.toMessage(), this.sqlState(), this.errorCode());
            if (this.cause != null) {
                result.initCause(this.cause);
            }
            return result;
        }

        public String toString() {
            return "Type: " + this.type + "; ErrorCode: " + this.errorCode() + "; Message: \"" + this.toMessage() + "\"; SQLstate: " + this.sqlState() + "; MessageParameters: " + this.messageParameters + "; Cause: " + this.cause;
        }
    }
}

