/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.listeners;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class AbstractListenerDispatcher<L>
implements Iterable<L> {
    private final CopyOnWriteArrayList<L> listeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<WeakReference<L>> weakListeners = new CopyOnWriteArrayList();
    private volatile boolean shutdown = false;

    public final void addListener(L listener) {
        if (listener == this) {
            throw new IllegalArgumentException("Adding this instance to itself is not allowed");
        }
        if (this.isShutdown()) {
            return;
        }
        this.listeners.addIfAbsent(listener);
    }

    public final void addWeakListener(L listener) {
        if (listener == this) {
            throw new IllegalArgumentException("Adding this instance to itself is not allowed");
        }
        if (this.isShutdown() || this.listeners.contains(listener)) {
            return;
        }
        this.removeListener(listener);
        WeakReference<L> weakReference = new WeakReference<L>(listener);
        this.weakListeners.add(weakReference);
        this.cleanWeakListeners();
    }

    public final void removeListener(L listener) {
        if (this.listeners.remove(listener)) {
            return;
        }
        this.weakListeners.removeIf(ref -> {
            Object refValue = ref.get();
            return refValue == null || refValue == listener;
        });
    }

    protected final void notify(Consumer<L> notificationHandler, String notificationLogName) {
        for (L listener : this) {
            try {
                notificationHandler.accept(listener);
            }
            catch (Exception e) {
                this.logError("Error on notify " + notificationLogName + " to listener " + listener, e);
            }
        }
    }

    protected abstract void logError(String var1, Throwable var2);

    public final void removeAllListeners() {
        this.listeners.clear();
        this.weakListeners.clear();
    }

    public final void shutdown() {
        this.shutdown = true;
        this.removeAllListeners();
    }

    public final boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public final Iterator<L> iterator() {
        this.cleanWeakListeners();
        return new ListenerIterator<L>(this.listeners, this.weakListeners);
    }

    private void cleanWeakListeners() {
        this.weakListeners.removeIf(ref -> ref.get() == null);
    }

    private static final class ListenerIterator<L>
    implements Iterator<L> {
        private final ListIterator<L> strongIterator;
        private final ListIterator<WeakReference<L>> weakIterator;
        private boolean useStrongIterator;
        private L nextWeakListener;

        private ListenerIterator(CopyOnWriteArrayList<L> strongListeners, CopyOnWriteArrayList<WeakReference<L>> weakListeners) {
            this.strongIterator = ListenerIterator.listIteratorAtEnd(strongListeners);
            this.weakIterator = ListenerIterator.listIteratorAtEnd(weakListeners);
        }

        @Override
        public boolean hasNext() {
            if (!this.useStrongIterator) {
                if (this.getNextWeakListener() != null) {
                    return true;
                }
                this.useStrongIterator = true;
            }
            return this.strongIterator.hasPrevious();
        }

        @Override
        public L next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.useStrongIterator) {
                return this.strongIterator.previous();
            }
            L next = this.nextWeakListener;
            this.nextWeakListener = null;
            return next;
        }

        private L getNextWeakListener() {
            ListIterator<WeakReference<L>> weakIterator = this.weakIterator;
            Object nextWeakListener = this.nextWeakListener;
            while (nextWeakListener == null && weakIterator.hasPrevious()) {
                WeakReference<L> currentRef = weakIterator.previous();
                nextWeakListener = currentRef.get();
            }
            this.nextWeakListener = nextWeakListener;
            return this.nextWeakListener;
        }

        private static <T> ListIterator<T> listIteratorAtEnd(CopyOnWriteArrayList<T> list) {
            ListIterator<T> listIterator;
            try {
                listIterator = list.listIterator(Math.max(0, list.size() - 1));
            }
            catch (IndexOutOfBoundsException e) {
                listIterator = list.listIterator();
            }
            while (listIterator.hasNext()) {
                listIterator.next();
            }
            return listIterator;
        }
    }
}

