/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbBlob;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.wire.FbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;

public abstract class AbstractFbWireBlob
extends AbstractFbBlob
implements FbWireBlob {
    private int blobHandle;

    protected AbstractFbWireBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer) {
        super(database, transaction, blobParameterBuffer);
    }

    @Override
    public FbWireDatabase getDatabase() {
        return (FbWireDatabase)super.getDatabase();
    }

    @Override
    public final int getHandle() {
        try (LockCloseable ignored = this.withLock();){
            int n = this.blobHandle;
            return n;
        }
    }

    protected final void setHandle(int blobHandle) {
        try (LockCloseable ignored = this.withLock();){
            this.blobHandle = blobHandle;
        }
    }

    protected void releaseBlob(int releaseOperation) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.getDatabase().releaseObject(releaseOperation, this.getHandle());
        }
    }

    protected final void sendOpen(BlobOpenOperation openOperation) throws SQLException {
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            BlobParameterBuffer blobParameterBuffer = this.getBlobParameterBuffer();
            if (blobParameterBuffer == null) {
                xdrOut.writeInt(openOperation.opCodeWithoutBpb());
            } else {
                xdrOut.writeInt(openOperation.opCodeWithBpb());
                xdrOut.writeTyped(blobParameterBuffer);
            }
            xdrOut.writeInt(this.getTransaction().getHandle());
            xdrOut.writeLong(this.getBlobId());
            xdrOut.flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    @Override
    protected void closeImpl() throws SQLException {
        try {
            this.releaseBlob(39);
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void cancelImpl() throws SQLException {
        try {
            this.releaseBlob(38);
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void releaseResources() {
    }

    @Override
    public byte[] getBlobInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try {
            return this.getDatabase().getInfo(43, this.getHandle(), requestItems, bufferLength, null);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected final XdrInputStream getXdrIn() throws SQLException {
        return this.getXdrStreamAccess().getXdrIn();
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getXdrStreamAccess().getXdrOut();
    }

    private XdrStreamAccess getXdrStreamAccess() {
        return this.getDatabase().getXdrStreamAccess();
    }

    protected static enum BlobOpenOperation {
        INPUT_BLOB(35, 56),
        OUTPUT_BLOB(34, 57);

        private final int opCodeWithoutBpb;
        private final int opCodeWithBpb;

        private BlobOpenOperation(int opCodeWithoutBpb, int opCodeWithBpb) {
            this.opCodeWithoutBpb = opCodeWithoutBpb;
            this.opCodeWithBpb = opCodeWithBpb;
        }

        public final int opCodeWithoutBpb() {
            return this.opCodeWithoutBpb;
        }

        public final int opCodeWithBpb() {
            return this.opCodeWithBpb;
        }
    }
}

