/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt;

import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfigImpl;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;

public interface CryptSessionConfig
extends AutoCloseable {
    public EncryptionIdentifier encryptionIdentifier();

    public byte[] encryptKey();

    public byte[] decryptKey();

    public byte[] specificData();

    @Override
    public void close();

    public static CryptSessionConfig symmetric(EncryptionIdentifier encryptionIdentifier, byte[] sessionKey, byte[] specificData) {
        if (encryptionIdentifier.isTypeSymmetric()) {
            return new CryptSessionConfigImpl(encryptionIdentifier, sessionKey, sessionKey, specificData);
        }
        throw new IllegalArgumentException("Wrong type for encryption identifier. Expected 'Symmetric/*', was '" + encryptionIdentifier + "'");
    }
}

