/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.CursorFlag;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.SqlCountHolder;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jaybird.parser.LocalStatementClass;
import org.firebirdsql.jaybird.parser.LocalStatementType;
import org.firebirdsql.jaybird.parser.StatementDetector;
import org.firebirdsql.jaybird.util.Primitives;
import org.firebirdsql.jaybird.util.SQLExceptionThrowingFunction;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.FirebirdStatement;
import org.firebirdsql.jdbc.GeneratedKeysSupport;
import org.firebirdsql.jdbc.QuoteStrategy;
import org.firebirdsql.jdbc.ResultSetBehavior;
import org.firebirdsql.util.FirebirdSupportInfo;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class FBStatement
extends AbstractStatement
implements FirebirdStatement {
    private static final System.Logger log = System.getLogger(FBStatement.class.getName());
    protected final GDSHelper gdsHelper;
    protected final FBObjectListener.StatementListener statementListener;
    protected final FbStatement fbStatement;
    private @Nullable FBResultSet currentRs;
    private @Nullable SqlCountHolder sqlCountHolder;
    private boolean completed = true;
    private boolean escapedProcessing = true;
    private boolean currentStatementGeneratedKeys;
    private LocalStatementType jbStatementType = LocalStatementType.OTHER;
    protected StatementResult currentStatementResult = StatementResult.NO_MORE_RESULTS;
    protected boolean isSingletonResult;
    protected final List<RowValue> specialResult = new ArrayList<RowValue>();
    private int maxFieldSize;
    private final FBObjectListener.ResultSetListener resultSetListener = new RSListener();
    private static final Set<StatementState> INVALID_STATEMENT_STATES = EnumSet.of(StatementState.ERROR, StatementState.CLOSING, StatementState.CLOSED);
    private static final int INSERTED_ROWS_COUNT = 1;
    private static final int UPDATED_ROWS_COUNT = 2;
    private static final int DELETED_ROWS_COUNT = 3;
    private List<String> batchList = new ArrayList<String>();
    private static final Set<StatementState> NO_EXECUTION_PLAN_STATE = Set.of(StatementState.NEW, StatementState.ALLOCATED);
    private static final Pattern SIMPLE_IDENTIFIER_PATTERN = Pattern.compile("\\p{Alpha}[\\p{Alnum}_$]*");

    protected FBStatement(FBConnection connection, ResultSetBehavior rsBehavior, FBObjectListener.StatementListener statementListener) throws SQLException {
        super(connection, rsBehavior);
        this.gdsHelper = connection.getGDSHelper();
        this.statementListener = statementListener;
        try (LockCloseable ignored = connection.withLock();){
            this.fbStatement = this.gdsHelper.allocateStatement();
            this.fbStatement.addStatementListener(this.createStatementListener());
            if (this.needsScrollableCursorEnabled()) {
                this.fbStatement.setCursorFlag(CursorFlag.CURSOR_TYPE_SCROLLABLE);
            }
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && !INVALID_STATEMENT_STATES.contains((Object)this.fbStatement.getState());
    }

    @Override
    public void completeStatement(CompletionReason reason) throws SQLException {
        if (this.currentRs != null && (reason != CompletionReason.COMMIT || this.currentRs.getHoldability() == 2)) {
            this.closeResultSet(false, reason);
        }
        if (reason == CompletionReason.CONNECTION_ABORT) {
            this.completed = true;
            super.close();
        } else {
            this.notifyStatementCompleted();
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.currentStatementGeneratedKeys = false;
            FBStatement.rejectIfTxStmt(sql, 337248312);
            this.notifyStatementStarted();
            try {
                if (!this.internalExecute(sql)) {
                    throw FBStatement.queryProducedNoResultSet();
                }
                FBResultSet rs = this.getResultSet(false);
                assert (rs != null) : "a non-null ResultSet is required at this point";
                FBResultSet fBResultSet = rs;
                return fBResultSet;
            }
            catch (Exception e) {
                this.notifyStatementCompleted(true, e);
                throw e;
            }
        }
    }

    static void rejectIfTxStmt(String sql, int errorCode) throws SQLException {
        if (StatementDetector.determineLocalStatementType(sql).statementClass() == LocalStatementClass.TRANSACTION_BOUNDARY) {
            throw FbExceptionBuilder.toNonTransientException(errorCode);
        }
    }

    protected void notifyStatementStarted() throws SQLException {
        this.notifyStatementStarted(true);
    }

    protected void notifyStatementStarted(boolean closeResultSet) throws SQLException {
        if (closeResultSet) {
            this.closeResultSet(false);
        }
        this.statementListener.executionStarted(this);
        this.fbStatement.setTransaction(this.gdsHelper.getCurrentTransaction());
        this.completed = false;
    }

    protected void notifyStatementCompleted() throws SQLException {
        this.notifyStatementCompleted(true);
    }

    protected void notifyStatementCompleted(boolean success) throws SQLException {
        if (!this.completed) {
            this.completed = true;
            this.statementListener.statementCompleted(this, success);
        }
    }

    void notifyStatementCompleted(boolean success, Exception originalException) {
        try {
            this.notifyStatementCompleted(success);
        }
        catch (SQLException e) {
            if (originalException instanceof SQLException) {
                SQLException sqle = (SQLException)originalException;
                sqle.setNextException(e);
            } else {
                originalException.addSuppressed(e);
            }
        }
        catch (RuntimeException e) {
            originalException.addSuppressed(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.currentStatementGeneratedKeys = false;
            if (this.executeIfTransactionStatement(sql)) {
                int n = 0;
                return n;
            }
            this.notifyStatementStarted();
            try {
                if (this.internalExecute(sql)) {
                    throw FBStatement.updateReturnedResultSet();
                }
                int updateCount = this.getUpdateCountMinZero();
                this.notifyStatementCompleted();
                int n = updateCount;
                return n;
            }
            catch (Exception e) {
                this.notifyStatementCompleted(true, e);
                throw e;
            }
        }
    }

    boolean executeIfTransactionStatement(String sql) throws SQLException {
        LocalStatementType statementType = StatementDetector.determineLocalStatementType(sql);
        return switch (statementType) {
            case LocalStatementType.HARD_COMMIT -> {
                this.connection.handleHardCommitStatement();
                this.sqlCountHolder = SqlCountHolder.empty();
                yield true;
            }
            case LocalStatementType.HARD_ROLLBACK -> {
                this.connection.handleHardRollbackStatement();
                this.sqlCountHolder = SqlCountHolder.empty();
                yield true;
            }
            case LocalStatementType.SET_TRANSACTION -> {
                this.connection.handleSetTransactionStatement(sql);
                this.sqlCountHolder = SqlCountHolder.empty();
                yield true;
            }
            default -> false;
        };
    }

    static SQLException queryProducedNoResultSet() {
        return new SQLNonTransientException("Query did not produce a result set", "07005");
    }

    static SQLException updateReturnedResultSet() {
        return new SQLNonTransientException("Update statement returned result set", "07003");
    }

    static SQLException batchStatementReturnedResultSet() {
        return new SQLNonTransientException("Statement executed as batch returned result set", "07003");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, autoGeneratedKeys)) {
                SQLException e = FBStatement.updateReturnedResultSet();
                this.notifyStatementCompleted(true, e);
                throw e;
            }
            int n = this.getUpdateCountMinZero();
            return n;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, columnIndexes)) {
                SQLException e = FBStatement.updateReturnedResultSet();
                this.notifyStatementCompleted(true, e);
                throw e;
            }
            int n = this.getUpdateCountMinZero();
            return n;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, columnNames)) {
                SQLException e = FBStatement.updateReturnedResultSet();
                this.notifyStatementCompleted(true, e);
                throw e;
            }
            int n = this.getUpdateCountMinZero();
            return n;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.connection.getGeneratedKeysSupport().buildQuery(sql, autoGeneratedKeys);
            boolean bl = this.executeImpl(query);
            return bl;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.connection.getGeneratedKeysSupport().buildQuery(sql, columnIndexes);
            boolean bl = this.executeImpl(query);
            return bl;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.connection.getGeneratedKeysSupport().buildQuery(sql, columnNames);
            boolean bl = this.executeImpl(query);
            return bl;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkValidity();
        if (this.isGeneratedKeyQuery()) {
            return new FBResultSet(this.fbStatement.getRowDescriptor(), this.connection, this.specialResult, this.resultSetListener, true);
        }
        return new FBResultSet(this.fbStatement.emptyRowDescriptor(), Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try (LockCloseable ignored = this.withLock();){
            try (FbStatement ignored2 = this.fbStatement;){
                this.closeResultSet(false, CompletionReason.STATEMENT_CLOSE);
            }
            finally {
                this.batchList = Collections.emptyList();
                super.close();
                this.statementListener.statementClosed(this);
            }
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new SQLNonTransientException("Can't set max field size negative", "HY090");
        }
        this.maxFieldSize = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapedProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            int n = (int)TimeUnit.MILLISECONDS.toSeconds(this.fbStatement.getTimeout());
            return n;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.fbStatement.setTimeout(TimeUnit.SECONDS.toMillis(seconds));
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkValidity();
        if (!FirebirdSupportInfo.supportInfoFor(this.connection).supportsCancelOperation()) {
            throw new SQLFeatureNotSupportedException("Cancel not supported");
        }
        this.gdsHelper.cancelOperation();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkValidity();
        this.currentStatementGeneratedKeys = false;
        return this.executeImpl(sql);
    }

    protected boolean executeImpl(String sql) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.executeIfTransactionStatement(sql)) {
                boolean bl = false;
                return bl;
            }
            this.notifyStatementStarted();
            try {
                boolean hasResultSet = this.internalExecute(sql);
                if (!hasResultSet) {
                    this.notifyStatementCompleted();
                }
                boolean bl = hasResultSet;
                return bl;
            }
            catch (Exception e) {
                this.notifyStatementCompleted(true, e);
                throw e;
            }
        }
    }

    private boolean executeImpl(GeneratedKeysSupport.Query query) throws SQLException {
        this.currentStatementGeneratedKeys = query.generatesKeys();
        return this.executeImpl(query.getQueryString());
    }

    @Override
    public @Nullable ResultSet getResultSet() throws SQLException {
        this.checkValidity();
        return this.getResultSet(false);
    }

    protected @Nullable FBResultSet getResultSet(boolean metaDataQuery) throws SQLException {
        if (this.fbStatement.getState() == StatementState.NEW || this.fbStatement.getType() == StatementType.NONE) {
            throw new SQLException("No statement was executed", "26000");
        }
        if (this.currentRs != null) {
            return this.currentRs;
        }
        if (!this.isGeneratedKeyQuery() && this.currentStatementResult.isResultSet()) {
            if (!this.isSingletonResult) {
                String cursorName = this.getCursorName();
                if (cursorName != null) {
                    this.fbStatement.setCursorName(cursorName);
                }
                this.currentRs = new FBResultSet(this, this.resultSetListener, metaDataQuery);
                return this.currentRs;
            }
            if (!this.specialResult.isEmpty()) {
                this.currentRs = this.createSpecialResultSet(this.resultSetListener);
                return this.currentRs;
            }
        }
        return null;
    }

    protected FBResultSet createSpecialResultSet(@Nullable FBObjectListener.ResultSetListener resultSetListener) throws SQLException {
        return new FBResultSet(this.fbStatement.getRowDescriptor(), this.connection, this.specialResult, resultSetListener, true);
    }

    @Override
    public boolean hasOpenResultSet() {
        return this.currentRs != null;
    }

    protected final int getUpdateCountMinZero() throws SQLException {
        return Math.max(0, this.getUpdateCount());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkValidity();
        if (this.currentStatementResult != StatementResult.UPDATE_COUNT) {
            return -1;
        }
        SqlCountHolder sqlCountHolder = this.populateSqlCounts();
        int insCount = sqlCountHolder.getIntegerInsertCount();
        int updCount = sqlCountHolder.getIntegerUpdateCount();
        int delCount = sqlCountHolder.getIntegerDeleteCount();
        return Math.max(Math.max(updCount, delCount), insCount);
    }

    private SqlCountHolder populateSqlCounts() throws SQLException {
        SqlCountHolder sqlCountHolder = this.sqlCountHolder;
        if (sqlCountHolder != null) {
            return sqlCountHolder;
        }
        this.sqlCountHolder = this.fbStatement.getSqlCounts();
        return this.sqlCountHolder;
    }

    private int getChangedRowsCount(int type) throws SQLException {
        if (this.currentStatementResult != StatementResult.UPDATE_COUNT) {
            return -1;
        }
        SqlCountHolder sqlCountHolder = this.populateSqlCounts();
        return switch (type) {
            case 1 -> sqlCountHolder.getIntegerInsertCount();
            case 2 -> sqlCountHolder.getIntegerUpdateCount();
            case 3 -> sqlCountHolder.getIntegerDeleteCount();
            default -> throw new IllegalArgumentException(String.format("Specified type %d is unknown", type));
        };
    }

    @Override
    public int getDeletedRowsCount() throws SQLException {
        return this.getChangedRowsCount(3);
    }

    @Override
    public int getInsertedRowsCount() throws SQLException {
        return this.getChangedRowsCount(1);
    }

    @Override
    public int getUpdatedRowsCount() throws SQLException {
        return this.getChangedRowsCount(2);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public boolean getMoreResults(int mode) throws SQLException {
        boolean closeResultSet;
        this.checkValidity();
        boolean bl = closeResultSet = mode == 3 || mode == 1;
        if (this.currentStatementResult.isResultSet() && closeResultSet) {
            this.closeResultSet(true);
        }
        this.currentStatementResult = this.currentStatementResult.nextResult();
        return this.currentStatementResult.isResultSet();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkValidity();
        FBStatement.rejectIfTxStmt(sql, 337248319);
        try (LockCloseable ignored = this.withLock();){
            this.batchList.add(sql);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            this.batchList.clear();
        }
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        if (this.connection.getAutoCommit()) {
            this.addWarning(new SQLWarning("Batch updates should be run with auto-commit disabled", "01000"));
        }
        return Primitives.toIntArray(this.executeBatchInternal());
    }

    /*
     * Exception decompiling
     */
    protected List<Long> executeBatchInternal() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long executeSingleForBatch(String sql) throws SQLException {
        if (this.internalExecute(sql)) {
            throw FBStatement.batchStatementReturnedResultSet();
        }
        return this.getLargeUpdateCountMinZero();
    }

    protected final BatchUpdateException createBatchUpdateException(SQLException cause, List<? extends Number> updateCounts) {
        return this.createBatchUpdateException(cause.getMessage(), cause.getSQLState(), cause.getErrorCode(), updateCounts, cause);
    }

    protected final BatchUpdateException createBatchUpdateException(String reason, @Nullable String sqlState, int vendorCode, List<? extends Number> updateCounts, Throwable cause) {
        return new BatchUpdateException(reason, sqlState, vendorCode, Primitives.toLongArray(updateCounts), cause);
    }

    @Override
    protected final FbStatement getStatementHandle() throws SQLException {
        this.checkValidity();
        return this.fbStatement;
    }

    void closeResultSet(boolean notifyListener) throws SQLException {
        this.closeResultSet(notifyListener, CompletionReason.OTHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeResultSet(boolean notifyListener, CompletionReason completionReason) throws SQLException {
        boolean wasCompleted = this.completed;
        try {
            FBResultSet currentRs = this.currentRs;
            if (currentRs != null) {
                this.currentRs = null;
                currentRs.close(notifyListener, completionReason);
            }
        }
        finally {
            try {
                this.fbStatement.ensureClosedCursor(completionReason.isTransactionEnd());
            }
            finally {
                if (notifyListener && !wasCompleted) {
                    this.statementListener.statementCompleted(this);
                }
            }
        }
    }

    @Override
    @Deprecated(since="6", forRemoval=true)
    public @Nullable ResultSet getCurrentResultSet() throws SQLException {
        return this.getResultSet();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == null) {
            return false;
        }
        if (FbStatement.class.isAssignableFrom(iface)) {
            try (LockCloseable ignored = this.withLock();){
                boolean bl = iface.isInstance(this.fbStatement);
                return bl;
            }
        }
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface != null) {
            if (iface.isAssignableFrom(this.getClass())) {
                return iface.cast(this);
            }
            if (FbStatement.class.isAssignableFrom(iface)) {
                try (LockCloseable ignored = this.withLock();){
                    if (iface.isInstance(this.fbStatement)) {
                        T t = iface.cast(this.fbStatement);
                        return t;
                    }
                }
            }
        }
        throw FbExceptionBuilder.forException(337248338).messageParameter((Object)(iface != null ? iface.getName() : "(null)")).toSQLException();
    }

    protected boolean internalExecute(String sql) throws SQLException {
        this.checkValidity();
        this.prepareFixedStatement(sql);
        return this.internalExecute(RowValue.EMPTY_ROW_VALUE);
    }

    protected boolean internalExecute(RowValue rowValue) throws SQLException {
        try {
            this.fbStatement.execute(rowValue);
            boolean hasResultSet = this.currentStatementResult.isResultSet();
            if (hasResultSet && this.isGeneratedKeyQuery()) {
                this.fetchMultiRowGeneratedKeys();
                return false;
            }
            return hasResultSet;
        }
        catch (SQLException e) {
            this.currentStatementResult = StatementResult.NO_MORE_RESULTS;
            throw e;
        }
    }

    private void fetchMultiRowGeneratedKeys() throws SQLException {
        RowsFetchedListener rowsFetchedListener = new RowsFetchedListener();
        try {
            this.fbStatement.addStatementListener(rowsFetchedListener);
            while (!rowsFetchedListener.isAllRowsFetched()) {
                this.fbStatement.fetchRows(Integer.MAX_VALUE);
            }
            this.fbStatement.closeCursor();
            this.currentStatementResult = StatementResult.UPDATE_COUNT;
        }
        finally {
            this.fbStatement.removeStatementListener(rowsFetchedListener);
        }
    }

    protected void prepareFixedStatement(String sql) throws SQLException {
        this.fbStatement.setTransaction(this.gdsHelper.getCurrentTransaction());
        String statementText = this.escapedProcessing ? this.nativeSQL(sql) : sql;
        this.fbStatement.prepare(statementText);
        StatementType fbStatementType = this.fbStatement.getType();
        this.jbStatementType = fbStatementType == StatementType.SELECT || fbStatementType == StatementType.STORED_PROCEDURE ? StatementDetector.determineLocalStatementType(statementText) : LocalStatementType.OTHER;
    }

    private boolean needsScrollableCursorEnabled() {
        ResultSetBehavior resultSetBehavior = this.resultSetBehavior();
        return resultSetBehavior.isScrollable() && resultSetBehavior.isCloseCursorsAtCommit() && this.connection.isScrollableCursor("SERVER") && this.fbStatement.supportsFetchScroll();
    }

    protected String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    protected boolean isGeneratedKeyQuery() {
        return this.currentStatementGeneratedKeys;
    }

    private @Nullable String getExecutionPlan(SQLExceptionThrowingFunction<FbStatement, @Nullable String> getPlanFunction) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (NO_EXECUTION_PLAN_STATE.contains((Object)this.fbStatement.getState())) {
                String string = FBStatement.noExecutionPlan();
                return string;
            }
            String string = getPlanFunction.apply(this.fbStatement);
            return string;
        }
    }

    private static String noExecutionPlan() throws SQLException {
        throw new SQLException("No statement was executed or prepared, plan cannot be obtained", "26000");
    }

    @Override
    public final @Nullable String getExecutionPlan() throws SQLException {
        return this.getExecutionPlan(FbStatement::getExecutionPlan);
    }

    @Override
    public final @Nullable String getExplainedExecutionPlan() throws SQLException {
        return this.getExecutionPlan(FbStatement::getExplainedExecutionPlan);
    }

    @Override
    public final int getStatementType() {
        return this.fbStatement.getType().getStatementTypeCode();
    }

    protected final long getLargeUpdateCountMinZero() throws SQLException {
        return Math.max(0L, this.getLargeUpdateCount());
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkValidity();
        if (this.currentStatementResult != StatementResult.UPDATE_COUNT) {
            return -1L;
        }
        SqlCountHolder sqlCountHolder = this.populateSqlCounts();
        long insCount = sqlCountHolder.insertCount();
        long updCount = sqlCountHolder.updateCount();
        long delCount = sqlCountHolder.deleteCount();
        return Math.max(Math.max(insCount, updCount), delCount);
    }

    @Override
    public final long[] executeLargeBatch() throws SQLException {
        if (this.connection.getAutoCommit()) {
            this.addWarning(new SQLWarning("Batch updates should be run with auto-commit disabled", "01000"));
        }
        return Primitives.toLongArray(this.executeBatchInternal());
    }

    @Override
    public final long executeLargeUpdate(String sql) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.executeUpdate(sql);
            long l = this.getLargeUpdateCountMinZero();
            return l;
        }
    }

    @Override
    public final long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, autoGeneratedKeys)) {
                throw FBStatement.updateReturnedResultSet();
            }
            long l = this.getLargeUpdateCountMinZero();
            return l;
        }
    }

    @Override
    public final long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, columnIndexes)) {
                throw FBStatement.updateReturnedResultSet();
            }
            long l = this.getLargeUpdateCountMinZero();
            return l;
        }
    }

    @Override
    public final long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, columnNames)) {
                throw FBStatement.updateReturnedResultSet();
            }
            long l = this.getLargeUpdateCountMinZero();
            return l;
        }
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        if (this.gdsHelper.getCurrentDatabase().getDatabaseDialect() == 1) {
            return "\"" + val.replace("\"", "\"\"") + "\"";
        }
        return "'" + val.replace("'", "''") + "'";
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return this.enquoteLiteral(val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        int len = identifier.length();
        if (len < 1 || len > this.connection.getMetaData().getMaxColumnNameLength()) {
            throw new SQLException("Invalid name");
        }
        if (!alwaysQuote && SIMPLE_IDENTIFIER_PATTERN.matcher(identifier).matches()) {
            return identifier;
        }
        QuoteStrategy quoteStrategy = this.connection.getQuoteStrategy();
        if (quoteStrategy == QuoteStrategy.DIALECT_1) {
            throw new SQLFeatureNotSupportedException("Quoted identifiers not supported in dialect 1");
        }
        if (identifier.matches("^\".+\"$")) {
            return identifier;
        }
        return quoteStrategy.quoteObjectName(identifier);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        int len = identifier.length();
        return len >= 1 && len <= this.connection.getMetaData().getMaxColumnNameLength() && SIMPLE_IDENTIFIER_PATTERN.matcher(identifier).matches();
    }

    protected StatementListener createStatementListener() {
        return new FBStatementListener();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum StatementResult {
        RESULT_SET(true){

            @Override
            public StatementResult nextResult() {
                return NO_MORE_RESULTS;
            }
        }
        ,
        RESULT_SET_WITH_UPDATE_COUNT(true){

            @Override
            public StatementResult nextResult() {
                return UPDATE_COUNT;
            }
        }
        ,
        UPDATE_COUNT(false){

            @Override
            public StatementResult nextResult() {
                return NO_MORE_RESULTS;
            }
        }
        ,
        NO_MORE_RESULTS(false){

            @Override
            public StatementResult nextResult() {
                return NO_MORE_RESULTS;
            }
        };

        private final boolean resultSet;

        private StatementResult(boolean resultSet) {
            this.resultSet = resultSet;
        }

        public abstract StatementResult nextResult();

        public final boolean isResultSet() {
            return this.resultSet;
        }
    }

    private final class RSListener
    implements FBObjectListener.ResultSetListener {
        private boolean rowUpdaterSeparateTransaction;

        private RSListener() {
        }

        @Override
        public void resultSetClosed(ResultSet rs) throws SQLException {
            FBStatement.this.currentRs = null;
            FBStatement.this.notifyStatementCompleted();
            FBStatement.this.performCloseOnCompletion();
        }

        @Override
        public void executionCompleted(FirebirdRowUpdater updater, boolean success) throws SQLException {
            if (this.rowUpdaterSeparateTransaction) {
                FBStatement.this.notifyStatementCompleted(success);
            }
        }

        @Override
        public void executionStarted(FirebirdRowUpdater updater) throws SQLException {
            FbTransaction stmtTransaction = FBStatement.this.fbStatement.getTransaction();
            if (stmtTransaction != null && stmtTransaction.getState() == TransactionState.ACTIVE) {
                this.rowUpdaterSeparateTransaction = false;
            } else {
                this.rowUpdaterSeparateTransaction = true;
                FBStatement.this.notifyStatementStarted(false);
            }
        }
    }

    private static final class RowsFetchedListener
    implements StatementListener {
        private boolean allRowsFetched;

        private RowsFetchedListener() {
        }

        @Override
        public void afterLast(FbStatement sender) {
            this.allRowsFetched = true;
        }

        public boolean isAllRowsFetched() {
            return this.allRowsFetched;
        }
    }

    private final class FBStatementListener
    implements StatementListener {
        private FBStatementListener() {
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            if (this.isUnexpectedSender(sender)) {
                return;
            }
            if (FBStatement.this.isSingletonResult) {
                FBStatement.this.specialResult.clear();
                FBStatement.this.specialResult.add(rowValue);
            } else if (FBStatement.this.isGeneratedKeyQuery()) {
                FBStatement.this.specialResult.add(rowValue);
            }
        }

        @Override
        public void statementExecuted(FbStatement sender, boolean hasResultSet, boolean hasSingletonResult) {
            if (this.isUnexpectedSender(sender)) {
                return;
            }
            FBStatement.this.currentStatementResult = this.determineInitialStatementResult(hasResultSet, hasSingletonResult);
            FBStatement.this.isSingletonResult = hasSingletonResult;
        }

        private StatementResult determineInitialStatementResult(boolean hasResultSet, boolean hasSingletonResult) {
            if (hasResultSet || hasSingletonResult && !FBStatement.this.isGeneratedKeyQuery()) {
                if (FBStatement.this.jbStatementType == LocalStatementType.SELECT) {
                    return StatementResult.RESULT_SET;
                }
                return StatementResult.RESULT_SET_WITH_UPDATE_COUNT;
            }
            if (FBStatement.this.fbStatement.getType().isTypeWithUpdateCounts() && FBStatement.this.jbStatementType != LocalStatementType.EXECUTE_PROCEDURE) {
                return StatementResult.UPDATE_COUNT;
            }
            return StatementResult.NO_MORE_RESULTS;
        }

        @Override
        public void statementStateChanged(FbStatement sender, StatementState newState, StatementState previousState) {
            if (this.isUnexpectedSender(sender)) {
                return;
            }
            if (newState == StatementState.EXECUTING) {
                FBStatement.this.specialResult.clear();
                FBStatement.this.sqlCountHolder = null;
                FBStatement.this.currentStatementResult = StatementResult.NO_MORE_RESULTS;
                FBStatement.this.isSingletonResult = false;
                try {
                    FBStatement.this.clearWarnings();
                }
                catch (SQLException e) {
                    throw new AssertionError("Unexpected SQLException", e);
                }
            }
        }

        @Override
        public void warningReceived(FbStatement sender, SQLWarning warning) {
            if (this.isUnexpectedSender(sender)) {
                return;
            }
            FBStatement.this.addWarning(warning);
        }

        @Override
        public void sqlCounts(FbStatement sender, SqlCountHolder sqlCounts) {
            if (this.isUnexpectedSender(sender)) {
                return;
            }
            FBStatement.this.sqlCountHolder = sqlCounts;
        }

        private boolean isUnexpectedSender(FbStatement sender) {
            if (sender != FBStatement.this.fbStatement) {
                log.log(System.Logger.Level.TRACE, "Received statement listener update from unrelated statement [{0}]", sender);
                sender.removeStatementListener(this);
                return true;
            }
            return false;
        }
    }
}

