/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller;

import com.google.blocks.ftcrobotcontroller.IOExceptionWithUserVisibleMessage;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareUtil;
import com.google.blocks.ftcrobotcontroller.util.BlocksArchive;
import com.google.blocks.ftcrobotcontroller.util.ClipboardUtil;
import com.google.blocks.ftcrobotcontroller.util.FileManager;
import com.google.blocks.ftcrobotcontroller.util.OfflineBlocksUtil;
import com.google.blocks.ftcrobotcontroller.util.ProjectsUtil;
import com.qualcomm.robotcore.robocol.Command;
import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.webserver.WebHandler;
import org.firstinspires.ftc.robotserver.internal.programmingmode.ProgrammingMode;
import org.firstinspires.ftc.robotserver.internal.programmingmode.ProgrammingModeManager;
import org.firstinspires.ftc.robotserver.internal.webserver.MimeTypesUtil;
import org.firstinspires.ftc.robotserver.internal.webserver.NoCachingWebHandler;
import org.firstinspires.ftc.robotserver.internal.webserver.RobotControllerWebHandlers;
import org.firstinspires.ftc.robotserver.internal.webserver.RobotWebHandlerManager;
import org.firstinspires.ftc.robotserver.internal.webserver.SessionParametersGenerator;

public class ProgrammingWebHandlers
implements ProgrammingMode {
    public static final String TAG = ProgrammingWebHandlers.class.getSimpleName();
    private static String URI_NAV_BLOCKS_OLD = "/FtcProjects.html";
    private static String URI_NAV_BLOCKS = "/FtcBlocksProjects.html";
    private static String URI_NAV_ONBOTJAVA = "/java/editor.html";
    private static final String URI_SERVER = "/server";
    private static final String URI_HARDWARE = "/hardware";
    private static final String URI_FILE_MANAGER_JS = "/file_manager_js";
    private static final String URI_GET_CONFIGURATION_NAME = "/get_config_name";
    private static final String URI_FETCH_OFFLINE_BLOCKS_EDITOR = "/offline_blocks_editor";
    private static final String URI_FETCH_BLOCKS_ARCHIVE = "/archive_blocks";
    private static final String URI_LIST_PROJECTS = "/list";
    private static final String URI_LIST_SAMPLES = "/samples";
    private static final String URI_FETCH_BLK = "/fetch_blk";
    private static final String URI_NEW_PROJECT = "/new";
    private static final String URI_SAVE_PROJECT = "/save";
    private static final String URI_RENAME_PROJECT = "/rename";
    private static final String URI_COPY_PROJECT = "/copy";
    private static final String URI_ENABLE_PROJECT = "/enable";
    private static final String URI_DELETE_PROJECTS = "/delete";
    private static final String URI_GET_BLOCKS_JAVA_CLASS_NAME = "/get_blocks_java_class_name";
    private static final String URI_SAVE_BLOCKS_JAVA = "/save_blocks_java";
    private static final String URI_SAVE_CLIPBOARD = "/savecb";
    private static final String URI_FETCH_CLIPBOARD = "/fetch_cb";
    private static final String URI_LIST_FILES = "/list_files";
    private static final String URI_SAVE_FILE = "/save_file";
    private static final String URI_FETCH_FILE = "/fetch_file";
    private static final String URI_FETCH_FILE_TYPE = "/fetch_file_type";
    private static final String URI_RENAME_FILE = "/rename_file";
    private static final String URI_COPY_FILE = "/copy_file";
    private static final String URI_DELETE_FILES = "/delete_files";
    private static final String URI_RESTART_ROBOT = "/restart_robot";
    private static final String URI_COLORS = "/css/colors.less";
    private static final String PARAM_FM_NAME = "fmname";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_NEW_NAME = "new_name";
    private static final String PARAM_SAMPLE_NAME = "sample";
    private static final String PARAM_BLK = "blk";
    private static final String PARAM_JS = "js";
    private static final String PARAM_JAVA = "java";
    private static final String PARAM_ENABLE = "enable";
    private static final String PARAM_CLIPBOARD = "cb";
    private static final String PARAM_CONTENT = "content";
    private volatile ProgrammingModeManager programmingModeManager;

    private WebHandler decorateWithLogging(WebHandler handler) {
        return this.programmingModeManager.decorate(false, handler);
    }

    public void register(ProgrammingModeManager manager) {
        this.programmingModeManager = manager;
        manager.register(URI_NAV_BLOCKS_OLD, (WebHandler)new RobotControllerWebHandlers.Redirection("/"));
        manager.register(URI_SERVER, this.decorateWithLogging(new Server()));
        manager.register(URI_HARDWARE, this.decorateWithLogging(new Hardware()));
        manager.register(URI_FILE_MANAGER_JS, this.decorateWithLogging(this.decorateWithParms(new FileManagerJS())));
        manager.register(URI_GET_CONFIGURATION_NAME, this.decorateWithLogging(this.decorateWithParms(new GetConfigurationName())));
        manager.register(URI_FETCH_OFFLINE_BLOCKS_EDITOR, this.decorateWithLogging(new FetchOfflineBlocksEditor()));
        manager.register(URI_FETCH_BLOCKS_ARCHIVE, this.decorateWithLogging(new FetchBlocksArchive()));
        manager.register(URI_LIST_PROJECTS, this.decorateWithLogging(new ListProjects()));
        manager.register(URI_LIST_SAMPLES, this.decorateWithLogging(new ListSamples()));
        manager.register(URI_FETCH_BLK, this.decorateWithLogging(this.decorateWithParms(new FetchBlockFile())));
        manager.register(URI_NEW_PROJECT, this.decorateWithLogging(this.decorateWithParms(new NewProject())));
        manager.register(URI_SAVE_PROJECT, this.decorateWithLogging(this.decorateWithParms(new SaveProject())));
        manager.register(URI_RENAME_PROJECT, this.decorateWithLogging(this.decorateWithParms(new RenameProject())));
        manager.register(URI_COPY_PROJECT, this.decorateWithLogging(this.decorateWithParms(new CopyProject())));
        manager.register(URI_ENABLE_PROJECT, this.decorateWithLogging(this.decorateWithParms(new EnableProject())));
        manager.register(URI_DELETE_PROJECTS, this.decorateWithLogging(this.decorateWithParms(new DeleteProjects())));
        manager.register(URI_GET_BLOCKS_JAVA_CLASS_NAME, this.decorateWithLogging(this.decorateWithParms(new GetBlocksJavaClassName())));
        manager.register(URI_SAVE_BLOCKS_JAVA, this.decorateWithLogging(this.decorateWithParms(new SaveBlocksJava())));
        manager.register(URI_SAVE_CLIPBOARD, this.decorateWithLogging(this.decorateWithParms(new SaveClipboard())));
        manager.register(URI_FETCH_CLIPBOARD, this.decorateWithLogging(new FetchClipboard()));
        manager.register(URI_LIST_FILES, this.decorateWithLogging(this.decorateWithParms(new ListFiles())));
        manager.register(URI_SAVE_FILE, this.decorateWithLogging(this.decorateWithParms(new SaveFile())));
        manager.register(URI_FETCH_FILE, this.decorateWithLogging(this.decorateWithParms(new FetchFile())));
        manager.register(URI_FETCH_FILE_TYPE, this.decorateWithLogging(this.decorateWithParms(new FetchFileType())));
        manager.register(URI_RENAME_FILE, this.decorateWithLogging(this.decorateWithParms(new RenameFile())));
        manager.register(URI_COPY_FILE, this.decorateWithLogging(this.decorateWithParms(new CopyFile())));
        manager.register(URI_DELETE_FILES, this.decorateWithLogging(this.decorateWithParms(new DeleteFiles())));
        manager.register(URI_RESTART_ROBOT, this.decorateWithLogging(new RestartRobot()));
        manager.register(URI_COLORS, this.decorateWithLogging(manager.getRegisteredHandler(URI_COLORS)));
        manager.register("/js/rc_config.js", (WebHandler)new RobotControllerConfiguration());
    }

    static String getFirstNamedParameter(NanoHTTPD.IHTTPSession session, String name) {
        Map parameters = session.getParameters();
        if (!parameters.containsKey(name)) {
            return null;
        }
        return (String)((List)parameters.get(name)).get(0);
    }

    private WebHandler decorateWithParms(WebHandler delegate) {
        return new SessionParametersGenerator(delegate);
    }

    private static class RestartRobot
    implements WebHandler {
        private RestartRobot() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            NetworkConnectionHandler connectionHandler = NetworkConnectionHandler.getInstance();
            connectionHandler.injectReceivedCommand(new Command("CMD_RESTART_ROBOT"));
            return RobotWebHandlerManager.OK_RESPONSE;
        }
    }

    private static class DeleteFiles
    implements WebHandler {
        private DeleteFiles() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String fmName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_FM_NAME);
            String starDelimitedNames = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            if (fmName != null && starDelimitedNames != null) {
                try {
                    String[] names = starDelimitedNames.split("\\*");
                    FileManager.valueOf(fmName).deleteFiles(names);
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Internal Error");
                }
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: fmname and name parameters are required");
        }
    }

    private static class CopyFile
    implements WebHandler {
        private CopyFile() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String fmName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_FM_NAME);
            String oldName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            String newName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NEW_NAME);
            if (fmName != null && oldName != null && newName != null) {
                try {
                    FileManager.valueOf(fmName).copyFile(oldName, newName);
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Internal Error");
                }
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: fmname, name, and new_name parameters are required");
        }
    }

    private static class RenameFile
    implements WebHandler {
        private RenameFile() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String fmName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_FM_NAME);
            String oldName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            String newName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NEW_NAME);
            if (fmName != null && oldName != null && newName != null) {
                try {
                    FileManager.valueOf(fmName).renameFile(oldName, newName);
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Internal Error");
                }
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: fmname, name, and new_name parameters are required");
        }
    }

    private static class FetchFileType
    implements WebHandler {
        private FetchFileType() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String name = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            if (name != null) {
                String mimeType = MimeTypesUtil.determineMimeType((String)name);
                if (mimeType == null) {
                    mimeType = "";
                }
                return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)mimeType));
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name parameter is required");
        }
    }

    private static class FetchFile
    implements WebHandler {
        private FetchFile() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String name = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            String fmName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_FM_NAME);
            if (fmName != null && name != null) {
                try {
                    String base64Content = FileManager.valueOf(fmName).fetchFileContent(name);
                    return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)base64Content));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Internal Error");
                }
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: fmname and name parameters are required");
        }
    }

    private static class SaveFile
    implements WebHandler {
        private SaveFile() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String fmName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_FM_NAME);
            String name = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            String base64Content = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_CONTENT);
            if (fmName != null && name != null && base64Content != null) {
                try {
                    FileManager.valueOf(fmName).saveFile(name, base64Content);
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Internal Error");
                }
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: fmname, name, and content parameters are required");
        }
    }

    private static class ListFiles
    implements WebHandler {
        private ListFiles() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String fmName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_FM_NAME);
            if (fmName != null) {
                try {
                    String json = FileManager.valueOf(fmName).fetchFiles();
                    return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)json));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Internal Error");
                }
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: fmname parameter is required");
        }
    }

    private static class FileManagerJS
    implements WebHandler {
        private FileManagerJS() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String fmName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_FM_NAME);
            if (fmName != null) {
                try {
                    String js = FileManager.valueOf(fmName).fetchJavaScript();
                    return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"application/javascript", (String)js));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Internal Error");
                }
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: fmname parameter is required");
        }
    }

    private static class FetchClipboard
    implements WebHandler {
        private FetchClipboard() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            return this.fetchClipboardContent();
        }

        private NanoHTTPD.Response fetchClipboardContent() throws IOException {
            String clipboardContent = ClipboardUtil.fetchClipboardContent();
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)clipboardContent);
        }
    }

    private static class SaveClipboard
    implements WebHandler {
        private SaveClipboard() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String clipboardContent = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_CLIPBOARD);
            if (clipboardContent != null) {
                return this.saveClipboardContent(clipboardContent);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: cb parameter is required");
        }

        private NanoHTTPD.Response saveClipboardContent(String clipboardContent) throws IOException {
            ClipboardUtil.saveClipboardContent(clipboardContent);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
        }
    }

    private static class SaveBlocksJava
    implements WebHandler {
        private SaveBlocksJava() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String relativeFileName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            String javaContent = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_JAVA);
            if (relativeFileName != null && javaContent != null) {
                return this.saveBlocksJava(relativeFileName, javaContent);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name and java parameters are required");
        }

        private NanoHTTPD.Response saveBlocksJava(String relativeFileName, String javaContent) throws IOException {
            ProjectsUtil.saveBlocksJava(relativeFileName, javaContent);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
        }
    }

    private static class GetBlocksJavaClassName
    implements WebHandler {
        private GetBlocksJavaClassName() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String name = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            if (name != null) {
                return this.getBlocksJavaClassName(session, name);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name parameter is required");
        }

        private NanoHTTPD.Response getBlocksJavaClassName(NanoHTTPD.IHTTPSession session, String projectName) throws IOException {
            String className = ProjectsUtil.getBlocksJavaClassName(projectName);
            return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)className));
        }
    }

    private static class DeleteProjects
    implements WebHandler {
        private DeleteProjects() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String names = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            if (names != null) {
                return this.deleteProjects(names);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name parameter is required");
        }

        private NanoHTTPD.Response deleteProjects(String starDelimitedProjectNames) throws IOException {
            String[] projectNames = starDelimitedProjectNames.split("\\*");
            ProjectsUtil.deleteProjects(projectNames);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
        }
    }

    private static class EnableProject
    implements WebHandler {
        private EnableProject() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String name = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            String enable = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_ENABLE);
            if (name != null && enable != null) {
                return this.enableProject(name, Boolean.parseBoolean(enable));
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name and new_name parameters are required");
        }

        private NanoHTTPD.Response enableProject(String projectName, boolean enable) throws IOException {
            ProjectsUtil.enableProject(projectName, enable);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
        }
    }

    private static class CopyProject
    implements WebHandler {
        private CopyProject() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String oldName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            String newName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NEW_NAME);
            if (oldName != null && newName != null) {
                return this.copyProject(oldName, newName);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name and new_name parameters are required");
        }

        private NanoHTTPD.Response copyProject(String oldProjectName, String newProjectName) throws IOException {
            try {
                ProjectsUtil.copyProject(oldProjectName, newProjectName);
            }
            catch (IOExceptionWithUserVisibleMessage e) {
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)e.getMessage());
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
        }
    }

    private static class RenameProject
    implements WebHandler {
        private RenameProject() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String oldName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            String newName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NEW_NAME);
            if (oldName != null && newName != null) {
                return this.renameProject(oldName, newName);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name and new_name parameters are required");
        }

        private NanoHTTPD.Response renameProject(String oldProjectName, String newProjectName) throws IOException {
            ProjectsUtil.renameProject(oldProjectName, newProjectName);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
        }
    }

    private static class SaveProject
    implements WebHandler {
        private SaveProject() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String name = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            String blk = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_BLK);
            String js = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_JS);
            if (name != null && blk != null && js != null) {
                return this.saveProject(name, blk, js);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name, blk, and js parameters are required");
        }

        private NanoHTTPD.Response saveProject(String projectName, String blkFileContent, String jsFileContent) throws IOException {
            ProjectsUtil.saveProject(projectName, blkFileContent, jsFileContent);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
        }
    }

    private static class NewProject
    implements WebHandler {
        private NewProject() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String name = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            if (name != null) {
                String sampleName = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_SAMPLE_NAME);
                return this.newProject(session, name, sampleName);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name parameter is required");
        }

        private NanoHTTPD.Response newProject(NanoHTTPD.IHTTPSession session, String projectName, String sampleName) throws IOException {
            String blkContent = ProjectsUtil.newProject(projectName, sampleName);
            return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)blkContent));
        }
    }

    private static class FetchBlockFile
    implements WebHandler {
        private FetchBlockFile() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            String name = ProgrammingWebHandlers.getFirstNamedParameter(session, ProgrammingWebHandlers.PARAM_NAME);
            if (name != null) {
                return this.fetchBlkFileContent(session, name);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Bad Request: name parameter is required");
        }

        private NanoHTTPD.Response fetchBlkFileContent(NanoHTTPD.IHTTPSession session, String projectName) throws IOException {
            String blkFileContent = ProjectsUtil.fetchBlkFileContent(projectName);
            return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)blkFileContent));
        }
    }

    private static class FetchBlocksArchive
    implements WebHandler {
        private FetchBlocksArchive() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            return this.fetchBlocksArchive(session);
        }

        private NanoHTTPD.Response fetchBlocksArchive(NanoHTTPD.IHTTPSession session) throws IOException {
            return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"application/zip", (InputStream)BlocksArchive.fetchBlocksArchive()));
        }
    }

    private static class FetchOfflineBlocksEditor
    implements WebHandler {
        private FetchOfflineBlocksEditor() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            return this.fetchOfflineBlocksEditor(session);
        }

        private NanoHTTPD.Response fetchOfflineBlocksEditor(NanoHTTPD.IHTTPSession session) throws IOException {
            return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"application/zip", (InputStream)OfflineBlocksUtil.fetchOfflineBlocksEditor()));
        }
    }

    private static class GetConfigurationName
    implements WebHandler {
        private GetConfigurationName() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            return this.getConfigurationName(session);
        }

        private NanoHTTPD.Response getConfigurationName(NanoHTTPD.IHTTPSession session) throws IOException {
            String configName = HardwareUtil.getConfigurationName();
            return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)configName));
        }
    }

    private static class Hardware
    implements WebHandler {
        private Hardware() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            return this.fetchJavaScriptForHardware(session);
        }

        private NanoHTTPD.Response fetchJavaScriptForHardware(NanoHTTPD.IHTTPSession session) throws IOException {
            String jsHardware = HardwareUtil.fetchJavaScriptForHardware();
            return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"application/javascript", (String)jsHardware));
        }
    }

    private static class ListSamples
    implements WebHandler {
        private ListSamples() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            return this.fetchSamples(session);
        }

        private NanoHTTPD.Response fetchSamples(NanoHTTPD.IHTTPSession session) throws IOException {
            String jsonSamples = ProjectsUtil.fetchSampleNames();
            return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)jsonSamples));
        }
    }

    private static class ListProjects
    implements WebHandler {
        private ListProjects() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            return this.fetchProjects(session);
        }

        private NanoHTTPD.Response fetchProjects(NanoHTTPD.IHTTPSession session) throws IOException {
            String jsonProjects = ProjectsUtil.fetchProjectsWithBlocks();
            return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)jsonProjects));
        }
    }

    private static class RobotControllerConfiguration
    extends RobotControllerWebHandlers.RobotControllerConfiguration {
        private RobotControllerConfiguration() {
        }

        protected void appendVariables(StringBuilder js) {
            super.appendVariables(js);
            RobotControllerConfiguration.appendVariable((StringBuilder)js, (String)"URI_NAV_BLOCKS", (String)URI_NAV_BLOCKS);
            RobotControllerConfiguration.appendVariable((StringBuilder)js, (String)"URI_NAV_ONBOTJAVA", (String)URI_NAV_ONBOTJAVA);
        }
    }

    private static class Server
    implements WebHandler {
        private Server() {
        }

        public NanoHTTPD.Response getResponse(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
            return this.fetchJavaScriptForServer(session);
        }

        private NanoHTTPD.Response fetchJavaScriptForServer(NanoHTTPD.IHTTPSession session) throws IOException {
            StringBuilder js = new StringBuilder();
            js.append("var URI_HARDWARE = '").append(ProgrammingWebHandlers.URI_HARDWARE).append("';\n");
            js.append("var URI_FILE_MANAGER_JS = '").append(ProgrammingWebHandlers.URI_FILE_MANAGER_JS).append("';\n");
            js.append("var URI_GET_CONFIGURATION_NAME = '").append(ProgrammingWebHandlers.URI_GET_CONFIGURATION_NAME).append("';\n");
            js.append("var URI_FETCH_OFFLINE_BLOCKS_EDITOR = '").append(ProgrammingWebHandlers.URI_FETCH_OFFLINE_BLOCKS_EDITOR).append("';\n");
            js.append("var URI_FETCH_BLOCKS_ARCHIVE = '").append(ProgrammingWebHandlers.URI_FETCH_BLOCKS_ARCHIVE).append("';\n");
            js.append("var URI_LIST_PROJECTS = '").append(ProgrammingWebHandlers.URI_LIST_PROJECTS).append("';\n");
            js.append("var URI_LIST_SAMPLES = '").append(ProgrammingWebHandlers.URI_LIST_SAMPLES).append("';\n");
            js.append("var URI_FETCH_BLK = '").append(ProgrammingWebHandlers.URI_FETCH_BLK).append("';\n");
            js.append("var URI_NEW_PROJECT = '").append(ProgrammingWebHandlers.URI_NEW_PROJECT).append("';\n");
            js.append("var URI_SAVE_PROJECT = '").append(ProgrammingWebHandlers.URI_SAVE_PROJECT).append("';\n");
            js.append("var URI_RENAME_PROJECT = '").append(ProgrammingWebHandlers.URI_RENAME_PROJECT).append("';\n");
            js.append("var URI_COPY_PROJECT = '").append(ProgrammingWebHandlers.URI_COPY_PROJECT).append("';\n");
            js.append("var URI_ENABLE_PROJECT = '").append(ProgrammingWebHandlers.URI_ENABLE_PROJECT).append("';\n");
            js.append("var URI_DELETE_PROJECTS = '").append(ProgrammingWebHandlers.URI_DELETE_PROJECTS).append("';\n");
            js.append("var URI_GET_BLOCKS_JAVA_CLASS_NAME = '").append(ProgrammingWebHandlers.URI_GET_BLOCKS_JAVA_CLASS_NAME).append("';\n");
            js.append("var URI_SAVE_BLOCKS_JAVA = '").append(ProgrammingWebHandlers.URI_SAVE_BLOCKS_JAVA).append("';\n");
            js.append("var URI_SAVE_CLIPBOARD = '").append(ProgrammingWebHandlers.URI_SAVE_CLIPBOARD).append("';\n");
            js.append("var URI_FETCH_CLIPBOARD = '").append(ProgrammingWebHandlers.URI_FETCH_CLIPBOARD).append("';\n");
            js.append("var URI_LIST_FILES = '").append(ProgrammingWebHandlers.URI_LIST_FILES).append("';\n");
            js.append("var URI_SAVE_FILE = '").append(ProgrammingWebHandlers.URI_SAVE_FILE).append("';\n");
            js.append("var URI_FETCH_FILE = '").append(ProgrammingWebHandlers.URI_FETCH_FILE).append("';\n");
            js.append("var URI_FETCH_FILE_TYPE = '").append(ProgrammingWebHandlers.URI_FETCH_FILE_TYPE).append("';\n");
            js.append("var URI_RENAME_FILE = '").append(ProgrammingWebHandlers.URI_RENAME_FILE).append("';\n");
            js.append("var URI_COPY_FILE = '").append(ProgrammingWebHandlers.URI_COPY_FILE).append("';\n");
            js.append("var URI_DELETE_FILES = '").append(ProgrammingWebHandlers.URI_DELETE_FILES).append("';\n");
            js.append("var URI_RESTART_ROBOT = '").append(ProgrammingWebHandlers.URI_RESTART_ROBOT).append("';\n");
            js.append("var PARAM_FM_NAME = '").append(ProgrammingWebHandlers.PARAM_FM_NAME).append("';\n");
            js.append("var PARAM_NAME = '").append(ProgrammingWebHandlers.PARAM_NAME).append("';\n");
            js.append("var PARAM_NEW_NAME = '").append(ProgrammingWebHandlers.PARAM_NEW_NAME).append("';\n");
            js.append("var PARAM_SAMPLE_NAME = '").append(ProgrammingWebHandlers.PARAM_SAMPLE_NAME).append("';\n");
            js.append("var PARAM_BLK = '").append(ProgrammingWebHandlers.PARAM_BLK).append("';\n");
            js.append("var PARAM_JS = '").append(ProgrammingWebHandlers.PARAM_JS).append("';\n");
            js.append("var PARAM_JAVA = '").append(ProgrammingWebHandlers.PARAM_JAVA).append("';\n");
            js.append("var PARAM_ENABLE = '").append(ProgrammingWebHandlers.PARAM_ENABLE).append("';\n");
            js.append("var PARAM_CLIPBOARD = '").append(ProgrammingWebHandlers.PARAM_CLIPBOARD).append("';\n");
            js.append("var PARAM_CONTENT = '").append(ProgrammingWebHandlers.PARAM_CONTENT).append("';\n");
            return NoCachingWebHandler.setNoCache((NanoHTTPD.IHTTPSession)session, (NanoHTTPD.Response)NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"application/javascript", (String)js.toString()));
        }
    }
}

