/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.hardware;

import com.google.blocks.ftcrobotcontroller.hardware.HardwareType;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareUtil;

public class HardwareItem {
    public final HardwareType hardwareType;
    public final String deviceName;
    public final String identifier;
    public final String visibleName;

    public HardwareItem(HardwareType hardwareType, String deviceName) {
        if (hardwareType == null || deviceName == null) {
            throw new NullPointerException();
        }
        this.hardwareType = hardwareType;
        this.deviceName = deviceName;
        this.identifier = hardwareType.makeIdentifier(deviceName);
        this.visibleName = HardwareUtil.makeVisibleNameForDropdownItem(deviceName);
    }

    static String makeIdentifier(String deviceName) {
        int length = deviceName.length();
        StringBuilder identifier = new StringBuilder();
        char ch = deviceName.charAt(0);
        if (Character.isJavaIdentifierStart(ch)) {
            identifier.append(ch);
        } else if (Character.isJavaIdentifierPart(ch)) {
            identifier.append('_').append(ch);
        }
        for (int i = 1; i < length; ++i) {
            ch = deviceName.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            identifier.append(ch);
        }
        return identifier.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof HardwareItem) {
            HardwareItem that = (HardwareItem)o;
            return this.hardwareType.equals((Object)that.hardwareType) && this.deviceName.equals(that.deviceName) && this.identifier.equals(that.identifier) && this.visibleName.equals(that.visibleName);
        }
        return false;
    }

    public int hashCode() {
        return this.hardwareType.hashCode() + this.deviceName.hashCode() + this.identifier.hashCode() + this.visibleName.hashCode();
    }
}

