/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.hardware;

import android.app.Activity;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareType;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareUtil;
import com.qualcomm.ftccommon.configuration.RobotConfigFile;
import com.qualcomm.ftccommon.configuration.RobotConfigFileManager;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerImpl;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.configuration.ControllerConfiguration;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.LynxModuleConfiguration;
import com.qualcomm.robotcore.hardware.configuration.ReadXMLFileHandler;
import com.qualcomm.robotcore.hardware.configuration.ServoHubConfiguration;
import com.qualcomm.robotcore.util.RobotLog;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.xmlpull.v1.XmlPullParser;

public class HardwareItemMap {
    private final SortedMap<HardwareType, List<HardwareItem>> map = new TreeMap<HardwareType, List<HardwareItem>>();
    private final Set<DeviceConfiguration> devices = new HashSet<DeviceConfiguration>();

    public static HardwareItemMap newHardwareItemMap() {
        HardwareMap hardwareMap;
        OpModeManagerImpl opModeManagerImpl = OpModeManagerImpl.getOpModeManagerOfActivity((Activity)AppUtil.getInstance().getRootActivity());
        if (opModeManagerImpl != null && (hardwareMap = opModeManagerImpl.getHardwareMap()) != null) {
            return HardwareItemMap.newHardwareItemMap(hardwareMap);
        }
        try {
            RobotConfigFileManager robotConfigFileManager = new RobotConfigFileManager();
            RobotConfigFile activeConfig = robotConfigFileManager.getActiveConfig();
            XmlPullParser pullParser = activeConfig.getXml();
            return new HardwareItemMap(pullParser);
        }
        catch (Exception e) {
            RobotLog.logStackTrace((Throwable)e);
            return new HardwareItemMap();
        }
    }

    public static HardwareItemMap newHardwareItemMap(HardwareMap hardwareMap) {
        return new HardwareItemMap(hardwareMap);
    }

    HardwareItemMap() {
    }

    private HardwareItemMap(XmlPullParser pullParser) {
        try {
            ReadXMLFileHandler readXMLFileHandler = new ReadXMLFileHandler();
            for (ControllerConfiguration controllerConfiguration : readXMLFileHandler.parse(pullParser)) {
                this.addDevice((DeviceConfiguration)controllerConfiguration);
            }
        }
        catch (RobotCoreException e) {
            RobotLog.logStackTrace((Throwable)e);
        }
    }

    HardwareItemMap(Reader reader) {
        try {
            ReadXMLFileHandler readXMLFileHandler = new ReadXMLFileHandler();
            for (ControllerConfiguration controllerConfiguration : readXMLFileHandler.parse(reader)) {
                this.addDevice((DeviceConfiguration)controllerConfiguration);
            }
        }
        catch (RobotCoreException e) {
            RobotLog.logStackTrace((Throwable)e);
        }
    }

    private HardwareItemMap(HardwareMap hardwareMap) {
        for (HardwareType hardwareType : HardwareType.values()) {
            SortedSet deviceNames = hardwareMap.getAllNames(hardwareType.deviceType);
            for (String deviceName : deviceNames) {
                this.addHardwareItem(hardwareType, deviceName);
            }
        }
    }

    private void addController(ControllerConfiguration<? extends DeviceConfiguration> controllerConfiguration) {
        block9: {
            block8: {
                for (DeviceConfiguration deviceConfiguration : controllerConfiguration.getDevices()) {
                    this.addDevice(deviceConfiguration);
                }
                if (!(controllerConfiguration instanceof LynxModuleConfiguration)) break block8;
                LynxModuleConfiguration lynxModuleConfiguration = (LynxModuleConfiguration)controllerConfiguration;
                for (DeviceConfiguration deviceConfiguration : lynxModuleConfiguration.getServos()) {
                    this.addDevice(deviceConfiguration);
                }
                for (DeviceConfiguration deviceConfiguration : lynxModuleConfiguration.getMotors()) {
                    this.addDevice(deviceConfiguration);
                }
                for (DeviceConfiguration deviceConfiguration : lynxModuleConfiguration.getAnalogInputs()) {
                    this.addDevice(deviceConfiguration);
                }
                for (DeviceConfiguration deviceConfiguration : lynxModuleConfiguration.getPwmOutputs()) {
                    this.addDevice(deviceConfiguration);
                }
                for (DeviceConfiguration deviceConfiguration : lynxModuleConfiguration.getI2cDevices()) {
                    this.addDevice(deviceConfiguration);
                }
                for (DeviceConfiguration deviceConfiguration : lynxModuleConfiguration.getDigitalDevices()) {
                    this.addDevice(deviceConfiguration);
                }
                break block9;
            }
            if (!(controllerConfiguration instanceof ServoHubConfiguration)) break block9;
            ServoHubConfiguration servoHubConfiguration = (ServoHubConfiguration)controllerConfiguration;
            for (DeviceConfiguration deviceConfiguration : servoHubConfiguration.getServos()) {
                this.addDevice(deviceConfiguration);
            }
        }
    }

    private void addDevice(DeviceConfiguration deviceConfiguration) {
        if (this.devices.add(deviceConfiguration) && deviceConfiguration.isEnabled()) {
            for (HardwareType hardwareType : HardwareUtil.getHardwareTypes(deviceConfiguration)) {
                this.addHardwareItem(hardwareType, deviceConfiguration.getName());
            }
            if (deviceConfiguration instanceof ControllerConfiguration) {
                this.addController((ControllerConfiguration<? extends DeviceConfiguration>)((ControllerConfiguration)deviceConfiguration));
            }
        }
    }

    private void addHardwareItem(HardwareType hardwareType, String deviceName) {
        if (deviceName.isEmpty()) {
            RobotLog.w((String)("Blocks cannot support a hardware device (" + hardwareType.deviceType.getSimpleName() + ") whose name is empty."));
            return;
        }
        ArrayList<HardwareItem> hardwareItemList = (ArrayList<HardwareItem>)this.map.get((Object)hardwareType);
        if (hardwareItemList == null) {
            hardwareItemList = new ArrayList<HardwareItem>();
            this.map.put(hardwareType, hardwareItemList);
        }
        for (HardwareItem item : hardwareItemList) {
            if (!item.deviceName.equals(deviceName)) continue;
            return;
        }
        HardwareItem hardwareItem = new HardwareItem(hardwareType, deviceName);
        hardwareItemList.add(hardwareItem);
    }

    public int getHardwareTypeCount() {
        return this.map.size();
    }

    public boolean contains(HardwareType hardwareType) {
        return this.map.containsKey((Object)hardwareType);
    }

    public List<HardwareItem> getHardwareItems(HardwareType hardwareType) {
        ArrayList<HardwareItem> list = new ArrayList<HardwareItem>();
        if (this.map.containsKey((Object)hardwareType)) {
            for (HardwareItem hardwareItem : (List)this.map.get((Object)hardwareType)) {
                list.add(hardwareItem);
            }
        }
        Collections.sort(list, new Comparator<HardwareItem>(){

            @Override
            public int compare(HardwareItem a, HardwareItem b) {
                return a.deviceName.compareTo(b.deviceName);
            }
        });
        return Collections.unmodifiableList(list);
    }

    public Iterable<HardwareItem> getAllHardwareItems() {
        ArrayList<HardwareItem> list = new ArrayList<HardwareItem>();
        for (List<HardwareItem> hardwareItems : this.map.values()) {
            list.addAll(hardwareItems);
        }
        Collections.sort(list, new Comparator<HardwareItem>(){

            @Override
            public int compare(HardwareItem a, HardwareItem b) {
                return a.identifier.compareTo(b.identifier);
            }
        });
        return Collections.unmodifiableList(list);
    }

    public Set<HardwareType> getHardwareTypes() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public boolean equals(Object o) {
        if (o instanceof HardwareItemMap) {
            HardwareItemMap that = (HardwareItemMap)o;
            return this.map.equals(that.map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

