/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.navigation.Acceleration;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

class AccelerationAccess
extends Access {
    AccelerationAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "Acceleration");
    }

    private Acceleration checkAcceleration(Object accelerationArg) {
        return this.checkArg(accelerationArg, Acceleration.class, "acceleration");
    }

    @JavascriptInterface
    @Block(classes={Acceleration.class}, fieldName={"unit"})
    public String getDistanceUnit(Object accelerationArg) {
        try {
            DistanceUnit distanceUnit;
            this.startBlockExecution(BlockType.GETTER, ".DistanceUnit");
            Acceleration acceleration = this.checkAcceleration(accelerationArg);
            if (acceleration != null && (distanceUnit = acceleration.unit) != null) {
                String string = distanceUnit.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Acceleration.class}, fieldName={"xAccel"})
    public double getXAccel(Object accelerationArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".XAccel");
            Acceleration acceleration = this.checkAcceleration(accelerationArg);
            if (acceleration != null) {
                double d = acceleration.xAccel;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Acceleration.class}, fieldName={"yAccel"})
    public double getYAccel(Object accelerationArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".YAccel");
            Acceleration acceleration = this.checkAcceleration(accelerationArg);
            if (acceleration != null) {
                double d = acceleration.yAccel;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Acceleration.class}, fieldName={"zAccel"})
    public double getZAccel(Object accelerationArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".ZAccel");
            Acceleration acceleration = this.checkAcceleration(accelerationArg);
            if (acceleration != null) {
                double d = acceleration.zAccel;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Acceleration.class}, fieldName={"acquisitionTime"})
    public long getAcquisitionTime(Object accelerationArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AcquisitionTime");
            Acceleration acceleration = this.checkAcceleration(accelerationArg);
            if (acceleration != null) {
                long l = acceleration.acquisitionTime;
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Acceleration.class}, constructor=true)
    public Acceleration create() {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            Acceleration acceleration = new Acceleration();
            return acceleration;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Acceleration.class}, constructor=true)
    public Acceleration create_withArgs(String distanceUnitString, double xAccel, double yAccel, double zAccel, long acquisitionTime) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            DistanceUnit distanceUnit = this.checkArg(distanceUnitString, DistanceUnit.class, "distanceUnit");
            if (distanceUnit != null) {
                Acceleration acceleration = new Acceleration(distanceUnit, xAccel, yAccel, zAccel, acquisitionTime);
                return acceleration;
            }
            Acceleration acceleration = null;
            return acceleration;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Acceleration.class}, methodName={"fromGravity"})
    public Acceleration fromGravity(double gx, double gy, double gz, long acquisitionTime) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".fromGravity");
            Acceleration acceleration = Acceleration.fromGravity((double)gx, (double)gy, (double)gz, (long)acquisitionTime);
            return acceleration;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Acceleration.class}, methodName={"toUnit"})
    public Acceleration toDistanceUnit(Object accelerationArg, String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toDistanceUnit");
            Acceleration acceleration = this.checkAcceleration(accelerationArg);
            DistanceUnit distanceUnit = this.checkArg(distanceUnitString, DistanceUnit.class, "distanceUnit");
            if (acceleration != null && distanceUnit != null) {
                Acceleration acceleration2 = acceleration.toUnit(distanceUnit);
                return acceleration2;
            }
            Acceleration acceleration3 = null;
            return acceleration3;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Acceleration.class}, methodName={"toString"})
    public String toText(Object accelerationArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            Acceleration acceleration = this.checkAcceleration(accelerationArg);
            if (acceleration != null) {
                String string = acceleration.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

