/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.robotcore.hardware.AccelerationSensor;
import com.qualcomm.robotcore.hardware.HardwareMap;
import org.firstinspires.ftc.robotcore.external.navigation.Acceleration;

class AccelerationSensorAccess
extends HardwareAccess<AccelerationSensor> {
    private final AccelerationSensor accelerationSensor;

    AccelerationSensorAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, AccelerationSensor.class);
        this.accelerationSensor = (AccelerationSensor)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public double getXAccel() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".XAccel");
            Acceleration acceleration = this.accelerationSensor.getAcceleration();
            if (acceleration != null) {
                double d = acceleration.xAccel;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public double getYAccel() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".YAccel");
            Acceleration acceleration = this.accelerationSensor.getAcceleration();
            if (acceleration != null) {
                double d = acceleration.yAccel;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public double getZAccel() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".ZAccel");
            Acceleration acceleration = this.accelerationSensor.getAcceleration();
            if (acceleration != null) {
                double d = acceleration.zAccel;
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AccelerationSensor.class}, methodName={"getAcceleration"})
    public Acceleration getAcceleration() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Acceleration");
            Acceleration acceleration = this.accelerationSensor.getAcceleration();
            return acceleration;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public String toText() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            String string = this.accelerationSensor.getAcceleration().toString();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

