/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.qualcomm.hardware.bosch.BNO055IMU;
import com.qualcomm.hardware.rev.RevBlinkinLedDriver;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.firstinspires.ftc.robotcore.external.matrices.MatrixF;
import org.firstinspires.ftc.robotcore.external.matrices.OpenGLMatrix;
import org.firstinspires.ftc.robotcore.external.matrices.VectorF;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;
import org.firstinspires.ftc.robotcore.external.navigation.Position;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.firstinspires.ftc.robotcore.external.navigation.YawPitchRollAngles;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.vision.opencv.ImageRegion;

public abstract class Access {
    protected static final String DEFAULT_CAMERA_MONTIOR_FEEDBACK_STRING = "DEFAULT";
    protected final BlocksOpMode blocksOpMode;
    private final String identifier;
    protected final String blockFirstName;
    private final Set<String> warningsReported = new HashSet<String>();

    protected Access(BlocksOpMode blocksOpMode, String identifier, String blockFirstName) {
        this.blocksOpMode = blocksOpMode;
        this.identifier = identifier;
        this.blockFirstName = blockFirstName;
    }

    void close() {
    }

    protected final void startBlockExecution(BlockType blockType, String blockLastName) {
        this.blocksOpMode.startBlockExecution(blockType, this.blockFirstName, blockLastName);
    }

    protected final void startBlockExecution(BlockType blockType, String blockFirstNameOverride, String blockLastName) {
        this.blocksOpMode.startBlockExecution(blockType, blockFirstNameOverride, blockLastName);
    }

    protected final void endBlockExecution() {
        this.blocksOpMode.endBlockExecution();
    }

    protected final void handleObsoleteBlockExecution(BlockType blockType, String blockLastName) {
        this.startBlockExecution(blockType, blockLastName);
        this.reportWarning("This block is obsolete.");
    }

    protected final void handleObsoleteBlockExecution(BlockType blockType, String blockFirstNameOverride, String blockLastName) {
        this.startBlockExecution(blockType, blockFirstNameOverride, blockLastName);
        this.reportWarning("This block is obsolete.");
    }

    protected AngleUnit checkAngleUnit(String angleUnitString) {
        return this.checkArg(angleUnitString, AngleUnit.class, "angleUnit");
    }

    protected AxesOrder checkAxesOrder(String axesOrderString) {
        return this.checkArg(axesOrderString, AxesOrder.class, "axesOrder");
    }

    protected AxesReference checkAxesReference(String axesReferenceString) {
        return this.checkArg(axesReferenceString, AxesReference.class, "axesReference");
    }

    protected DistanceUnit checkDistanceUnit(String distanceUnitString) {
        return this.checkArg(distanceUnitString, DistanceUnit.class, "distanceUnit");
    }

    protected RevBlinkinLedDriver.BlinkinPattern checkBlinkinPattern(String blinkinPatternString) {
        return this.checkArg(blinkinPatternString, RevBlinkinLedDriver.BlinkinPattern.class, "blinkinPattern");
    }

    protected BNO055IMU.Parameters checkBNO055IMUParameters(Object parametersArg) {
        return this.checkArg(parametersArg, BNO055IMU.Parameters.class, "parameters");
    }

    protected ImageRegion checkImageRegion(Object imageRegionArg) {
        return this.checkArg(imageRegionArg, ImageRegion.class, "roi");
    }

    protected Orientation checkOrientation(Object orientationArg) {
        return this.checkArg(orientationArg, Orientation.class, "orientation");
    }

    protected Orientation checkOrientation(Object orientationArg, String socketName) {
        return this.checkArg(orientationArg, Orientation.class, socketName);
    }

    protected Position checkPosition(Object positionArg) {
        return this.checkArg(positionArg, Position.class, "position");
    }

    protected Quaternion checkQuaternion(Object quaternionArg) {
        return this.checkArg(quaternionArg, Quaternion.class, "quaternion");
    }

    protected Quaternion checkQuaternion(Object quaternionArg, String socketName) {
        return this.checkArg(quaternionArg, Quaternion.class, socketName);
    }

    protected MatrixF checkMatrixF(Object matrixArg) {
        return this.checkArg(matrixArg, MatrixF.class, "matrix");
    }

    protected OpenGLMatrix checkOpenGLMatrix(Object matrixArg) {
        return this.checkArg(matrixArg, OpenGLMatrix.class, "matrix");
    }

    protected VectorF checkVectorF(Object vectorArg) {
        return this.checkArg(vectorArg, VectorF.class, "vector");
    }

    protected YawPitchRollAngles checkYawPitchRollAngles(Object yawPitchRollAnglesArg) {
        return this.checkArg(yawPitchRollAnglesArg, YawPitchRollAngles.class, "yawPitchRollAngles");
    }

    protected final <T> T checkArg(Object arg, Class<T> clazz, String socketName) {
        if (!clazz.isInstance(arg)) {
            this.reportInvalidArg(socketName, Access.getTypeFromClass(clazz));
            return null;
        }
        return clazz.cast(arg);
    }

    protected final <T extends Enum<T>> T checkArg(String arg, Class<T> enumClass, String socketName) {
        if (arg == null) {
            this.reportInvalidArg(socketName, enumClass.getSimpleName());
            return null;
        }
        try {
            return Enum.valueOf(enumClass, arg);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return Enum.valueOf(enumClass, arg.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                this.reportInvalidArg(socketName, enumClass.getSimpleName());
                return null;
            }
        }
    }

    protected final void reportInvalidArg(String socketName, String expectedType) {
        if (socketName != null && !socketName.isEmpty()) {
            this.reportWarning("Incorrect block plugged into the %s socket of the block labeled \"%s\". Expected %s.", socketName, this.blocksOpMode.getFullBlockLabel(), expectedType);
        } else {
            this.reportWarning("Incorrect block plugged into a socket of the block labeled \"%s\". Expected %s.", this.blocksOpMode.getFullBlockLabel(), expectedType);
        }
    }

    protected final void reportWarning(String message) {
        this.reportWarning("Warning while (or after) executing the block labeled \"%s\". %s", this.blocksOpMode.getFullBlockLabel(), message);
    }

    protected final void reportHardwareError(String message) {
        this.reportWarning("Error while initializing hardware items. %s", this.blocksOpMode.getFullBlockLabel(), message);
    }

    private final void reportWarning(String format, Object ... args) {
        String message = String.format(format, args);
        RobotLog.ww((String)"Blocks", (String)message);
        if (this.warningsReported.add(message)) {
            RobotLog.addGlobalWarningMessage((String)message);
        }
    }

    protected static final String getTypeFromClass(Class clazz) {
        String type = clazz.getSimpleName();
        while (clazz.getEnclosingClass() != null) {
            clazz = clazz.getEnclosingClass();
            type = clazz.getSimpleName() + "." + type;
        }
        return type;
    }

    protected static String toJson(Object o) {
        if (o == null) {
            return "null";
        }
        return SimpleGson.getInstance().toJson(o);
    }

    protected static <T> T fromJson(String json, Class<T> clazz) {
        if (json == null || json.equals("null") || json.equals("undefined")) {
            return null;
        }
        return (T)SimpleGson.getInstance().fromJson(json, clazz);
    }
}

