/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.robotcore.hardware.AnalogInput;
import com.qualcomm.robotcore.hardware.HardwareMap;

class AnalogInputAccess
extends HardwareAccess<AnalogInput> {
    private final AnalogInput analogInput;

    AnalogInputAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, AnalogInput.class);
        this.analogInput = (AnalogInput)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={AnalogInput.class}, methodName={"getVoltage"})
    public double getVoltage() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Voltage");
            double d = this.analogInput.getVoltage();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AnalogInput.class}, methodName={"getMaxVoltage"})
    public double getMaxVoltage() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".MaxVoltage");
            double d = this.analogInput.getMaxVoltage();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

