/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.android.AndroidAccelerometer;
import org.firstinspires.ftc.robotcore.external.navigation.Acceleration;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

class AndroidAccelerometerAccess
extends Access {
    private final AndroidAccelerometer androidAccelerometer = new AndroidAccelerometer();

    AndroidAccelerometerAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "AndroidAccelerometer");
    }

    @Override
    void close() {
        this.androidAccelerometer.stopListening();
    }

    @JavascriptInterface
    public void setDistanceUnit(String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".DistanceUnit");
            DistanceUnit distanceUnit = this.checkArg(distanceUnitString, DistanceUnit.class, "");
            if (distanceUnit != null) {
                this.androidAccelerometer.setDistanceUnit(distanceUnit);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double getX() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".X");
            double d = this.androidAccelerometer.getX();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double getY() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Y");
            double d = this.androidAccelerometer.getY();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double getZ() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Z");
            double d = this.androidAccelerometer.getZ();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public Acceleration getAcceleration() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Acceleration");
            Acceleration acceleration = this.androidAccelerometer.getAcceleration();
            return acceleration;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String getDistanceUnit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".DistanceUnit");
            String string = this.androidAccelerometer.getDistanceUnit().toString();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean isAvailable() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isAvailable");
            boolean bl = this.androidAccelerometer.isAvailable();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void startListening() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".startListening");
            this.androidAccelerometer.startListening();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void stopListening() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".stopListening");
            this.androidAccelerometer.stopListening();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

