/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.android.AndroidGyroscope;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;

class AndroidGyroscopeAccess
extends Access {
    private final AndroidGyroscope androidGyroscope = new AndroidGyroscope();

    AndroidGyroscopeAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "AndroidGyroscope");
    }

    @Override
    void close() {
        this.androidGyroscope.stopListening();
    }

    @JavascriptInterface
    public void setAngleUnit(String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".AngleUnit");
            AngleUnit angleUnit = this.checkArg(angleUnitString, AngleUnit.class, "");
            if (angleUnit != null) {
                this.androidGyroscope.setAngleUnit(angleUnit);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public float getX() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".X");
            float f = this.androidGyroscope.getX();
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public float getY() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Y");
            float f = this.androidGyroscope.getY();
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public float getZ() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Z");
            float f = this.androidGyroscope.getZ();
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public AngularVelocity getAngularVelocity() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AngularVelocity");
            AngularVelocity angularVelocity = this.androidGyroscope.getAngularVelocity();
            return angularVelocity;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String getAngleUnit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AngleUnit");
            String string = this.androidGyroscope.getAngleUnit().toString();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean isAvailable() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isAvailable");
            boolean bl = this.androidGyroscope.isAvailable();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void startListening() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".startListening");
            this.androidGyroscope.startListening();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void stopListening() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".stopListening");
            this.androidGyroscope.stopListening();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

