/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.android.AndroidOrientation;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;

class AndroidOrientationAccess
extends Access {
    private final AndroidOrientation androidOrientation = new AndroidOrientation();

    AndroidOrientationAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "AndroidOrientation");
    }

    @Override
    void close() {
        this.androidOrientation.stopListening();
    }

    @JavascriptInterface
    public void setAngleUnit(String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".AngleUnit");
            AngleUnit angleUnit = this.checkArg(angleUnitString, AngleUnit.class, "");
            if (angleUnit != null) {
                this.androidOrientation.setAngleUnit(angleUnit);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double getAzimuth() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Azimuth");
            double d = this.androidOrientation.getAzimuth();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double getPitch() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Pitch");
            double d = this.androidOrientation.getPitch();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double getRoll() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Roll");
            double d = this.androidOrientation.getRoll();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double getAngle() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Angle");
            double d = this.androidOrientation.getAngle();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double getMagnitude() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Magnitude");
            double d = this.androidOrientation.getMagnitude();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String getAngleUnit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AngleUnit");
            String string = this.androidOrientation.getAngleUnit().toString();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean isAvailable() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isAvailable");
            boolean bl = this.androidOrientation.isAvailable();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void startListening() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".startListening");
            this.androidOrientation.startListening();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void stopListening() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".stopListening");
            this.androidOrientation.stopListening();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

