/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.qualcomm.ftccommon.SoundPlayer;
import org.firstinspires.ftc.robotcore.external.android.AndroidSoundPool;
import org.firstinspires.ftc.robotcore.internal.android.SoundPoolIntf;

class AndroidSoundPoolAccess
extends Access {
    private final AndroidSoundPool androidSoundPool = new AndroidSoundPool();

    AndroidSoundPoolAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "AndroidSoundPool");
    }

    @Override
    void close() {
        this.androidSoundPool.close();
    }

    @JavascriptInterface
    public void initialize() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".initialize");
            this.androidSoundPool.initialize((SoundPoolIntf)SoundPlayer.getInstance());
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean preloadSound(String soundName) {
        try {
            block9: {
                this.startBlockExecution(BlockType.FUNCTION, ".preloadSound");
                if (!this.androidSoundPool.preloadSound(soundName)) break block9;
                boolean bl = true;
                return bl;
            }
            try {
                this.reportWarning("Failed to preload " + soundName);
            }
            catch (IllegalStateException e) {
                this.reportWarning(e.getMessage());
            }
            boolean e = false;
            return e;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void play(String soundName) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".play");
            try {
                if (!this.androidSoundPool.play(soundName)) {
                    this.reportWarning("Failed to load " + soundName);
                }
            }
            catch (IllegalStateException e) {
                this.reportWarning(e.getMessage());
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void stop() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".stop");
            this.androidSoundPool.stop();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public float getVolume() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Volume");
            float f = this.androidSoundPool.getVolume();
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void setVolume(float volume) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Volume");
            if (volume >= 0.0f && volume <= 1.0f) {
                this.androidSoundPool.setVolume(volume);
            } else {
                this.reportInvalidArg("", "a number between 0.0 and 1.0");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public float getRate() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Rate");
            float f = this.androidSoundPool.getRate();
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void setRate(float rate) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Rate");
            if (rate >= 0.5f && rate <= 2.0f) {
                this.androidSoundPool.setRate(rate);
            } else {
                this.reportInvalidArg("", "a number between 0.5 and 2.0");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public int getLoop() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Loop");
            int n = this.androidSoundPool.getLoop();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void setLoop(int loop) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Loop");
            if (loop >= -1) {
                this.androidSoundPool.setLoop(loop);
            } else {
                this.reportInvalidArg("", "a number greater than or equal to -1");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

