/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.android.AndroidTextToSpeech;

class AndroidTextToSpeechAccess
extends Access {
    private final AndroidTextToSpeech androidTextToSpeech = new AndroidTextToSpeech();

    AndroidTextToSpeechAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "AndroidTextToSpeech");
    }

    @Override
    void close() {
        this.androidTextToSpeech.close();
    }

    @JavascriptInterface
    public void initialize() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".initialize");
            this.androidTextToSpeech.initialize();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String getStatus() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Status");
            String string = this.androidTextToSpeech.getStatus();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String getLanguageCode() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LanguageCode");
            try {
                String string = this.androidTextToSpeech.getLanguageCode();
                return string;
            }
            catch (IllegalStateException e2) {
                try {
                    this.reportWarning(e2.getMessage());
                    String e2 = "";
                }
                catch (Throwable e3) {
                    this.blocksOpMode.handleFatalException(e3);
                    throw new AssertionError("impossible", e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                this.endBlockExecution();
                return e2;
            }
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String getCountryCode() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".CountryCode");
            try {
                String string = this.androidTextToSpeech.getCountryCode();
                return string;
            }
            catch (IllegalStateException e2) {
                try {
                    this.reportWarning(e2.getMessage());
                    String e2 = "";
                }
                catch (Throwable e3) {
                    this.blocksOpMode.handleFatalException(e3);
                    throw new AssertionError("impossible", e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                this.endBlockExecution();
                return e2;
            }
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean getIsSpeaking() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".IsSpeaking");
            try {
                boolean bl = this.androidTextToSpeech.isSpeaking();
                return bl;
            }
            catch (IllegalStateException e2) {
                try {
                    this.reportWarning(e2.getMessage());
                    boolean e2 = false;
                }
                catch (Throwable e3) {
                    this.blocksOpMode.handleFatalException(e3);
                    throw new AssertionError("impossible", e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                this.endBlockExecution();
                return e2;
            }
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void setPitch(float pitch) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Pitch");
            try {
                this.androidTextToSpeech.setPitch(pitch);
            }
            catch (IllegalStateException e) {
                this.reportWarning(e.getMessage());
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void setSpeechRate(float speechRate) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".SpeechRate");
            try {
                this.androidTextToSpeech.setSpeechRate(speechRate);
            }
            catch (IllegalStateException e) {
                this.reportWarning(e.getMessage());
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean isLanguageAvailable(String languageCode) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isLanguageAvailable");
            try {
                boolean bl = this.androidTextToSpeech.isLanguageAvailable(languageCode);
                return bl;
            }
            catch (IllegalStateException e2) {
                try {
                    this.reportWarning(e2.getMessage());
                    boolean e2 = false;
                }
                catch (Throwable e3) {
                    this.blocksOpMode.handleFatalException(e3);
                    throw new AssertionError("impossible", e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                this.endBlockExecution();
                return e2;
            }
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public boolean isLanguageAndCountryAvailable(String languageCode, String countryCode) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isLanguageAndCountryAvailable");
            try {
                boolean bl = this.androidTextToSpeech.isLanguageAndCountryAvailable(languageCode, countryCode);
                return bl;
            }
            catch (IllegalStateException e2) {
                try {
                    this.reportWarning(e2.getMessage());
                    boolean e2 = false;
                }
                catch (Throwable e3) {
                    this.blocksOpMode.handleFatalException(e3);
                    throw new AssertionError("impossible", e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                this.endBlockExecution();
                return e2;
            }
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void setLanguage(String languageCode) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setLanguage");
            try {
                this.androidTextToSpeech.setLanguage(languageCode);
            }
            catch (IllegalStateException e) {
                this.reportWarning(e.getMessage());
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void setLanguageAndCountry(String languageCode, String countryCode) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setLanguageAndCountry");
            try {
                this.androidTextToSpeech.setLanguageAndCountry(languageCode, countryCode);
            }
            catch (IllegalStateException e) {
                this.reportWarning(e.getMessage());
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void speak(String text) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".speak");
            try {
                this.androidTextToSpeech.speak(text);
            }
            catch (IllegalStateException e) {
                this.reportWarning(e.getMessage());
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

