/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.Axis;
import org.firstinspires.ftc.robotcore.external.navigation.UnnormalizedAngleUnit;

class AngularVelocityAccess
extends Access {
    AngularVelocityAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "AngularVelocity");
    }

    private AngularVelocity checkAngularVelocity(Object angularVelocityArg) {
        return this.checkArg(angularVelocityArg, AngularVelocity.class, "angularVelocity");
    }

    @JavascriptInterface
    @Block(classes={AngularVelocity.class}, fieldName={"angleUnit"})
    public String getAngleUnit(Object angularVelocityArg) {
        try {
            UnnormalizedAngleUnit angleUnit;
            this.startBlockExecution(BlockType.GETTER, ".AngleUnit");
            AngularVelocity angularVelocity = this.checkAngularVelocity(angularVelocityArg);
            if (angularVelocity != null && (angleUnit = angularVelocity.angleUnit) != null) {
                String string = angleUnit.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AngularVelocity.class}, fieldName={"xRotationRate"})
    public float getXRotationRate(Object angularVelocityArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".XRotationRate");
            AngularVelocity angularVelocity = this.checkAngularVelocity(angularVelocityArg);
            if (angularVelocity != null) {
                float f = angularVelocity.xRotationRate;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AngularVelocity.class}, fieldName={"yRotationRate"})
    public float getYRotationRate(Object angularVelocityArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".YRotationRate");
            AngularVelocity angularVelocity = this.checkAngularVelocity(angularVelocityArg);
            if (angularVelocity != null) {
                float f = angularVelocity.yRotationRate;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AngularVelocity.class}, fieldName={"zRotationRate"})
    public float getZRotationRate(Object angularVelocityArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".ZRotationRate");
            AngularVelocity angularVelocity = this.checkAngularVelocity(angularVelocityArg);
            if (angularVelocity != null) {
                float f = angularVelocity.zRotationRate;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AngularVelocity.class}, fieldName={"acquisitionTime"})
    public long getAcquisitionTime(Object angularVelocityArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AcquisitionTime");
            AngularVelocity angularVelocity = this.checkAngularVelocity(angularVelocityArg);
            if (angularVelocity != null) {
                long l = angularVelocity.acquisitionTime;
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AngularVelocity.class}, constructor=true)
    public AngularVelocity create() {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            AngularVelocity angularVelocity = new AngularVelocity();
            return angularVelocity;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AngularVelocity.class}, constructor=true)
    public AngularVelocity create_withArgs(String angleUnitString, float xRotationRate, float yRotationRate, float zRotationRate, long acquisitionTime) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (angleUnit != null) {
                AngularVelocity angularVelocity = new AngularVelocity(angleUnit, xRotationRate, yRotationRate, zRotationRate, acquisitionTime);
                return angularVelocity;
            }
            AngularVelocity angularVelocity = null;
            return angularVelocity;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AngularVelocity.class}, methodName={"toAngleUnit"})
    public AngularVelocity toAngleUnit(Object angularVelocityArg, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toAngleUnit");
            AngularVelocity angularVelocity = this.checkAngularVelocity(angularVelocityArg);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (angularVelocity != null && angleUnit != null) {
                AngularVelocity angularVelocity2 = angularVelocity.toAngleUnit(angleUnit);
                return angularVelocity2;
            }
            AngularVelocity angularVelocity3 = null;
            return angularVelocity3;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AngularVelocity.class}, fieldName={"xRotationRate", "yRotationRate", "zRotationRate"})
    public float getRotationRate(Object angularVelocityArg, String axisString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getRotationRate");
            AngularVelocity angularVelocity = this.checkAngularVelocity(angularVelocityArg);
            Axis axis = this.checkArg(axisString, Axis.class, "axis");
            if (angularVelocity != null && axis != null) {
                switch (axis) {
                    case X: {
                        float f = angularVelocity.xRotationRate;
                        return f;
                    }
                    case Y: {
                        float f = angularVelocity.yRotationRate;
                        return f;
                    }
                    case Z: {
                        float f = angularVelocity.zRotationRate;
                        return f;
                    }
                    case UNKNOWN: {
                        this.reportInvalidArg("axis", "Axis.X, Axis.Y, or Axis.Z");
                    }
                }
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AngularVelocity.class}, methodName={"toString"})
    public String toText(Object angularVelocityArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            AngularVelocity angularVelocity = this.checkAngularVelocity(angularVelocityArg);
            if (angularVelocity != null) {
                String string = angularVelocity.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

