/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.matrices.GeneralMatrixF;
import org.firstinspires.ftc.robotcore.external.matrices.MatrixF;
import org.firstinspires.ftc.robotcore.external.matrices.VectorF;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;
import org.firstinspires.ftc.robotcore.external.navigation.Pose3D;
import org.firstinspires.ftc.robotcore.external.navigation.Position;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.firstinspires.ftc.robotcore.external.navigation.YawPitchRollAngles;
import org.firstinspires.ftc.vision.apriltag.AprilTagGameDatabase;
import org.firstinspires.ftc.vision.apriltag.AprilTagLibrary;
import org.firstinspires.ftc.vision.apriltag.AprilTagMetadata;
import org.firstinspires.ftc.vision.apriltag.AprilTagPoseFtc;
import org.firstinspires.ftc.vision.apriltag.AprilTagPoseRaw;
import org.firstinspires.ftc.vision.apriltag.AprilTagProcessor;

class AprilTagAccess
extends Access {
    AprilTagAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "");
    }

    private AprilTagProcessor.Builder checkAprilTagProcessorBuilder(Object aprilTagProcessorBuilderArg) {
        return this.checkArg(aprilTagProcessorBuilderArg, AprilTagProcessor.Builder.class, "aprilTagProcessorBuilder");
    }

    private AprilTagProcessor checkAprilTagProcessor(Object aprilTagProcessorArg) {
        return this.checkArg(aprilTagProcessorArg, AprilTagProcessor.class, "aprilTagProcessor");
    }

    private AprilTagLibrary.Builder checkAprilTagLibraryBuilder(Object aprilTagLibraryBuilderArg) {
        return this.checkArg(aprilTagLibraryBuilderArg, AprilTagLibrary.Builder.class, "aprilTagLibraryBuilder");
    }

    private AprilTagLibrary checkAprilTagLibrary(Object aprilTagLibraryArg) {
        return this.checkArg(aprilTagLibraryArg, AprilTagLibrary.class, "aprilTagLibrary");
    }

    private AprilTagProcessor.TagFamily checkTagFamily(String tagFamilyString) {
        return this.checkArg(tagFamilyString, AprilTagProcessor.TagFamily.class, "tagFamily");
    }

    private AprilTagProcessor.PoseSolver checkPoseSolver(String poseSolverString) {
        return this.checkArg(poseSolverString, AprilTagProcessor.PoseSolver.class, "poseSolver");
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, constructor=true)
    public AprilTagProcessor.Builder createAprilTagProcessorBuilder() {
        try {
            this.startBlockExecution(BlockType.CREATE, "AprilTagProcessor.Builder", "");
            AprilTagProcessor.Builder builder = new AprilTagProcessor.Builder();
            return builder;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"setCameraPose"})
    public void setCameraPose(Object aprilTagProcessorBuilderArg, Object positionArg, Object yawPitchRollAnglesArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".setCameraPose");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            Position position = this.checkPosition(positionArg);
            YawPitchRollAngles yawPitchRollAngles = this.checkYawPitchRollAngles(yawPitchRollAnglesArg);
            if (aprilTagProcessorBuilder != null && position != null && yawPitchRollAngles != null) {
                aprilTagProcessorBuilder.setCameraPose(position, yawPitchRollAngles);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"setLensIntrinsics"})
    public void setLensIntrinsics(Object aprilTagProcessorBuilderArg, double fx, double fy, double cx, double cy) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".setLensIntrinsics");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            if (aprilTagProcessorBuilder != null) {
                aprilTagProcessorBuilder.setLensIntrinsics(fx, fy, cx, cy);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"setSuppressCalibrationWarnings"})
    public void setSuppressCalibrationWarnings(Object aprilTagProcessorBuilderArg, boolean suppressCalibrationWarnings) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".setSuppressCalibrationWarnings");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            if (aprilTagProcessorBuilder != null) {
                aprilTagProcessorBuilder.setSuppressCalibrationWarnings(suppressCalibrationWarnings);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"setTagFamily"})
    public void setTagFamily(Object aprilTagProcessorBuilderArg, String tagFamilyString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".setTagFamily");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            AprilTagProcessor.TagFamily tagFamily = this.checkTagFamily(tagFamilyString);
            if (aprilTagProcessorBuilder != null && tagFamily != null) {
                aprilTagProcessorBuilder.setTagFamily(tagFamily);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"setTagLibrary"})
    public void setTagLibrary(Object aprilTagProcessorBuilderArg, Object aprilTagLibraryArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".setTagLibrary");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            AprilTagLibrary aprilTagLibrary = this.checkAprilTagLibrary(aprilTagLibraryArg);
            if (aprilTagProcessorBuilder != null && aprilTagLibrary != null) {
                aprilTagProcessorBuilder.setTagLibrary(aprilTagLibrary);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"setOutputUnits"})
    public void setOutputUnits(Object aprilTagProcessorBuilderArg, String distanceUnitString, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".setOutputUnits");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            DistanceUnit distanceUnit = this.checkDistanceUnit(distanceUnitString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (aprilTagProcessorBuilder != null && distanceUnit != null && angleUnit != null) {
                aprilTagProcessorBuilder.setOutputUnits(distanceUnit, angleUnit);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"setDrawAxes"})
    public void setDrawAxes(Object aprilTagProcessorBuilderArg, boolean drawAxes) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".setDrawAxes");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            if (aprilTagProcessorBuilder != null) {
                aprilTagProcessorBuilder.setDrawAxes(drawAxes);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"setDrawCubeProjection"})
    public void setDrawCubeProjection(Object aprilTagProcessorBuilderArg, boolean drawCube) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".setDrawCubeProjection");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            if (aprilTagProcessorBuilder != null) {
                aprilTagProcessorBuilder.setDrawCubeProjection(drawCube);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"setDrawTagOutline"})
    public void setDrawTagOutline(Object aprilTagProcessorBuilderArg, boolean drawOutline) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".setDrawTagOutline");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            if (aprilTagProcessorBuilder != null) {
                aprilTagProcessorBuilder.setDrawTagOutline(drawOutline);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"setDrawTagID"})
    public void setDrawTagID(Object aprilTagProcessorBuilderArg, boolean drawTagID) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".setDrawTagID");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            if (aprilTagProcessorBuilder != null) {
                aprilTagProcessorBuilder.setDrawTagID(drawTagID);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"setNumThreads"})
    public void setNumThreads(Object aprilTagProcessorBuilderArg, int numThreads) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".setNumThreads");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            if (aprilTagProcessorBuilder != null) {
                aprilTagProcessorBuilder.setNumThreads(numThreads);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.Builder.class}, methodName={"build"})
    public AprilTagProcessor buildAprilTagProcessor(Object aprilTagProcessorBuilderArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor.Builder", ".build");
            AprilTagProcessor.Builder aprilTagProcessorBuilder = this.checkAprilTagProcessorBuilder(aprilTagProcessorBuilderArg);
            if (aprilTagProcessorBuilder != null) {
                AprilTagProcessor aprilTagProcessor = aprilTagProcessorBuilder.build();
                return aprilTagProcessor;
            }
            AprilTagProcessor aprilTagProcessor = null;
            return aprilTagProcessor;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.class}, methodName={"easyCreateWithDefaults"})
    public AprilTagProcessor easyCreateWithDefaults() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor", ".easyCreateWithDefaults");
            AprilTagProcessor aprilTagProcessor = AprilTagProcessor.easyCreateWithDefaults();
            return aprilTagProcessor;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.class}, methodName={"setDecimation"})
    public void setDecimation(Object aprilTagProcessorArg, float decimation) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor", ".setDecimation");
            AprilTagProcessor aprilTagProcessor = this.checkAprilTagProcessor(aprilTagProcessorArg);
            if (aprilTagProcessor != null) {
                aprilTagProcessor.setDecimation(decimation);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.class}, methodName={"setPoseSolver"})
    public void setPoseSolver(Object aprilTagProcessorArg, String poseSolverString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor", ".setPoseSolver");
            AprilTagProcessor aprilTagProcessor = this.checkAprilTagProcessor(aprilTagProcessorArg);
            AprilTagProcessor.PoseSolver poseSolver = this.checkPoseSolver(poseSolverString);
            if (aprilTagProcessor != null && poseSolver != null) {
                aprilTagProcessor.setPoseSolver(poseSolver);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.class}, methodName={"getPerTagAvgPoseSolveTime"})
    public int getPerTagAvgPoseSolveTime(Object aprilTagProcessorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor", ".getPerTagAvgPoseSolveTime");
            AprilTagProcessor aprilTagProcessor = this.checkAprilTagProcessor(aprilTagProcessorArg);
            if (aprilTagProcessor != null) {
                int n = aprilTagProcessor.getPerTagAvgPoseSolveTime();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.class}, methodName={"getDetections"})
    public String getDetections(Object aprilTagProcessorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor", ".getDetections");
            AprilTagProcessor aprilTagProcessor = this.checkAprilTagProcessor(aprilTagProcessorArg);
            if (aprilTagProcessor != null) {
                String string = AprilTagAccess.toJson(aprilTagProcessor.getDetections());
                return string;
            }
            String string = "[]";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagProcessor.class}, methodName={"getFreshDetections"})
    public String getFreshDetections(Object aprilTagProcessorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagProcessor", ".getFreshDetections");
            AprilTagProcessor aprilTagProcessor = this.checkAprilTagProcessor(aprilTagProcessorArg);
            if (aprilTagProcessor != null) {
                String string = AprilTagAccess.toJson(aprilTagProcessor.getFreshDetections());
                return string;
            }
            String string = "[]";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagGameDatabase.class}, methodName={"getCurrentGameTagLibrary"})
    public AprilTagLibrary getCurrentGameTagLibrary() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagGameDatabase", ".getCurrentGameTagLibrary");
            AprilTagLibrary aprilTagLibrary = AprilTagGameDatabase.getCurrentGameTagLibrary();
            return aprilTagLibrary;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagGameDatabase.class}, methodName={"getCenterStageTagLibrary"})
    public AprilTagLibrary getCenterStageTagLibrary() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagGameDatabase", ".getCenterStageTagLibrary");
            AprilTagLibrary aprilTagLibrary = AprilTagGameDatabase.getCenterStageTagLibrary();
            return aprilTagLibrary;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagGameDatabase.class}, methodName={"getIntoTheDeepTagLibrary"})
    public AprilTagLibrary getIntoTheDeepTagLibrary() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagGameDatabase", ".getIntoTheDeepTagLibrary");
            AprilTagLibrary aprilTagLibrary = AprilTagGameDatabase.getIntoTheDeepTagLibrary();
            return aprilTagLibrary;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagGameDatabase.class}, methodName={"getSampleTagLibrary"})
    public AprilTagLibrary getSampleTagLibrary() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagGameDatabase", ".getSampleTagLibrary");
            AprilTagLibrary aprilTagLibrary = AprilTagGameDatabase.getSampleTagLibrary();
            return aprilTagLibrary;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagLibrary.Builder.class}, constructor=true)
    public AprilTagLibrary.Builder createAprilTagLibraryBuilder() {
        try {
            this.startBlockExecution(BlockType.CREATE, "AprilTagLibrary.Builder", "");
            AprilTagLibrary.Builder builder = new AprilTagLibrary.Builder();
            return builder;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagLibrary.Builder.class}, methodName={"setAllowOverwrite"})
    public void setAllowOverwrite(Object aprilTagLibraryBuilderArg, boolean allowOverwrite) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagLibrary.Builder", ".setAllowOverwrite");
            AprilTagLibrary.Builder aprilTagLibraryBuilder = this.checkAprilTagLibraryBuilder(aprilTagLibraryBuilderArg);
            if (aprilTagLibraryBuilder != null) {
                aprilTagLibraryBuilder.setAllowOverwrite(allowOverwrite);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagLibrary.Builder.class}, methodName={"addTag"})
    public void addTag_WithMetadata(Object aprilTagLibraryBuilderArg, String aprilTagMetadataString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagLibrary.Builder", ".addTag");
            AprilTagLibrary.Builder aprilTagLibraryBuilder = this.checkAprilTagLibraryBuilder(aprilTagLibraryBuilderArg);
            if (aprilTagLibraryBuilder != null) {
                AprilTagMetadata aprilTagMetadata = AprilTagAccess.fromJson(aprilTagMetadataString, AprilTagMetadata.class);
                aprilTagLibraryBuilder.addTag(aprilTagMetadata);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagLibrary.Builder.class}, methodName={"addTag"})
    public void addTag(Object aprilTagLibraryBuilderArg, int id, String name, double tagSize, Object fieldPositionArg, String distanceUnitString, Object fieldOrientationArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagLibrary.Builder", ".addTag");
            AprilTagLibrary.Builder aprilTagLibraryBuilder = this.checkAprilTagLibraryBuilder(aprilTagLibraryBuilderArg);
            VectorF fieldPosition = this.checkVectorF(fieldPositionArg);
            DistanceUnit distanceUnit = this.checkDistanceUnit(distanceUnitString);
            Quaternion fieldOrientation = this.checkQuaternion(fieldOrientationArg);
            if (aprilTagLibraryBuilder != null && fieldPosition != null && distanceUnit != null && fieldOrientation != null) {
                aprilTagLibraryBuilder.addTag(id, name, tagSize, fieldPosition, distanceUnit, fieldOrientation);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagLibrary.Builder.class}, methodName={"addTag"})
    public void addTag_withoutPoseInfo(Object aprilTagLibraryBuilderArg, int id, String name, double tagSize, String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagLibrary.Builder", ".addTag");
            AprilTagLibrary.Builder aprilTagLibraryBuilder = this.checkAprilTagLibraryBuilder(aprilTagLibraryBuilderArg);
            DistanceUnit distanceUnit = this.checkDistanceUnit(distanceUnitString);
            if (aprilTagLibraryBuilder != null && distanceUnit != null) {
                aprilTagLibraryBuilder.addTag(id, name, tagSize, distanceUnit);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagLibrary.Builder.class}, methodName={"addTags"})
    public void addTags(Object aprilTagLibraryBuilderArg, Object aprilTagLibraryArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagLibrary.Builder", ".addTags");
            AprilTagLibrary.Builder aprilTagLibraryBuilder = this.checkAprilTagLibraryBuilder(aprilTagLibraryBuilderArg);
            AprilTagLibrary aprilTagLibrary = this.checkAprilTagLibrary(aprilTagLibraryArg);
            if (aprilTagLibraryBuilder != null && aprilTagLibrary != null) {
                aprilTagLibraryBuilder.addTags(aprilTagLibrary);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagLibrary.Builder.class}, methodName={"build"})
    public AprilTagLibrary buildAprilTagLibrary(Object aprilTagLibraryBuilderArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagLibrary.Builder", ".build");
            AprilTagLibrary.Builder aprilTagLibraryBuilder = this.checkAprilTagLibraryBuilder(aprilTagLibraryBuilderArg);
            if (aprilTagLibraryBuilder != null) {
                AprilTagLibrary aprilTagLibrary = aprilTagLibraryBuilder.build();
                return aprilTagLibrary;
            }
            AprilTagLibrary aprilTagLibrary = null;
            return aprilTagLibrary;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagLibrary.class}, methodName={"lookupTag"})
    public String lookupTag(Object aprilTagLibraryArg, int id) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "AprilTagLibrary", ".lookupTag");
            AprilTagLibrary aprilTagLibrary = this.checkAprilTagLibrary(aprilTagLibraryArg);
            if (aprilTagLibrary != null) {
                AprilTagMetadata aprilTagMetadata = aprilTagLibrary.lookupTag(id);
                String string = AprilTagAccess.toJson(aprilTagMetadata);
                return string;
            }
            String string = "null";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagMetadata.class}, constructor=true)
    public String createMetadata(int id, String name, double tagSize, Object fieldPositionArg, String distanceUnitString, Object fieldOrientationArg) {
        try {
            this.startBlockExecution(BlockType.CREATE, "AprilTagMetadata", "");
            VectorF fieldPosition = this.checkVectorF(fieldPositionArg);
            DistanceUnit distanceUnit = this.checkDistanceUnit(distanceUnitString);
            Quaternion fieldOrientation = this.checkQuaternion(fieldOrientationArg);
            if (fieldPosition != null && distanceUnit != null && fieldOrientation != null) {
                AprilTagMetadata aprilTagMetadata = new AprilTagMetadata(id, name, tagSize, fieldPosition, distanceUnit, fieldOrientation);
                String string = AprilTagAccess.toJson(aprilTagMetadata);
                return string;
            }
            String string = "null";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AprilTagMetadata.class}, constructor=true)
    public String createMetadata_withoutPoseInfo(int id, String name, double tagSize, String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.CREATE, "AprilTagMetadata", "");
            DistanceUnit distanceUnit = this.checkDistanceUnit(distanceUnitString);
            if (distanceUnit != null) {
                AprilTagMetadata aprilTagMetadata = new AprilTagMetadata(id, name, tagSize, distanceUnit);
                String string = AprilTagAccess.toJson(aprilTagMetadata);
                return string;
            }
            String string = "null";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public VectorF createVectorF(String blockTypeString, String blockFirstName, String blockLastName, String json) {
        try {
            this.startBlockExecution(BlockType.valueOf(blockTypeString), blockFirstName, blockLastName);
            VectorF vectorF = AprilTagAccess.fromJson(json, VectorF.class);
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public Quaternion createQuaternion(String blockTypeString, String blockFirstName, String blockLastName, String json) {
        try {
            this.startBlockExecution(BlockType.valueOf(blockTypeString), blockFirstName, blockLastName);
            Quaternion quaternion = AprilTagAccess.fromJson(json, Quaternion.class);
            return quaternion;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public AprilTagPoseFtc createAprilTagPoseFtc(String blockTypeString, String blockFirstName, String blockLastName, String json) {
        try {
            this.startBlockExecution(BlockType.valueOf(blockTypeString), blockFirstName, blockLastName);
            AprilTagPoseFtc aprilTagPoseFtc = AprilTagAccess.fromJson(json, AprilTagPoseFtc.class);
            return aprilTagPoseFtc;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public AprilTagPoseRaw createAprilTagPoseRaw(String blockTypeString, String blockFirstName, String blockLastName, String json) {
        try {
            this.startBlockExecution(BlockType.valueOf(blockTypeString), blockFirstName, blockLastName);
            AprilTagPoseRaw aprilTagPoseRaw = AprilTagAccess.fromJson(json, AprilTagPoseRaw.class);
            return aprilTagPoseRaw;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public Pose3D createAprilTagPoseRobot(String blockTypeString, String blockFirstName, String blockLastName, String json) {
        try {
            this.startBlockExecution(BlockType.valueOf(blockTypeString), blockFirstName, blockLastName);
            Pose3D pose3D = AprilTagAccess.fromJson(json, Pose3D.class);
            return pose3D;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public MatrixF createMatrixF(String blockTypeString, String blockFirstName, String blockLastName, String json) {
        try {
            this.startBlockExecution(BlockType.valueOf(blockTypeString), blockFirstName, blockLastName);
            MatrixF matrixF = (MatrixF)AprilTagAccess.fromJson(json, GeneralMatrixF.class);
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

