/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.adafruit.AdafruitBNO055IMU;
import com.qualcomm.hardware.bosch.BNO055IMU;
import com.qualcomm.hardware.bosch.BNO055IMUImpl;
import com.qualcomm.hardware.lynx.LynxEmbeddedIMU;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.util.ReadWriteFile;
import java.io.File;
import java.util.Set;
import org.firstinspires.ftc.robotcore.external.navigation.Acceleration;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.Axis;
import org.firstinspires.ftc.robotcore.external.navigation.MagneticFlux;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;
import org.firstinspires.ftc.robotcore.external.navigation.Position;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.firstinspires.ftc.robotcore.external.navigation.Temperature;
import org.firstinspires.ftc.robotcore.external.navigation.Velocity;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

class BNO055IMUAccess
extends HardwareAccess<BNO055IMUImpl> {
    private final BNO055IMUImpl imu;

    BNO055IMUAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, BNO055IMUImpl.class);
        this.imu = (BNO055IMUImpl)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getAcceleration"})
    public Acceleration getAcceleration() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Acceleration");
            Acceleration acceleration = this.imu.getAcceleration();
            return acceleration;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getAngularOrientation"})
    public Orientation getAngularOrientation() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AngularOrientation");
            Orientation orientation = this.imu.getAngularOrientation();
            return orientation;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getAngularVelocity"})
    public AngularVelocity getAngularVelocity() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AngularVelocity");
            AngularVelocity angularVelocity = this.imu.getAngularVelocity();
            return angularVelocity;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getCalibrationStatus"})
    public String getCalibrationStatus() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".CalibrationStatus");
            BNO055IMU.CalibrationStatus calibrationStatus = this.imu.getCalibrationStatus();
            if (calibrationStatus != null) {
                String string = calibrationStatus.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getGravity"})
    public Acceleration getGravity() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Gravity");
            Acceleration acceleration = this.imu.getGravity();
            return acceleration;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getLinearAcceleration"})
    public Acceleration getLinearAcceleration() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LinearAcceleration");
            Acceleration acceleration = this.imu.getLinearAcceleration();
            return acceleration;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getMagneticFieldStrength"})
    public MagneticFlux getMagneticFieldStrength() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".MagneticFieldStrength");
            MagneticFlux magneticFlux = this.imu.getMagneticFieldStrength();
            return magneticFlux;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getOverallAcceleration"})
    public Acceleration getOverallAcceleration() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".OverallAcceleration");
            Acceleration acceleration = this.imu.getOverallAcceleration();
            return acceleration;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getParameters"})
    public BNO055IMU.Parameters getParameters() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Parameters");
            BNO055IMU.Parameters parameters = (BNO055IMU.Parameters)this.imu.getParameters();
            return parameters;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getPosition"})
    public Position getPosition() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Position");
            Position position = this.imu.getPosition();
            return position;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getQuaternionOrientation"})
    public Quaternion getQuaternionOrientation() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".QuaternionOrientation");
            Quaternion quaternion = this.imu.getQuaternionOrientation();
            return quaternion;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getSystemError"})
    public String getSystemError() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".SystemError");
            BNO055IMU.SystemError systemError = this.imu.getSystemError();
            if (systemError != null) {
                String string = systemError.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getSystemStatus"})
    public String getSystemStatus() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".SystemStatus");
            BNO055IMU.SystemStatus systemStatus = this.imu.getSystemStatus();
            if (systemStatus != null) {
                String string = systemStatus.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getTemperature"})
    public Temperature getTemperature() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Temperature");
            Temperature temperature = this.imu.getTemperature();
            return temperature;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getVelocity"})
    public Velocity getVelocity() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Velocity");
            Velocity velocity = this.imu.getVelocity();
            return velocity;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"initialize"})
    public void initialize(Object parametersArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".initialize");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null) {
                this.imu.initialize((Object)parameters);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"startAccelerationIntegration"})
    public void startAccelerationIntegration_with1(int msPollInterval) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".startAccelerationIntegration");
            this.imu.startAccelerationIntegration(null, null, msPollInterval);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"startAccelerationIntegration"})
    public void startAccelerationIntegration_with3(Object initialPositionArg, Object initialVelocityArg, int msPollInterval) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".startAccelerationIntegration");
            Position initialPosition = this.checkArg(initialPositionArg, Position.class, "initialPosition");
            Velocity initialVelocity = this.checkArg(initialVelocityArg, Velocity.class, "initialVelocity");
            if (initialPosition != null && initialVelocity != null) {
                this.imu.startAccelerationIntegration(initialPosition, initialVelocity, msPollInterval);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"stopAccelerationIntegration"})
    public void stopAccelerationIntegration() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".stopAccelerationIntegration");
            this.imu.stopAccelerationIntegration();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"isSystemCalibrated"})
    public boolean isSystemCalibrated() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isSystemCalibrated");
            boolean bl = this.imu.isSystemCalibrated();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"isGyroCalibrated"})
    public boolean isGyroCalibrated() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isGyroCalibrated");
            boolean bl = this.imu.isGyroCalibrated();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"isAccelerometerCalibrated"})
    public boolean isAccelerometerCalibrated() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isAccelerometerCalibrated");
            boolean bl = this.imu.isAccelerometerCalibrated();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"isMagnetometerCalibrated"})
    public boolean isMagnetometerCalibrated() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isMagnetometerCalibrated");
            boolean bl = this.imu.isMagnetometerCalibrated();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"readCalibrationData"})
    public void saveCalibrationData(String absoluteFileName) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".saveCalibrationData");
            ReadWriteFile.writeFile((File)AppUtil.getInstance().getSettingsFile(absoluteFileName), (String)this.imu.readCalibrationData().serialize());
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"setI2cAddress"})
    public void setI2cAddress7Bit(int i2cAddr7Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress7Bit");
            this.imu.setI2cAddress(I2cAddr.create7bit((int)i2cAddr7Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getI2cAddress"})
    public int getI2cAddress7Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress7Bit");
            I2cAddr i2cAddr = this.imu.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get7Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"setI2cAddress"})
    public void setI2cAddress8Bit(int i2cAddr8Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress8Bit");
            this.imu.setI2cAddress(I2cAddr.create8bit((int)i2cAddr8Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getI2cAddress"})
    public int getI2cAddress8Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress8Bit");
            I2cAddr i2cAddr = this.imu.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get8Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getAngularVelocityAxes"})
    public String getAngularVelocityAxes() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AngularVelocityAxes");
            Set axes = this.imu.getAngularVelocityAxes();
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            String delimiter = "";
            for (Axis axis : axes) {
                sb.append(delimiter).append("\"").append(axis.toString()).append("\"");
                delimiter = ",";
            }
            sb.append("]");
            String string = sb.toString();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getAngularVelocity"})
    public AngularVelocity getAngularVelocity(String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getAngularVelocity");
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (angleUnit != null) {
                AngularVelocity angularVelocity = this.imu.getAngularVelocity(angleUnit);
                return angularVelocity;
            }
            AngularVelocity angularVelocity = null;
            return angularVelocity;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getAngularOrientationAxes"})
    public String getAngularOrientationAxes() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AngularOrientationAxes");
            Set axes = this.imu.getAngularOrientationAxes();
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            String delimiter = "";
            for (Axis axis : axes) {
                sb.append(delimiter).append("\"").append(axis.toString()).append("\"");
                delimiter = ",";
            }
            sb.append("]");
            String string = sb.toString();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitBNO055IMU.class, LynxEmbeddedIMU.class}, methodName={"getAngularOrientation"})
    public Orientation getAngularOrientation(String axesReferenceString, String axesOrderString, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getAngularOrientation");
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (axesReference != null && axesOrder != null && angleUnit != null) {
                Orientation orientation = this.imu.getAngularOrientation(axesReference, axesOrder, angleUnit);
                return orientation;
            }
            Orientation orientation = null;
            return orientation;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

