/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.qualcomm.hardware.bosch.BNO055IMU;
import com.qualcomm.hardware.bosch.JustLoggingAccelerationIntegrator;
import com.qualcomm.hardware.bosch.NaiveAccelerationIntegrator;
import com.qualcomm.robotcore.hardware.I2cAddr;

class BNO055IMUParametersAccess
extends Access {
    BNO055IMUParametersAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "IMU-BNO055.Parameters");
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, constructor=true)
    public BNO055IMU.Parameters create() {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            BNO055IMU.Parameters parameters = new BNO055IMU.Parameters();
            return parameters;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"accelUnit"})
    public void setAccelUnit(Object parametersArg, String accelUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setAccelUnit");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            BNO055IMU.AccelUnit accelUnit = this.checkArg(accelUnitString, BNO055IMU.AccelUnit.class, "accelUnit");
            if (parameters != null && accelUnit != null) {
                parameters.accelUnit = accelUnit;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"accelUnit"})
    public String getAccelUnit(Object parametersArg) {
        try {
            BNO055IMU.AccelUnit accelUnit;
            this.startBlockExecution(BlockType.GETTER, ".AccelUnit");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null && (accelUnit = parameters.accelUnit) != null) {
                String string = accelUnit.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"accelerationIntegrationAlgorithm"})
    public void setAccelerationIntegrationAlgorithm(Object parametersArg, String algorithmString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setAccelerationIntegrationAlgorithm");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            Algorithm algorithm = this.checkArg(algorithmString, Algorithm.class, "accelerationIntegrationAlgorithm");
            if (parameters == null) return;
            if (algorithm == null) return;
            switch (algorithm) {
                case NAIVE: {
                    parameters.accelerationIntegrationAlgorithm = null;
                    return;
                }
                case JUST_LOGGING: {
                    parameters.accelerationIntegrationAlgorithm = new JustLoggingAccelerationIntegrator();
                    return;
                }
            }
            return;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"accelerationIntegrationAlgorithm"})
    public String getAccelerationIntegrationAlgorithm(Object parametersArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AccelerationIntegrationAlgorithm");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null) {
                BNO055IMU.AccelerationIntegrator accelerationIntegrator = parameters.accelerationIntegrationAlgorithm;
                if (accelerationIntegrator == null || accelerationIntegrator instanceof NaiveAccelerationIntegrator) {
                    String string = "NAIVE";
                    return string;
                }
                if (accelerationIntegrator instanceof JustLoggingAccelerationIntegrator) {
                    String string = "JUST_LOGGING";
                    return string;
                }
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"angleUnit"})
    public void setAngleUnit(Object parametersArg, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setAngleUnit");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            BNO055IMU.AngleUnit angleUnit = this.checkArg(angleUnitString, BNO055IMU.AngleUnit.class, "angleUnit");
            if (parameters != null && angleUnit != null) {
                parameters.angleUnit = angleUnit;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"angleUnit"})
    public String getAngleUnit(Object parametersArg) {
        try {
            BNO055IMU.AngleUnit angleUnit;
            this.startBlockExecution(BlockType.GETTER, ".AngleUnit");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null && (angleUnit = parameters.angleUnit) != null) {
                String string = angleUnit.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"calibrationDataFile"})
    public void setCalibrationDataFile(Object parametersArg, String calibrationDataFile) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setCalibrationDataFile");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null) {
                parameters.calibrationDataFile = calibrationDataFile;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"calibrationDataFile"})
    public String getCalibrationDataFile(Object parametersArg) {
        try {
            String calibrationDataFile;
            this.startBlockExecution(BlockType.GETTER, ".CalibrationDataFile");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null && (calibrationDataFile = parameters.calibrationDataFile) != null) {
                String string = calibrationDataFile;
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"i2cAddr"})
    public void setI2cAddress7Bit(Object parametersArg, int i2cAddr7Bit) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setI2cAddress7Bit");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null) {
                parameters.i2cAddr = I2cAddr.create7bit((int)i2cAddr7Bit);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"i2cAddr"})
    public int getI2cAddress7Bit(Object parametersArg) {
        try {
            I2cAddr i2cAddr;
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress7Bit");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null && (i2cAddr = parameters.i2cAddr) != null) {
                int n = i2cAddr.get7Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"i2cAddr"})
    public void setI2cAddress8Bit(Object parametersArg, int i2cAddr8Bit) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setI2cAddress8Bit");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null) {
                parameters.i2cAddr = I2cAddr.create8bit((int)i2cAddr8Bit);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"i2cAddr"})
    public int getI2cAddress8Bit(Object parametersArg) {
        try {
            I2cAddr i2cAddr;
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress8Bit");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null && (i2cAddr = parameters.i2cAddr) != null) {
                int n = i2cAddr.get8Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"loggingEnabled"})
    public void setLoggingEnabled(Object parametersArg, boolean loggingEnabled) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setLoggingEnabled");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null) {
                parameters.loggingEnabled = loggingEnabled;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"loggingEnabled"})
    public boolean getLoggingEnabled(Object parametersArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LoggingEnabled");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null) {
                boolean bl = parameters.loggingEnabled;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"loggingTag"})
    public void setLoggingTag(Object parametersArg, String loggingTag) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setLoggingTag");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null) {
                parameters.loggingTag = loggingTag;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"loggingTag"})
    public String getLoggingTag(Object parametersArg) {
        try {
            String loggingTag;
            this.startBlockExecution(BlockType.GETTER, ".LoggingTag");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null && (loggingTag = parameters.loggingTag) != null) {
                String string = loggingTag;
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"mode"})
    public void setSensorMode(Object parametersArg, String sensorModeString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setSensorMode");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            BNO055IMU.SensorMode sensorMode = this.checkArg(sensorModeString, BNO055IMU.SensorMode.class, "sensorMode");
            if (parameters != null && sensorMode != null) {
                parameters.mode = sensorMode;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"mode"})
    public String getSensorMode(Object parametersArg) {
        try {
            BNO055IMU.SensorMode sensorMode;
            this.startBlockExecution(BlockType.GETTER, ".SensorMode");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null && (sensorMode = parameters.mode) != null) {
                String string = sensorMode.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"temperatureUnit"})
    public void setTempUnit(Object parametersArg, String tempUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setTempUnit");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            BNO055IMU.TempUnit tempUnit = this.checkArg(tempUnitString, BNO055IMU.TempUnit.class, "tempUnit");
            if (parameters != null && tempUnit != null) {
                parameters.temperatureUnit = tempUnit;
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={BNO055IMU.Parameters.class}, fieldName={"temperatureUnit"})
    public String getTempUnit(Object parametersArg) {
        try {
            BNO055IMU.TempUnit tempUnit;
            this.startBlockExecution(BlockType.GETTER, ".TempUnit");
            BNO055IMU.Parameters parameters = this.checkBNO055IMUParameters(parametersArg);
            if (parameters != null && (tempUnit = parameters.temperatureUnit) != null) {
                String string = tempUnit.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    static enum Algorithm {
        NAIVE,
        JUST_LOGGING;

    }
}

