/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.webkit.ConsoleMessage;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItemMap;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareType;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareUtil;
import com.google.blocks.ftcrobotcontroller.runtime.AccelerationAccess;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.AndroidAccelerometerAccess;
import com.google.blocks.ftcrobotcontroller.runtime.AndroidGyroscopeAccess;
import com.google.blocks.ftcrobotcontroller.runtime.AndroidOrientationAccess;
import com.google.blocks.ftcrobotcontroller.runtime.AndroidSoundPoolAccess;
import com.google.blocks.ftcrobotcontroller.runtime.AndroidTextToSpeechAccess;
import com.google.blocks.ftcrobotcontroller.runtime.AngularVelocityAccess;
import com.google.blocks.ftcrobotcontroller.runtime.AprilTagAccess;
import com.google.blocks.ftcrobotcontroller.runtime.BNO055IMUParametersAccess;
import com.google.blocks.ftcrobotcontroller.runtime.BlinkinPatternAccess;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.ColorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.ColorBlobLocatorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.DbgLogAccess;
import com.google.blocks.ftcrobotcontroller.runtime.ElapsedTimeAccess;
import com.google.blocks.ftcrobotcontroller.runtime.ExposureControlAccess;
import com.google.blocks.ftcrobotcontroller.runtime.FocusControlAccess;
import com.google.blocks.ftcrobotcontroller.runtime.GainControlAccess;
import com.google.blocks.ftcrobotcontroller.runtime.GamepadAccess;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.google.blocks.ftcrobotcontroller.runtime.ImuParametersAccess;
import com.google.blocks.ftcrobotcontroller.runtime.LLResultAccess;
import com.google.blocks.ftcrobotcontroller.runtime.LLStatusAccess;
import com.google.blocks.ftcrobotcontroller.runtime.LedEffectAccess;
import com.google.blocks.ftcrobotcontroller.runtime.LinearOpModeAccess;
import com.google.blocks.ftcrobotcontroller.runtime.MagneticFluxAccess;
import com.google.blocks.ftcrobotcontroller.runtime.MatrixFAccess;
import com.google.blocks.ftcrobotcontroller.runtime.MiscAccess;
import com.google.blocks.ftcrobotcontroller.runtime.NavigationAccess;
import com.google.blocks.ftcrobotcontroller.runtime.OpenGLMatrixAccess;
import com.google.blocks.ftcrobotcontroller.runtime.OpencvAccess;
import com.google.blocks.ftcrobotcontroller.runtime.OrientationAccess;
import com.google.blocks.ftcrobotcontroller.runtime.PIDFCoefficientsAccess;
import com.google.blocks.ftcrobotcontroller.runtime.PositionAccess;
import com.google.blocks.ftcrobotcontroller.runtime.PredominantColorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.PtzControlAccess;
import com.google.blocks.ftcrobotcontroller.runtime.QuaternionAccess;
import com.google.blocks.ftcrobotcontroller.runtime.RangeAccess;
import com.google.blocks.ftcrobotcontroller.runtime.Rev9AxisImuOrientationOnRobotAccess;
import com.google.blocks.ftcrobotcontroller.runtime.RevHubOrientationOnRobotAccess;
import com.google.blocks.ftcrobotcontroller.runtime.RumbleEffectAccess;
import com.google.blocks.ftcrobotcontroller.runtime.SystemAccess;
import com.google.blocks.ftcrobotcontroller.runtime.TelemetryAccess;
import com.google.blocks.ftcrobotcontroller.runtime.TemperatureAccess;
import com.google.blocks.ftcrobotcontroller.runtime.VectorFAccess;
import com.google.blocks.ftcrobotcontroller.runtime.VelocityAccess;
import com.google.blocks.ftcrobotcontroller.runtime.VisionPortalAccess;
import com.google.blocks.ftcrobotcontroller.runtime.WhiteBalanceControlAccess;
import com.google.blocks.ftcrobotcontroller.runtime.YawPitchRollAnglesAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.TensorFlowAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.TfodAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.TfodCurrentGameAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.TfodCustomModelAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.TfodRoverRuckusAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.TfodSkyStoneAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.VuforiaCurrentGameAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.VuforiaLocalizerAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.VuforiaLocalizerParametersAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.VuforiaRelicRecoveryAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.VuforiaRoverRuckusAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.VuforiaSkyStoneAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.VuforiaTrackableAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.VuforiaTrackableDefaultListenerAccess;
import com.google.blocks.ftcrobotcontroller.runtime.obsolete.VuforiaTrackablesAccess;
import com.google.blocks.ftcrobotcontroller.util.FileUtil;
import com.google.blocks.ftcrobotcontroller.util.Identifier;
import com.google.blocks.ftcrobotcontroller.util.ProjectsUtil;
import com.qualcomm.hardware.bosch.BNO055IMUImpl;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.robotcore.eventloop.opmode.LinearOpMode;
import com.qualcomm.robotcore.eventloop.opmode.OpMode;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManager;
import com.qualcomm.robotcore.hardware.EmbeddedControlHubModule;
import com.qualcomm.robotcore.hardware.LynxModuleImuType;
import com.qualcomm.robotcore.util.RobotLog;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.firstinspires.ftc.robotcore.external.BlocksOpModeCompanion;
import org.firstinspires.ftc.robotcore.internal.opmode.InstanceOpModeManager;
import org.firstinspires.ftc.robotcore.internal.opmode.InstanceOpModeRegistrar;
import org.firstinspires.ftc.robotcore.internal.opmode.OpModeMeta;
import org.firstinspires.ftc.robotcore.internal.opmode.RegisteredOpModes;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;

public final class BlocksOpMode
extends LinearOpMode {
    private static final String BLOCK_EXECUTION_ERROR = "Error: Error calling method on NPObject.";
    private static final String LOG_PREFIX = "BlocksOpMode - ";
    private static final boolean DEBUG_BLOCKS_EXECUTION = false;
    private static final AtomicReference<RuntimeException> fatalExceptionHolder = new AtomicReference();
    private static final AtomicReference<String> fatalErrorMessageHolder = new AtomicReference();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Activity activity;
    @SuppressLint(value={"StaticFieldLeak"})
    private static WebView webView;
    private static final AtomicReference<String> nameOfOpModeLoadedIntoWebView;
    static final Map<String, Access> javascriptInterfaces;
    private final String project;
    private final String logPrefix;
    private final AtomicLong interruptedTime = new AtomicLong();
    private volatile BlockType currentBlockType;
    private volatile boolean currentBlockFinished;
    private volatile String currentBlockFirstName;
    private volatile String currentBlockLastName;
    private volatile Thread javaBridgeThread;
    private volatile boolean forceStopped = false;
    private volatile boolean wasTerminated = false;

    BlocksOpMode(String project) {
        this.project = project;
        this.logPrefix = "BlocksOpMode - \"" + project + "\" - ";
    }

    private String getLogPrefix() {
        Thread thread = Thread.currentThread();
        return this.logPrefix + thread.getThreadGroup().getName() + "/" + thread.getName() + " - ";
    }

    void startBlockExecution(BlockType blockType, String blockFirstName, String blockLastName) {
        this.currentBlockType = blockType;
        this.currentBlockFirstName = blockFirstName;
        this.currentBlockLastName = blockLastName;
        this.currentBlockFinished = false;
        this.checkIfStopRequested();
    }

    void endBlockExecution() {
        if (fatalExceptionHolder.get() == null) {
            this.currentBlockFinished = true;
        }
    }

    String getFullBlockLabel() {
        switch (this.currentBlockType) {
            default: {
                return "to runOpmode";
            }
            case SPECIAL: {
                return this.currentBlockFirstName + this.currentBlockLastName;
            }
            case EVENT: {
                return "to " + this.currentBlockFirstName + this.currentBlockLastName;
            }
            case CREATE: {
                return "new " + this.currentBlockFirstName;
            }
            case SETTER: {
                return "set " + this.currentBlockFirstName + this.currentBlockLastName + " to";
            }
            case GETTER: {
                return this.currentBlockFirstName + this.currentBlockLastName;
            }
            case FUNCTION: 
        }
        return "call " + this.currentBlockFirstName + this.currentBlockLastName;
    }

    public void handleFatalException(Throwable e) {
        String errorMessage = e.getClass().getSimpleName() + (e.getMessage() != null ? " - " + e.getMessage() : "");
        RuntimeException re = new RuntimeException("Fatal error occurred while executing the block labeled \"" + this.getFullBlockLabel() + "\". " + errorMessage, e);
        fatalExceptionHolder.set(re);
        throw re;
    }

    private void checkIfStopRequested() {
        if (this.interruptedTime.get() != 0L && this.isStopRequested() && System.currentTimeMillis() - this.interruptedTime.get() >= 800L) {
            RobotLog.i((String)(this.getLogPrefix() + "checkIfStopRequested - about to stop OpMode by throwing RuntimeException"));
            this.forceStopped = true;
            throw new RuntimeException("Stopping OpMode " + this.project + " by force.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitForStartForBlocks() {
        RobotLog.i((String)(this.getLogPrefix() + "waitForStartForBlocks - start"));
        try {
            while (!this.isStartedForBlocks()) {
                BlocksOpMode blocksOpMode = this;
                synchronized (blocksOpMode) {
                    try {
                        ((Object)((Object)this)).wait(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 9] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                        RobotLog.i((String)(this.getLogPrefix() + "waitForStartForBlocks - end"));
                        return;
                    }
                }
            }
            return;
        }
        finally {
            RobotLog.i((String)(this.getLogPrefix() + "waitForStartForBlocks - end"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sleepForBlocks(long millis) {
        RobotLog.i((String)(this.getLogPrefix() + "sleepForBlocks - start"));
        try {
            long endTime = System.currentTimeMillis() + millis;
            while (!this.isInterrupted()) {
                long chunk = Math.min(100L, endTime - System.currentTimeMillis());
                if (chunk <= 0L) {
                    break;
                }
                this.sleep(chunk);
            }
        }
        finally {
            RobotLog.i((String)(this.getLogPrefix() + "sleepForBlocks - end"));
        }
    }

    private boolean isInterrupted() {
        return this.interruptedTime.get() != 0L;
    }

    boolean isStartedForBlocks() {
        return super.isStarted() || this.isInterrupted();
    }

    boolean isStopRequestedForBlocks() {
        return super.isStopRequested() || this.isInterrupted();
    }

    void terminateOpModeNowForBlocks() {
        this.wasTerminated = true;
        super.terminateOpModeNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOpMode() {
        RobotLog.i((String)(this.getLogPrefix() + "runOpMode - start"));
        this.cleanUpPreviousBlocksOpMode();
        BlocksOpModeCompanion.opMode = this;
        BlocksOpModeCompanion.linearOpMode = this;
        BlocksOpModeCompanion.hardwareMap = this.hardwareMap;
        BlocksOpModeCompanion.telemetry = this.telemetry;
        BlocksOpModeCompanion.gamepad1 = this.gamepad1;
        BlocksOpModeCompanion.gamepad2 = this.gamepad2;
        try {
            RuntimeException fatalException;
            fatalExceptionHolder.set(null);
            fatalErrorMessageHolder.set(null);
            this.currentBlockType = BlockType.EVENT;
            this.currentBlockFirstName = "";
            this.currentBlockLastName = "runOpMode";
            boolean interrupted = false;
            this.interruptedTime.set(0L);
            AtomicBoolean scriptFinished = new AtomicBoolean();
            Object scriptFinishedLock = new Object();
            BlocksOpModeAccess blocksOpModeAccess = new BlocksOpModeAccess(Identifier.BLOCKS_OP_MODE.identifierForJavaScript, scriptFinishedLock, scriptFinished);
            javascriptInterfaces.put(Identifier.BLOCKS_OP_MODE.identifierForJavaScript, blocksOpModeAccess);
            AppUtil appUtil = AppUtil.getInstance();
            Object object = scriptFinishedLock;
            synchronized (object) {
                appUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                RobotLog.i((String)(BlocksOpMode.this.getLogPrefix() + "run1 - before loadScript"));
                                BlocksOpMode.this.loadScript();
                                RobotLog.i((String)(BlocksOpMode.this.getLogPrefix() + "run1 - after loadScript"));
                            }
                            catch (Exception e) {
                                RobotLog.e((String)(BlocksOpMode.this.getLogPrefix() + "run1 - caught " + e));
                                if (e.getStackTrace() == null) break block2;
                                RobotLog.logStackTrace((Throwable)e);
                            }
                        }
                    }
                });
                RobotLog.i((String)(this.getLogPrefix() + "runOpMode - before while !scriptFinished loop"));
                while (!scriptFinished.get()) {
                    try {
                        scriptFinishedLock.wait();
                    }
                    catch (InterruptedException e) {
                        RobotLog.e((String)(this.getLogPrefix() + "runOpMode - caught InterruptedException during scriptFinishedLock.wait"));
                        interrupted = true;
                        this.interruptedTime.set(System.currentTimeMillis());
                        if (this.javaBridgeThread == null) continue;
                        this.javaBridgeThread.interrupt();
                    }
                }
                RobotLog.i((String)(this.getLogPrefix() + "runOpMode - after while !scriptFinished loop"));
            }
            appUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            RobotLog.i((String)(BlocksOpMode.this.getLogPrefix() + "run2 - before clearScript"));
                            BlocksOpMode.this.clearScript();
                            RobotLog.i((String)(BlocksOpMode.this.getLogPrefix() + "run2 - after clearScript"));
                        }
                        catch (Exception e) {
                            RobotLog.e((String)(BlocksOpMode.this.getLogPrefix() + "run2 - caught " + e));
                            if (e.getStackTrace() == null) break block2;
                            RobotLog.logStackTrace((Throwable)e);
                        }
                    }
                }
            });
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if ((fatalException = (RuntimeException)fatalExceptionHolder.getAndSet(null)) != null) {
                throw fatalException;
            }
            String fatalErrorMessage = fatalErrorMessageHolder.getAndSet(null);
            if (fatalErrorMessage != null) {
                RobotLog.setGlobalErrorMsg((String)fatalErrorMessage);
            }
        }
        finally {
            long interruptedTime = this.interruptedTime.get();
            if (interruptedTime != 0L) {
                RobotLog.i((String)(this.getLogPrefix() + "runOpMode - end - " + (System.currentTimeMillis() - interruptedTime) + "ms after InterruptedException"));
            } else {
                RobotLog.i((String)(this.getLogPrefix() + "runOpMode - end - no InterruptedException"));
            }
            BlocksOpModeCompanion.opMode = null;
            BlocksOpModeCompanion.linearOpMode = null;
        }
    }

    private void cleanUpPreviousBlocksOpMode() {
        String name = nameOfOpModeLoadedIntoWebView.get();
        if (name != null) {
            RobotLog.w((String)(this.getLogPrefix() + "cleanUpPreviousBlocksOpMode - Warning: The Blocks runtime system is still loaded with the Blocks OpMode named " + name + "."));
            RobotLog.w((String)(this.getLogPrefix() + "cleanUpPreviousBlocksOpMode - Trying to clean up now."));
            AppUtil.getInstance().synchronousRunOnUiThread(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            RobotLog.w((String)(BlocksOpMode.this.getLogPrefix() + "cleanUpPreviousBlocksOpMode run - before clearScript"));
                            BlocksOpMode.this.clearScript();
                            RobotLog.w((String)(BlocksOpMode.this.getLogPrefix() + "cleanUpPreviousBlocksOpMode run - after clearScript"));
                        }
                        catch (Exception e) {
                            RobotLog.e((String)(BlocksOpMode.this.getLogPrefix() + "cleanUpPreviousBlocksOpMode run - caught " + e));
                            if (e.getStackTrace() == null) break block2;
                            RobotLog.logStackTrace((Throwable)e);
                        }
                    }
                }
            });
            if (nameOfOpModeLoadedIntoWebView.get() != null) {
                RobotLog.w((String)(this.getLogPrefix() + "cleanUpPreviousBlocksOpMode - Clean up was successful."));
            } else {
                RobotLog.e((String)(this.getLogPrefix() + "cleanUpPreviousBlocksOpMode - Error: Clean up failed."));
                throw new RuntimeException("Unable to start running the Blocks OpMode named " + this.project + ". The Blocks runtime system is still loaded with the previous Blocks OpMode named " + name + ". Please restart the Robot Controller app.");
            }
        }
    }

    @SuppressLint(value={"JavascriptInterface"})
    private void addJavascriptInterfaces(HardwareItemMap hardwareItemMap, Set<String> identifiersUsed) {
        this.addJavascriptInterfacesForIdentifiers();
        this.addObsoleteJavascriptInterfaces();
        for (Identifier identifier : Identifier.values()) {
            if (javascriptInterfaces.containsKey(identifier.identifierForJavaScript)) continue;
            throw new RuntimeException("There is no javascript interface for Identifier." + (Object)((Object)identifier));
        }
        this.addJavascriptInterfacesForHardware(hardwareItemMap, identifiersUsed);
        for (Map.Entry entry : javascriptInterfaces.entrySet()) {
            String identifier = (String)entry.getKey();
            Access access = (Access)entry.getValue();
            webView.addJavascriptInterface((Object)access, identifier);
        }
    }

    private void addJavascriptInterface(String identifier, Access access) {
        if (javascriptInterfaces.containsKey(identifier)) {
            throw new RuntimeException("Duplicate identifier: " + identifier);
        }
        javascriptInterfaces.put(identifier, access);
    }

    void addJavascriptInterfacesForIdentifiers() {
        this.addJavascriptInterface(Identifier.ACCELERATION.identifierForJavaScript, new AccelerationAccess(this, Identifier.ACCELERATION.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.ANDROID_ACCELEROMETER.identifierForJavaScript, new AndroidAccelerometerAccess(this, Identifier.ANDROID_ACCELEROMETER.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.ANDROID_GYROSCOPE.identifierForJavaScript, new AndroidGyroscopeAccess(this, Identifier.ANDROID_GYROSCOPE.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.ANDROID_ORIENTATION.identifierForJavaScript, new AndroidOrientationAccess(this, Identifier.ANDROID_ORIENTATION.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.ANDROID_SOUND_POOL.identifierForJavaScript, new AndroidSoundPoolAccess(this, Identifier.ANDROID_SOUND_POOL.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.ANDROID_TEXT_TO_SPEECH.identifierForJavaScript, new AndroidTextToSpeechAccess(this, Identifier.ANDROID_TEXT_TO_SPEECH.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.ANGULAR_VELOCITY.identifierForJavaScript, new AngularVelocityAccess(this, Identifier.ANGULAR_VELOCITY.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.APRIL_TAG.identifierForJavaScript, new AprilTagAccess(this, Identifier.APRIL_TAG.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.BLINKIN_PATTERN.identifierForJavaScript, new BlinkinPatternAccess(this, Identifier.BLINKIN_PATTERN.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.BNO055IMU_PARAMETERS.identifierForJavaScript, new BNO055IMUParametersAccess(this, Identifier.BNO055IMU_PARAMETERS.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.COLOR.identifierForJavaScript, new ColorAccess(this, Identifier.COLOR.identifierForJavaScript, activity));
        this.addJavascriptInterface(Identifier.COLOR_BLOB_LOCATOR.identifierForJavaScript, new ColorBlobLocatorAccess(this, Identifier.COLOR_BLOB_LOCATOR.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.DBG_LOG.identifierForJavaScript, new DbgLogAccess(this, Identifier.DBG_LOG.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.ELAPSED_TIME.identifierForJavaScript, new ElapsedTimeAccess(this, Identifier.ELAPSED_TIME.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.EXPOSURE_CONTROL.identifierForJavaScript, new ExposureControlAccess(this, Identifier.EXPOSURE_CONTROL.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.FOCUS_CONTROL.identifierForJavaScript, new FocusControlAccess(this, Identifier.FOCUS_CONTROL.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.GAIN_CONTROL.identifierForJavaScript, new GainControlAccess(this, Identifier.GAIN_CONTROL.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.GAMEPAD_1.identifierForJavaScript, new GamepadAccess(this, Identifier.GAMEPAD_1.identifierForJavaScript, this.gamepad1));
        this.addJavascriptInterface(Identifier.GAMEPAD_2.identifierForJavaScript, new GamepadAccess(this, Identifier.GAMEPAD_2.identifierForJavaScript, this.gamepad2));
        this.addJavascriptInterface(Identifier.IMU_PARAMETERS.identifierForJavaScript, new ImuParametersAccess(this, Identifier.IMU_PARAMETERS.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.LED_EFFECT.identifierForJavaScript, new LedEffectAccess(this, Identifier.LED_EFFECT.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.LL_RESULT.identifierForJavaScript, new LLResultAccess(this, Identifier.LL_RESULT.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.LL_STATUS.identifierForJavaScript, new LLStatusAccess(this, Identifier.LL_STATUS.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.LINEAR_OP_MODE.identifierForJavaScript, new LinearOpModeAccess(this, Identifier.LINEAR_OP_MODE.identifierForJavaScript, this.project));
        this.addJavascriptInterface(Identifier.MAGNETIC_FLUX.identifierForJavaScript, new MagneticFluxAccess(this, Identifier.MAGNETIC_FLUX.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.MATRIX_F.identifierForJavaScript, new MatrixFAccess(this, Identifier.MATRIX_F.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.MISC.identifierForJavaScript, new MiscAccess(this, Identifier.MISC.identifierForJavaScript, this.hardwareMap));
        this.addJavascriptInterface(Identifier.NAVIGATION.identifierForJavaScript, new NavigationAccess(this, Identifier.NAVIGATION.identifierForJavaScript, this.hardwareMap));
        this.addJavascriptInterface(Identifier.OPENCV.identifierForJavaScript, new OpencvAccess(this, Identifier.OPENCV.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OPEN_GL_MATRIX.identifierForJavaScript, new OpenGLMatrixAccess(this, Identifier.OPEN_GL_MATRIX.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.ORIENTATION.identifierForJavaScript, new OrientationAccess(this, Identifier.ORIENTATION.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.PIDF_COEFFICIENTS.identifierForJavaScript, new PIDFCoefficientsAccess(this, Identifier.PIDF_COEFFICIENTS.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.POSITION.identifierForJavaScript, new PositionAccess(this, Identifier.POSITION.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.PREDOMINANT_COLOR.identifierForJavaScript, new PredominantColorAccess(this, Identifier.PREDOMINANT_COLOR.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.PTZ_CONTROL.identifierForJavaScript, new PtzControlAccess(this, Identifier.PTZ_CONTROL.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.QUATERNION.identifierForJavaScript, new QuaternionAccess(this, Identifier.QUATERNION.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.RANGE.identifierForJavaScript, new RangeAccess(this, Identifier.RANGE.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.REV_HUB_ORIENTATION_ON_ROBOT.identifierForJavaScript, new RevHubOrientationOnRobotAccess(this, Identifier.REV_HUB_ORIENTATION_ON_ROBOT.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.REV_9AXIS_IMU_ORIENTATION_ON_ROBOT.identifierForJavaScript, new Rev9AxisImuOrientationOnRobotAccess(this, Identifier.REV_9AXIS_IMU_ORIENTATION_ON_ROBOT.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.RUMBLE_EFFECT.identifierForJavaScript, new RumbleEffectAccess(this, Identifier.RUMBLE_EFFECT.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.SYSTEM.identifierForJavaScript, new SystemAccess(this, Identifier.SYSTEM.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.TELEMETRY.identifierForJavaScript, new TelemetryAccess(this, Identifier.TELEMETRY.identifierForJavaScript, this.telemetry));
        this.addJavascriptInterface(Identifier.TEMPERATURE.identifierForJavaScript, new TemperatureAccess(this, Identifier.TEMPERATURE.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.VECTOR_F.identifierForJavaScript, new VectorFAccess(this, Identifier.VECTOR_F.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.VELOCITY.identifierForJavaScript, new VelocityAccess(this, Identifier.VELOCITY.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.VISION_PORTAL.identifierForJavaScript, new VisionPortalAccess(this, Identifier.VISION_PORTAL.identifierForJavaScript, this.hardwareMap));
        this.addJavascriptInterface(Identifier.WHITE_BALANCE_CONTROL.identifierForJavaScript, new WhiteBalanceControlAccess(this, Identifier.WHITE_BALANCE_CONTROL.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.YAW_PITCH_ROLL_ANGLES.identifierForJavaScript, new YawPitchRollAnglesAccess(this, Identifier.YAW_PITCH_ROLL_ANGLES.identifierForJavaScript));
    }

    void addObsoleteJavascriptInterfaces() {
        this.addJavascriptInterface(Identifier.OBSOLETE_TENSOR_FLOW.identifierForJavaScript, new TensorFlowAccess(this, Identifier.OBSOLETE_TENSOR_FLOW.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_TFOD.identifierForJavaScript, new TfodAccess(this, Identifier.OBSOLETE_TFOD.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_TFOD_CURRENT_GAME.identifierForJavaScript, new TfodCurrentGameAccess(this, Identifier.OBSOLETE_TFOD_CURRENT_GAME.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_TFOD_CUSTOM_MODEL.identifierForJavaScript, new TfodCustomModelAccess(this, Identifier.OBSOLETE_TFOD_CUSTOM_MODEL.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_TFOD_ROVER_RUCKUS.identifierForJavaScript, new TfodRoverRuckusAccess(this, Identifier.OBSOLETE_TFOD_ROVER_RUCKUS.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_TFOD_SKY_STONE.identifierForJavaScript, new TfodSkyStoneAccess(this, Identifier.OBSOLETE_TFOD_SKY_STONE.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_VUFORIA_CURRENT_GAME.identifierForJavaScript, new VuforiaCurrentGameAccess(this, Identifier.OBSOLETE_VUFORIA_CURRENT_GAME.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_VUFORIA_RELIC_RECOVERY.identifierForJavaScript, new VuforiaRelicRecoveryAccess(this, Identifier.OBSOLETE_VUFORIA_RELIC_RECOVERY.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_VUFORIA_ROVER_RUCKUS.identifierForJavaScript, new VuforiaRoverRuckusAccess(this, Identifier.OBSOLETE_VUFORIA_ROVER_RUCKUS.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_VUFORIA_SKY_STONE.identifierForJavaScript, new VuforiaSkyStoneAccess(this, Identifier.OBSOLETE_VUFORIA_SKY_STONE.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_VUFORIA_LOCALIZER.identifierForJavaScript, new VuforiaLocalizerAccess(this, Identifier.OBSOLETE_VUFORIA_LOCALIZER.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_VUFORIA_LOCALIZER_PARAMETERS.identifierForJavaScript, new VuforiaLocalizerParametersAccess(this, Identifier.OBSOLETE_VUFORIA_LOCALIZER_PARAMETERS.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_VUFORIA_TRACKABLE.identifierForJavaScript, new VuforiaTrackableAccess(this, Identifier.OBSOLETE_VUFORIA_TRACKABLE.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_VUFORIA_TRACKABLE_DEFAULT_LISTENER.identifierForJavaScript, new VuforiaTrackableDefaultListenerAccess(this, Identifier.OBSOLETE_VUFORIA_TRACKABLE_DEFAULT_LISTENER.identifierForJavaScript));
        this.addJavascriptInterface(Identifier.OBSOLETE_VUFORIA_TRACKABLES.identifierForJavaScript, new VuforiaTrackablesAccess(this, Identifier.OBSOLETE_VUFORIA_TRACKABLES.identifierForJavaScript));
    }

    private void addJavascriptInterfacesForHardware(HardwareItemMap hardwareItemMap, Set<String> identifiersUsed) {
        for (HardwareType hardwareType : HardwareType.values()) {
            if (!hardwareItemMap.contains(hardwareType)) continue;
            for (HardwareItem hardwareItem : hardwareItemMap.getHardwareItems(hardwareType)) {
                if (identifiersUsed != null && !identifiersUsed.contains(hardwareItem.identifier)) {
                    RobotLog.i((String)(this.getLogPrefix() + "Skipping hardware device named \"" + hardwareItem.deviceName + "\". It isn't used in this Blocks OpMode."));
                    continue;
                }
                if (javascriptInterfaces.containsKey(hardwareItem.identifier)) {
                    RobotLog.w((String)(this.getLogPrefix() + "There is already a JavascriptInterface for identifier \"" + hardwareItem.identifier + "\". Ignoring hardware type " + (Object)((Object)hardwareType) + "."));
                    continue;
                }
                HardwareAccess access = HardwareAccess.newHardwareAccess(this, hardwareType, this.hardwareMap, hardwareItem);
                if (access == null) continue;
                javascriptInterfaces.put(hardwareItem.identifier, access);
            }
        }
    }

    private void removeJavascriptInterfaces() {
        Iterator<Map.Entry<String, Access>> it = javascriptInterfaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Access> entry = it.next();
            String identifier = entry.getKey();
            Access access = entry.getValue();
            webView.removeJavascriptInterface(identifier);
            access.close();
            it.remove();
        }
    }

    private static String missingIdentifierToHardwareDeviceName(String identifier) {
        for (HardwareType hardwareType : HardwareType.values()) {
            if (!identifier.endsWith(hardwareType.identifierSuffixForJavaScript)) continue;
            return identifier.substring(0, identifier.length() - hardwareType.identifierSuffixForJavaScript.length());
        }
        return null;
    }

    private void loadScript() throws IOException {
        RobotLog.i((String)(this.getLogPrefix() + "loadScript - WebView user agent is \"" + webView.getSettings().getUserAgentString() + "\""));
        nameOfOpModeLoadedIntoWebView.set(this.project);
        HardwareItemMap hardwareItemMap = HardwareItemMap.newHardwareItemMap(this.hardwareMap);
        HashSet<String> identifiersUsed = null;
        String jsFileContent = ProjectsUtil.fetchJsFileContent(this.project);
        if (jsFileContent.startsWith("// IDENTIFIERS_USED=")) {
            int eol = jsFileContent.indexOf("\n");
            identifiersUsed = new HashSet<String>(Arrays.asList(jsFileContent.substring("// IDENTIFIERS_USED=".length(), eol).split(",")));
            jsFileContent = jsFileContent.substring(eol);
        }
        this.addJavascriptInterfaces(hardwareItemMap, identifiersUsed);
        String jsContent = HardwareUtil.upgradeJs(jsFileContent, hardwareItemMap);
        StringBuilder html = new StringBuilder().append("<html><body onload='callRunOpMode()'><script type='text/javascript'>\n");
        FileUtil.readAsset(html, activity.getAssets(), "blocks/runtime.js");
        html.append("\n").append(jsContent).append("\n</script></body></html>\n");
        webView.loadDataWithBaseURL(null, html.toString(), "text/html", "UTF-8", null);
    }

    private void clearScript() {
        this.removeJavascriptInterfaces();
        if (!javascriptInterfaces.isEmpty()) {
            RobotLog.w((String)(this.getLogPrefix() + "clearScript - Warning: javascriptInterfaces is not empty."));
        }
        javascriptInterfaces.clear();
        webView.loadDataWithBaseURL(null, "", "text/html", "UTF-8", null);
        nameOfOpModeLoadedIntoWebView.set(null);
    }

    @SuppressLint(value={"setJavaScriptEnabled"})
    public static void setActivityAndWebView(Activity a, WebView wv) {
        if (activity == null && webView == null) {
            BlocksOpMode.addOpModeRegistrar();
        }
        activity = a;
        webView = wv;
        webView.getSettings().setJavaScriptEnabled(true);
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                return false;
            }
        });
    }

    private static void addOpModeRegistrar() {
        RegisteredOpModes.getInstance().addInstanceOpModeRegistrar(new InstanceOpModeRegistrar(){

            public void register(InstanceOpModeManager manager) {
                try {
                    List<OpModeMeta> projects = ProjectsUtil.fetchEnabledProjectsWithJavaScript();
                    for (OpModeMeta opModeMeta : projects) {
                        manager.register(opModeMeta, (OpMode)new BlocksOpMode(opModeMeta.name));
                    }
                }
                catch (Exception e) {
                    RobotLog.logStackTrace((Throwable)e);
                }
            }
        });
    }

    @Deprecated
    public static void registerAll(OpModeManager manager) {
        RobotLog.w((String)BlocksOpMode.class.getSimpleName(), (Object[])new Object[]{"registerAll(OpModeManager) is deprecated and will be removed soon, as calling it is unnecessary in this and future API version"});
    }

    static {
        nameOfOpModeLoadedIntoWebView = new AtomicReference();
        javascriptInterfaces = new ConcurrentHashMap<String, Access>();
    }

    private class BlocksOpModeAccess
    extends Access {
        private final Object scriptFinishedLock;
        private final AtomicBoolean scriptFinished;

        private BlocksOpModeAccess(String identifier, Object scriptFinishedLock, AtomicBoolean scriptFinished) {
            super(BlocksOpMode.this, identifier, "");
            this.scriptFinishedLock = scriptFinishedLock;
            this.scriptFinished = scriptFinished;
        }

        @JavascriptInterface
        public void scriptStarting() {
            RobotLog.i((String)(BlocksOpMode.this.getLogPrefix() + "scriptStarting"));
            Thread.interrupted();
            BlocksOpMode.this.javaBridgeThread = Thread.currentThread();
        }

        @JavascriptInterface
        public void caughtException(String message, String currentBlockLabel) {
            if (BlocksOpMode.this.wasTerminated) {
                return;
            }
            if (message != null) {
                if (message.startsWith("ReferenceError: ") && message.endsWith(" is not defined")) {
                    String missingIdentifier = message.substring(16, message.length() - 15);
                    String errorMessage = "Could not find identifier: " + missingIdentifier;
                    String missingHardwareDeviceName = BlocksOpMode.missingIdentifierToHardwareDeviceName(missingIdentifier);
                    if (missingHardwareDeviceName != null) {
                        String wrongImuErrorMessage;
                        errorMessage = "Could not find hardware device: " + missingHardwareDeviceName;
                        if (missingIdentifier.endsWith(HardwareType.BNO055IMU.identifierSuffixForJavaScript) && BlocksOpMode.this.hardwareMap.getAllNames(BNO055IMUImpl.class).isEmpty() && (wrongImuErrorMessage = this.getWrongImuErrorMessage()) != null) {
                            errorMessage = errorMessage + "\n\n" + wrongImuErrorMessage;
                        }
                    }
                    fatalErrorMessageHolder.compareAndSet(null, errorMessage);
                    return;
                }
                if (BlocksOpMode.this.forceStopped) {
                    AppUtil.getInstance().showAlertDialog(UILocation.BOTH, "OpMode Force-Stopped", "User OpMode was stuck in stop(), but was able to be force stopped without restarting the app. Please make sure you are calling opModeInInit() or opModeIsActive() in any loops!");
                    return;
                }
                if (currentBlockLabel != null && !currentBlockLabel.isEmpty()) {
                    fatalErrorMessageHolder.compareAndSet(null, "Fatal error occurred while executing the block labeled \"" + currentBlockLabel + "\". " + message);
                } else if (BlocksOpMode.this.currentBlockFinished) {
                    fatalErrorMessageHolder.compareAndSet(null, "Fatal error occurred after executing the block labeled \"" + BlocksOpMode.this.getFullBlockLabel() + "\". " + message);
                } else {
                    fatalErrorMessageHolder.compareAndSet(null, "Fatal error occurred while executing the block labeled \"" + BlocksOpMode.this.getFullBlockLabel() + "\". " + message);
                }
            }
            RobotLog.e((String)(BlocksOpMode.this.getLogPrefix() + "caughtException - message is " + message));
        }

        private String getWrongImuErrorMessage() {
            LynxModuleImuType controlHubImuType;
            LynxModule controlHub = (LynxModule)EmbeddedControlHubModule.get();
            if (controlHub != null && (controlHubImuType = controlHub.getImuType()) == LynxModuleImuType.BHI260) {
                return "You attempted to use a BNO055 IMU on a Control Hub that contains a BHI260AP IMU. You need to update your OpMode to use the IMU blocks instead of the IMU-BNO055 blocks.";
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JavascriptInterface
        public void scriptFinished() {
            RobotLog.i((String)(BlocksOpMode.this.getLogPrefix() + "scriptFinished"));
            Object object = this.scriptFinishedLock;
            synchronized (object) {
                this.scriptFinished.set(true);
                this.scriptFinishedLock.notifyAll();
            }
        }
    }
}

