/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.robotcore.hardware.CRServo;
import com.qualcomm.robotcore.hardware.CRServoImplEx;
import com.qualcomm.robotcore.hardware.DcMotorSimple;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.PwmControl;

class CRServoAccess
extends HardwareAccess<CRServoImplEx> {
    private final CRServoImplEx crServo;

    CRServoAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, CRServoImplEx.class);
        this.crServo = (CRServoImplEx)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={CRServo.class}, methodName={"setDirection"})
    public void setDirection(String directionString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Direction");
            DcMotorSimple.Direction direction = this.checkArg(directionString, DcMotorSimple.Direction.class, "");
            if (direction != null) {
                this.crServo.setDirection(direction);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CRServo.class}, methodName={"getDirection"})
    public String getDirection() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Direction");
            DcMotorSimple.Direction direction = this.crServo.getDirection();
            if (direction != null) {
                String string = direction.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CRServo.class}, methodName={"setPower"})
    public void setPower(double power) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Power");
            this.crServo.setPower(power);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CRServo.class}, methodName={"getPower"})
    public double getPower() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Power");
            double d = this.crServo.getPower();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PwmControl.class}, methodName={"setPwmEnable"})
    public void setPwmEnable() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setPwmEnable");
            this.crServo.setPwmEnable();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PwmControl.class}, methodName={"setPwmDisable"})
    public void setPwmDisable() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setPwmDisable");
            this.crServo.setPwmDisable();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={PwmControl.class}, methodName={"isPwmEnabled"})
    public boolean isPwmEnabled() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isPwmEnabled");
            boolean bl = this.crServo.isPwmEnabled();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

