/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.JavaUtil;

class ColorAccess
extends Access {
    private final Activity activity;

    ColorAccess(BlocksOpMode blocksOpMode, String identifier, Activity activity) {
        super(blocksOpMode, identifier, "Color");
        this.activity = activity;
    }

    @JavascriptInterface
    public double getRed(int color) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Red");
            double d = Color.red((int)color);
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double getGreen(int color) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Green");
            double d = Color.green((int)color);
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double getBlue(int color) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Blue");
            double d = Color.blue((int)color);
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public double getAlpha(int color) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Alpha");
            double d = Color.alpha((int)color);
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public float getHue(int color) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Hue");
            float f = JavaUtil.colorToHue((int)color);
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public float getSaturation(int color) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Saturation");
            float f = JavaUtil.colorToSaturation((int)color);
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public float getValue(int color) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Value");
            float f = JavaUtil.colorToValue((int)color);
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public int rgbToColor(int red, int green, int blue) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rgbToColor");
            int n = Color.rgb((int)red, (int)green, (int)blue);
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public int argbToColor(int alpha, int red, int green, int blue) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".argbToColor");
            int n = Color.argb((int)alpha, (int)red, (int)green, (int)blue);
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public int hsvToColor(float hue, float saturation, float value) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".hsvToColor");
            float[] array = new float[]{hue, saturation, value};
            int n = Color.HSVToColor((float[])array);
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public int ahsvToColor(int alpha, float hue, float saturation, float value) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".ahsvToColor");
            float[] array = new float[]{hue, saturation, value};
            int n = Color.HSVToColor((int)alpha, (float[])array);
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public int textToColor(String text) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".textToColor");
            int n = Color.parseColor((String)text);
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public float rgbToHue(int red, int green, int blue) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rgbToHue");
            float f = JavaUtil.rgbToHue((int)red, (int)green, (int)blue);
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public float rgbToSaturation(int red, int green, int blue) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rgbToSaturation");
            float f = JavaUtil.rgbToSaturation((int)red, (int)green, (int)blue);
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public float rgbToValue(int red, int green, int blue) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rgbToValue");
            float f = JavaUtil.rgbToValue((int)red, (int)green, (int)blue);
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public String toText(int color) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            String string = JavaUtil.colorToText((int)color);
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    public void showColor(int color) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".showColor");
            JavaUtil.showColor((Context)this.activity, (int)color);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

