/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SortOrder;
import java.util.List;
import org.firstinspires.ftc.vision.opencv.ColorBlobLocatorProcessor;
import org.firstinspires.ftc.vision.opencv.ColorRange;
import org.firstinspires.ftc.vision.opencv.ImageRegion;
import org.opencv.core.Point;
import org.opencv.core.RotatedRect;

class ColorBlobLocatorAccess
extends Access {
    ColorBlobLocatorAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "");
    }

    private ColorBlobLocatorProcessor.Builder checkColorBlobLocatorProcessorBuilder(Object colorBlobLocatorProcessorBuilderArg) {
        return this.checkArg(colorBlobLocatorProcessorBuilderArg, ColorBlobLocatorProcessor.Builder.class, "colorBlobLocatorProcessorBuilder");
    }

    private ColorRange checkColorRange(Object colorRangeArg) {
        return this.checkArg(colorRangeArg, ColorRange.class, "colorRange");
    }

    private ColorBlobLocatorProcessor.ContourMode checkContourMode(String contourModeString) {
        return this.checkArg(contourModeString, ColorBlobLocatorProcessor.ContourMode.class, "contourMode");
    }

    private ColorBlobLocatorProcessor checkColorBlobLocatorProcessor(Object colorBlobLocatorProcessorArg) {
        return this.checkArg(colorBlobLocatorProcessorArg, ColorBlobLocatorProcessor.class, "colorBlobLocatorProcessor");
    }

    private ColorBlobLocatorProcessor.BlobCriteria checkBlobCriteria(String criteriaString) {
        return this.checkArg(criteriaString, ColorBlobLocatorProcessor.BlobCriteria.class, "criteria");
    }

    private ColorBlobLocatorProcessor.BlobFilter checkBlobFilter(Object filterArg) {
        return this.checkArg(filterArg, ColorBlobLocatorProcessor.BlobFilter.class, "filter");
    }

    private ColorBlobLocatorProcessor.BlobSort checkBlobSort(Object sortArg) {
        return this.checkArg(sortArg, ColorBlobLocatorProcessor.BlobSort.class, "sort");
    }

    private SortOrder checkSortOrder(String sortOrderString) {
        return this.checkArg(sortOrderString, SortOrder.class, "sortOrder");
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, constructor=true)
    public ColorBlobLocatorProcessor.Builder createColorBlobLocatorProcessorBuilder() {
        try {
            this.startBlockExecution(BlockType.CREATE, "ColorBlobLocatorProcessor.Builder", "");
            ColorBlobLocatorProcessor.Builder builder = new ColorBlobLocatorProcessor.Builder();
            return builder;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, methodName={"setDrawContours"})
    public void setDrawContours(Object colorBlobLocatorProcessorBuilderArg, boolean drawContours) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor.Builder", ".setDrawContours");
            ColorBlobLocatorProcessor.Builder colorBlobLocatorProcessorBuilder = this.checkColorBlobLocatorProcessorBuilder(colorBlobLocatorProcessorBuilderArg);
            if (colorBlobLocatorProcessorBuilder != null) {
                colorBlobLocatorProcessorBuilder.setDrawContours(drawContours);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, methodName={"setBoxFitColor"})
    public void setBoxFitColor(Object colorBlobLocatorProcessorBuilderArg, int color) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor.Builder", ".setBoxFitColor");
            ColorBlobLocatorProcessor.Builder colorBlobLocatorProcessorBuilder = this.checkColorBlobLocatorProcessorBuilder(colorBlobLocatorProcessorBuilderArg);
            if (colorBlobLocatorProcessorBuilder != null) {
                colorBlobLocatorProcessorBuilder.setBoxFitColor(color);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, methodName={"setRoiColor"})
    public void setRoiColor(Object colorBlobLocatorProcessorBuilderArg, int color) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor.Builder", ".setRoiColor");
            ColorBlobLocatorProcessor.Builder colorBlobLocatorProcessorBuilder = this.checkColorBlobLocatorProcessorBuilder(colorBlobLocatorProcessorBuilderArg);
            if (colorBlobLocatorProcessorBuilder != null) {
                colorBlobLocatorProcessorBuilder.setRoiColor(color);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, methodName={"setContourColor"})
    public void setContourColor(Object colorBlobLocatorProcessorBuilderArg, int color) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor.Builder", ".setContourColor");
            ColorBlobLocatorProcessor.Builder colorBlobLocatorProcessorBuilder = this.checkColorBlobLocatorProcessorBuilder(colorBlobLocatorProcessorBuilderArg);
            if (colorBlobLocatorProcessorBuilder != null) {
                colorBlobLocatorProcessorBuilder.setContourColor(color);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, methodName={"setTargetColorRange"})
    public void setTargetColorRange(Object colorBlobLocatorProcessorBuilderArg, Object colorRangeArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor.Builder", ".setTargetColorRange");
            ColorBlobLocatorProcessor.Builder colorBlobLocatorProcessorBuilder = this.checkColorBlobLocatorProcessorBuilder(colorBlobLocatorProcessorBuilderArg);
            ColorRange colorRange = this.checkColorRange(colorRangeArg);
            if (colorBlobLocatorProcessorBuilder != null && colorRange != null) {
                colorBlobLocatorProcessorBuilder.setTargetColorRange(colorRange);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, methodName={"setContourMode"})
    public void setContourMode(Object colorBlobLocatorProcessorBuilderArg, String contourModeString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor.Builder", ".setContourMode");
            ColorBlobLocatorProcessor.Builder colorBlobLocatorProcessorBuilder = this.checkColorBlobLocatorProcessorBuilder(colorBlobLocatorProcessorBuilderArg);
            ColorBlobLocatorProcessor.ContourMode contourMode = this.checkContourMode(contourModeString);
            if (colorBlobLocatorProcessorBuilder != null && contourMode != null) {
                colorBlobLocatorProcessorBuilder.setContourMode(contourMode);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, methodName={"setRoi"})
    public void setRoi(Object colorBlobLocatorProcessorBuilderArg, Object imageRegionArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor.Builder", ".setRoi");
            ColorBlobLocatorProcessor.Builder colorBlobLocatorProcessorBuilder = this.checkColorBlobLocatorProcessorBuilder(colorBlobLocatorProcessorBuilderArg);
            ImageRegion imageRegion = this.checkImageRegion(imageRegionArg);
            if (colorBlobLocatorProcessorBuilder != null && imageRegion != null) {
                colorBlobLocatorProcessorBuilder.setRoi(imageRegion);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, methodName={"setBlurSize"})
    public void setBlurSize(Object colorBlobLocatorProcessorBuilderArg, int blurSize) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor.Builder", ".setBlurSize");
            ColorBlobLocatorProcessor.Builder colorBlobLocatorProcessorBuilder = this.checkColorBlobLocatorProcessorBuilder(colorBlobLocatorProcessorBuilderArg);
            if (colorBlobLocatorProcessorBuilder != null) {
                colorBlobLocatorProcessorBuilder.setBlurSize(blurSize);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, methodName={"setErodeSize"})
    public void setErodeSize(Object colorBlobLocatorProcessorBuilderArg, int erodeSize) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor.Builder", ".setErodeSize");
            ColorBlobLocatorProcessor.Builder colorBlobLocatorProcessorBuilder = this.checkColorBlobLocatorProcessorBuilder(colorBlobLocatorProcessorBuilderArg);
            if (colorBlobLocatorProcessorBuilder != null) {
                colorBlobLocatorProcessorBuilder.setErodeSize(erodeSize);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, methodName={"setDilateSize"})
    public void setDilateSize(Object colorBlobLocatorProcessorBuilderArg, int dilateSize) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor.Builder", ".setDilateSize");
            ColorBlobLocatorProcessor.Builder colorBlobLocatorProcessorBuilder = this.checkColorBlobLocatorProcessorBuilder(colorBlobLocatorProcessorBuilderArg);
            if (colorBlobLocatorProcessorBuilder != null) {
                colorBlobLocatorProcessorBuilder.setDilateSize(dilateSize);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.Builder.class}, methodName={"build"})
    public ColorBlobLocatorProcessor buildColorBlobLocatorProcessor(Object colorBlobLocatorProcessorBuilderArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor.Builder", ".build");
            ColorBlobLocatorProcessor.Builder colorBlobLocatorProcessorBuilder = this.checkColorBlobLocatorProcessorBuilder(colorBlobLocatorProcessorBuilderArg);
            if (colorBlobLocatorProcessorBuilder != null) {
                ColorBlobLocatorProcessor colorBlobLocatorProcessor = colorBlobLocatorProcessorBuilder.build();
                return colorBlobLocatorProcessor;
            }
            ColorBlobLocatorProcessor colorBlobLocatorProcessor = null;
            return colorBlobLocatorProcessor;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.BlobFilter.class}, constructor=true)
    public ColorBlobLocatorProcessor.BlobFilter createColorBlobLocatorProcessorBlobFilter(String criteriaString, double minValue, double maxValue) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            ColorBlobLocatorProcessor.BlobCriteria criteria = this.checkBlobCriteria(criteriaString);
            if (criteria != null) {
                ColorBlobLocatorProcessor.BlobFilter blobFilter = new ColorBlobLocatorProcessor.BlobFilter(criteria, minValue, maxValue);
                return blobFilter;
            }
            ColorBlobLocatorProcessor.BlobFilter blobFilter = null;
            return blobFilter;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.class}, methodName={"addFilter"})
    public void addFilter(Object colorBlobLocatorProcessorArg, Object filterArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor", ".addFilter");
            ColorBlobLocatorProcessor colorBlobLocatorProcessor = this.checkColorBlobLocatorProcessor(colorBlobLocatorProcessorArg);
            ColorBlobLocatorProcessor.BlobFilter filter = this.checkBlobFilter(filterArg);
            if (colorBlobLocatorProcessor != null && filter != null) {
                colorBlobLocatorProcessor.addFilter(filter);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.class}, methodName={"removeFilter"})
    public void removeFilter(Object colorBlobLocatorProcessorArg, Object filterArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor", ".removeFilter");
            ColorBlobLocatorProcessor colorBlobLocatorProcessor = this.checkColorBlobLocatorProcessor(colorBlobLocatorProcessorArg);
            ColorBlobLocatorProcessor.BlobFilter filter = this.checkBlobFilter(filterArg);
            if (colorBlobLocatorProcessor != null && filter != null) {
                colorBlobLocatorProcessor.removeFilter(filter);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.class}, methodName={"removeAllFilters"})
    public void removeAllFilters(Object colorBlobLocatorProcessorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor", ".removeAllFilters");
            ColorBlobLocatorProcessor colorBlobLocatorProcessor = this.checkColorBlobLocatorProcessor(colorBlobLocatorProcessorArg);
            if (colorBlobLocatorProcessor != null) {
                colorBlobLocatorProcessor.removeAllFilters();
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.BlobSort.class}, constructor=true)
    public ColorBlobLocatorProcessor.BlobSort createColorBlobLocatorProcessorBlobSort(String criteriaString, String sortOrderString) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            ColorBlobLocatorProcessor.BlobCriteria criteria = this.checkBlobCriteria(criteriaString);
            SortOrder sortOrder = this.checkSortOrder(sortOrderString);
            if (criteria != null && sortOrder != null) {
                ColorBlobLocatorProcessor.BlobSort blobSort = new ColorBlobLocatorProcessor.BlobSort(criteria, sortOrder);
                return blobSort;
            }
            ColorBlobLocatorProcessor.BlobSort blobSort = null;
            return blobSort;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.class}, methodName={"setSort"})
    public void setSort(Object colorBlobLocatorProcessorArg, Object sortArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor", ".setSort");
            ColorBlobLocatorProcessor colorBlobLocatorProcessor = this.checkColorBlobLocatorProcessor(colorBlobLocatorProcessorArg);
            ColorBlobLocatorProcessor.BlobSort sort = this.checkBlobSort(sortArg);
            if (colorBlobLocatorProcessor != null && sort != null) {
                colorBlobLocatorProcessor.setSort(sort);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorBlobLocatorProcessor.class}, methodName={"getBlobs"})
    public String getBlobs(Object colorBlobLocatorProcessorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "ColorBlobLocatorProcessor", ".getBlobs");
            ColorBlobLocatorProcessor colorBlobLocatorProcessor = this.checkColorBlobLocatorProcessor(colorBlobLocatorProcessorArg);
            if (colorBlobLocatorProcessor != null) {
                String string = ColorBlobLocatorAccess.blobsToJson(colorBlobLocatorProcessor.getBlobs());
                return string;
            }
            String string = null;
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    private static String blobsToJson(List<ColorBlobLocatorProcessor.Blob> blobs) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        String delimiter = "";
        for (ColorBlobLocatorProcessor.Blob blob : blobs) {
            double density = 0.0;
            try {
                density = blob.getDensity();
            }
            catch (Exception exception) {
                // empty catch block
            }
            double aspectRatio = 0.0;
            try {
                aspectRatio = blob.getAspectRatio();
            }
            catch (Exception exception) {
                // empty catch block
            }
            json.append(delimiter).append("{").append("\"ContourPoints\":").append(ColorBlobLocatorAccess.toJson(blob.getContourPoints())).append(",").append("\"ContourArea\":").append(blob.getContourArea()).append(",").append("\"Density\":").append(ColorBlobLocatorAccess.fixDouble(density)).append(",").append("\"AspectRatio\":").append(ColorBlobLocatorAccess.fixDouble(aspectRatio)).append(",").append("\"BoxFit\":").append(ColorBlobLocatorAccess.rotatedRectToJson(blob.getBoxFit())).append("}");
            delimiter = ",";
        }
        json.append("]");
        return json.toString();
    }

    private static String rotatedRectToJson(RotatedRect rotatedRect) {
        String originalJson = ColorBlobLocatorAccess.toJson(rotatedRect);
        if (!originalJson.endsWith("}")) {
            RobotLog.ww((String)"ColorBlobLocatorAccess", (String)"Unexpected: result from toJson(RotatedRect) does not end with '}'!");
            return originalJson;
        }
        Point[] points = new Point[4];
        rotatedRect.points(points);
        String json = originalJson.substring(0, originalJson.length() - 1) + "," + "\"boundingRect\":" + ColorBlobLocatorAccess.toJson(rotatedRect.boundingRect()) + "," + "\"points\":" + ColorBlobLocatorAccess.toJson(points) + "}";
        return json;
    }

    private static double fixDouble(double v) {
        if (Double.isFinite(v)) {
            return v;
        }
        return 0.0;
    }
}

