/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.lynx.LynxI2cColorRangeSensor;
import com.qualcomm.hardware.rev.RevColorSensorV3;
import com.qualcomm.robotcore.hardware.ColorRangeSensor;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.NormalizedRGBA;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

class ColorRangeSensorAccess
extends HardwareAccess<ColorRangeSensor> {
    private final ColorRangeSensor colorRangeSensor;

    ColorRangeSensorAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, ColorRangeSensor.class);
        this.colorRangeSensor = (ColorRangeSensor)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"red"})
    public int getRed() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Red");
            int n = this.colorRangeSensor.red();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"green"})
    public int getGreen() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Green");
            int n = this.colorRangeSensor.green();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"blue"})
    public int getBlue() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Blue");
            int n = this.colorRangeSensor.blue();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"alpha"})
    public int getAlpha() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Alpha");
            int n = this.colorRangeSensor.alpha();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"argb"})
    public int getArgb() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Argb");
            int n = this.colorRangeSensor.argb();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"setI2cAddress"})
    public void setI2cAddress7Bit(int i2cAddr7Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress7Bit");
            this.colorRangeSensor.setI2cAddress(I2cAddr.create7bit((int)i2cAddr7Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"getI2cAddress"})
    public int getI2cAddress7Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress7Bit");
            I2cAddr i2cAddr = this.colorRangeSensor.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get7Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"setI2cAddress"})
    public void setI2cAddress8Bit(int i2cAddr8Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress8Bit");
            this.colorRangeSensor.setI2cAddress(I2cAddr.create8bit((int)i2cAddr8Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"getI2cAddress"})
    public int getI2cAddress8Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress8Bit");
            I2cAddr i2cAddr = this.colorRangeSensor.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get8Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"getLightDetected"})
    public double getLightDetected() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LightDetected");
            double d = this.colorRangeSensor.getLightDetected();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"getRawLightDetected"})
    public double getRawLightDetected() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RawLightDetected");
            double d = this.colorRangeSensor.getRawLightDetected();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"getRawLightDetectedMax"})
    public double getRawLightDetectedMax() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RawLightDetectedMax");
            double d = this.colorRangeSensor.getRawLightDetectedMax();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"getDistance"})
    public double getDistance(String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getDistance");
            DistanceUnit distanceUnit = this.checkArg(distanceUnitString, DistanceUnit.class, "unit");
            if (distanceUnit != null) {
                double d = this.colorRangeSensor.getDistance(distanceUnit);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"getNormalizedColors"})
    public String getNormalizedColors() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getNormalizedColors");
            NormalizedRGBA color = this.colorRangeSensor.getNormalizedColors();
            String string = "{ \"Red\":" + color.red + ", \"Green\":" + color.green + ", \"Blue\":" + color.blue + ", \"Alpha\":" + color.alpha + ", \"Color\":" + color.toColor() + " }";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"setGain"})
    public void setGain(float gain) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Gain");
            this.colorRangeSensor.setGain(gain);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ColorRangeSensor.class, LynxI2cColorRangeSensor.class, RevColorSensorV3.class}, methodName={"getGain"})
    public float getGain() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Gain");
            float f = this.colorRangeSensor.getGain();
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

