/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.adafruit.AdafruitI2cColorSensor;
import com.qualcomm.hardware.modernrobotics.ModernRoboticsI2cColorSensor;
import com.qualcomm.robotcore.hardware.ColorSensor;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.Light;
import com.qualcomm.robotcore.hardware.NormalizedColorSensor;
import com.qualcomm.robotcore.hardware.NormalizedRGBA;
import com.qualcomm.robotcore.hardware.SwitchableLight;

class ColorSensorAccess
extends HardwareAccess<ColorSensor> {
    private final ColorSensor colorSensor;

    ColorSensorAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, ColorSensor.class);
        this.colorSensor = (ColorSensor)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ColorSensor.class, ModernRoboticsI2cColorSensor.class}, methodName={"red"})
    public int getRed() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Red");
            int n = this.colorSensor.red();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ColorSensor.class, ModernRoboticsI2cColorSensor.class}, methodName={"green"})
    public int getGreen() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Green");
            int n = this.colorSensor.green();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ColorSensor.class, ModernRoboticsI2cColorSensor.class}, methodName={"blue"})
    public int getBlue() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Blue");
            int n = this.colorSensor.blue();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ColorSensor.class, ModernRoboticsI2cColorSensor.class}, methodName={"alpha"})
    public int getAlpha() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Alpha");
            int n = this.colorSensor.alpha();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ColorSensor.class, ModernRoboticsI2cColorSensor.class}, methodName={"argb"})
    public int getArgb() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Argb");
            int n = this.colorSensor.argb();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ColorSensor.class, ModernRoboticsI2cColorSensor.class}, methodName={"enableLed"})
    public void enableLed(boolean enable) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".enableLed");
            this.colorSensor.enableLed(enable);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cColorSensor.class}, methodName={"enableLight"})
    public void enableLight(boolean enable) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".enableLight");
            if (this.colorSensor instanceof SwitchableLight) {
                ((SwitchableLight)this.colorSensor).enableLight(enable);
            } else {
                this.reportWarning("This ColorSensor is not a SwitchableLight.");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, Light.class, ModernRoboticsI2cColorSensor.class}, methodName={"isLightOn"})
    public boolean isLightOn() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isLightOn");
            if (this.colorSensor instanceof Light) {
                boolean bl = ((Light)this.colorSensor).isLightOn();
                return bl;
            }
            this.reportWarning("This ColorSensor is not a Light.");
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ColorSensor.class, ModernRoboticsI2cColorSensor.class}, methodName={"setI2cAddress"})
    public void setI2cAddress7Bit(int i2cAddr7Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress7Bit");
            this.colorSensor.setI2cAddress(I2cAddr.create7bit((int)i2cAddr7Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ColorSensor.class, ModernRoboticsI2cColorSensor.class}, methodName={"getI2cAddress"})
    public int getI2cAddress7Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress7Bit");
            I2cAddr i2cAddr = this.colorSensor.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get7Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ColorSensor.class, ModernRoboticsI2cColorSensor.class}, methodName={"setI2cAddress"})
    public void setI2cAddress8Bit(int i2cAddr8Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress8Bit");
            this.colorSensor.setI2cAddress(I2cAddr.create8bit((int)i2cAddr8Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ColorSensor.class, ModernRoboticsI2cColorSensor.class}, methodName={"getI2cAddress"})
    public int getI2cAddress8Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress8Bit");
            I2cAddr i2cAddr = this.colorSensor.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get8Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ModernRoboticsI2cColorSensor.class}, methodName={"toString"})
    public String toText() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            String string = this.colorSensor.toString();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ModernRoboticsI2cColorSensor.class, NormalizedColorSensor.class}, methodName={"getNormalizedColors"})
    public String getNormalizedColors() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getNormalizedColors");
            if (this.colorSensor instanceof NormalizedColorSensor) {
                NormalizedRGBA color = ((NormalizedColorSensor)this.colorSensor).getNormalizedColors();
                String string = "{ \"Red\":" + color.red + ", \"Green\":" + color.green + ", \"Blue\":" + color.blue + ", \"Alpha\":" + color.alpha + ", \"Color\":" + color.toColor() + " }";
                return string;
            }
            String color = "{ \"Red\":0, \"Green\":0, \"Blue\":0, \"Alpha\":0, \"Color\":0 }";
            return color;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ModernRoboticsI2cColorSensor.class, NormalizedColorSensor.class}, methodName={"setGain"})
    public void setGain(float gain) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Gain");
            if (this.colorSensor instanceof NormalizedColorSensor) {
                ((NormalizedColorSensor)this.colorSensor).setGain(gain);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={AdafruitI2cColorSensor.class, ModernRoboticsI2cColorSensor.class, NormalizedColorSensor.class}, methodName={"getGain"})
    public float getGain() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Gain");
            if (this.colorSensor instanceof NormalizedColorSensor) {
                float f = ((NormalizedColorSensor)this.colorSensor).getGain();
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

