/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.robotcore.hardware.CompassSensor;
import com.qualcomm.robotcore.hardware.HardwareMap;

class CompassSensorAccess
extends HardwareAccess<CompassSensor> {
    private final CompassSensor compassSensor;

    CompassSensorAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, CompassSensor.class);
        this.compassSensor = (CompassSensor)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={CompassSensor.class}, methodName={"getDirection"})
    public double getDirection() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Direction");
            double d = this.compassSensor.getDirection();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CompassSensor.class}, methodName={"calibrationFailed"})
    public boolean getCalibrationFailed() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".CalibrationFailed");
            boolean bl = this.compassSensor.calibrationFailed();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={CompassSensor.class}, methodName={"setMode"})
    public void setMode(String compassModeString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".Mode");
            CompassSensor.CompassMode compassMode = this.checkArg(compassModeString, CompassSensor.CompassMode.class, "compassMode");
            if (compassMode != null) {
                this.compassSensor.setMode(compassMode);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

