/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.DcMotorEx;
import com.qualcomm.robotcore.hardware.DcMotorSimple;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.PIDFCoefficients;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.CurrentUnit;

class DcMotorAccess
extends HardwareAccess<DcMotor> {
    private final DcMotor dcMotor;

    DcMotorAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, DcMotor.class);
        this.dcMotor = (DcMotor)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"setDirection"})
    public void setDirection(String directionString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Direction");
            DcMotorSimple.Direction direction = this.checkArg(directionString, DcMotorSimple.Direction.class, "");
            if (direction != null) {
                this.dcMotor.setDirection(direction);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"getDirection"})
    public String getDirection() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Direction");
            DcMotorSimple.Direction direction = this.dcMotor.getDirection();
            if (direction != null) {
                String string = direction.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"setPower"})
    public void setPower(double power) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Power");
            this.dcMotor.setPower(power);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"getPower"})
    public double getPower() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Power");
            double d = this.dcMotor.getPower();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Deprecated
    public void setMaxSpeed(double maxSpeed) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".MaxSpeed");
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Deprecated
    public int getMaxSpeed() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".MaxSpeed");
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"setZeroPowerBehavior"})
    public void setZeroPowerBehavior(String zeroPowerBehaviorString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".ZeroPowerBehavior");
            DcMotor.ZeroPowerBehavior zeroPowerBehavior = this.checkArg(zeroPowerBehaviorString, DcMotor.ZeroPowerBehavior.class, "");
            if (zeroPowerBehavior != null) {
                this.dcMotor.setZeroPowerBehavior(zeroPowerBehavior);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"getZeroPowerBehavior"})
    public String getZeroPowerBehavior() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".ZeroPowerBehavior");
            DcMotor.ZeroPowerBehavior zeroPowerBehavior = this.dcMotor.getZeroPowerBehavior();
            if (zeroPowerBehavior != null) {
                String string = zeroPowerBehavior.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"getPowerFloat"})
    public boolean getPowerFloat() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".PowerFloat");
            boolean bl = this.dcMotor.getPowerFloat();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"setTargetPosition"})
    public void setTargetPosition(double position) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".TargetPosition");
            this.dcMotor.setTargetPosition((int)position);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"getTargetPosition"})
    public int getTargetPosition() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".TargetPosition");
            int n = this.dcMotor.getTargetPosition();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"isBusy"})
    public boolean isBusy() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isBusy");
            boolean bl = this.dcMotor.isBusy();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"getCurrentPosition"})
    public int getCurrentPosition() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".CurrentPosition");
            int n = this.dcMotor.getCurrentPosition();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"setMode"})
    public void setMode(String runModeString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Mode");
            DcMotor.RunMode runMode = this.checkArg(runModeString, DcMotor.RunMode.class, "");
            if (runMode != null) {
                this.dcMotor.setMode(runMode);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"getMode"})
    public String getMode() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Mode");
            DcMotor.RunMode runMode = this.dcMotor.getMode();
            if (runMode != null) {
                String string = runMode.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Deprecated
    public void setDualMaxSpeed(double maxSpeed1, Object otherArg, double maxSpeed2) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".MaxSpeed");
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"setMode"})
    public void setDualMode(String runMode1String, Object otherArg, String runMode2String) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Mode");
            DcMotor.RunMode runMode1 = this.checkArg(runMode1String, DcMotor.RunMode.class, "first");
            DcMotor.RunMode runMode2 = this.checkArg(runMode2String, DcMotor.RunMode.class, "second");
            if (runMode1 != null && runMode2 != null && otherArg instanceof DcMotorAccess) {
                DcMotorAccess other = (DcMotorAccess)otherArg;
                this.dcMotor.setMode(runMode1);
                other.dcMotor.setMode(runMode2);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"setPower"})
    public void setDualPower(double power1, Object otherArg, double power2) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Power");
            if (otherArg instanceof DcMotorAccess) {
                DcMotorAccess other = (DcMotorAccess)otherArg;
                this.dcMotor.setPower(power1);
                other.dcMotor.setPower(power2);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"setTargetPosition"})
    public void setDualTargetPosition(double position1, Object otherArg, double position2) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".TargetPosition");
            if (otherArg instanceof DcMotorAccess) {
                DcMotorAccess other = (DcMotorAccess)otherArg;
                this.dcMotor.setTargetPosition((int)position1);
                other.dcMotor.setTargetPosition((int)position2);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"setTargetPositionTolerance"})
    public void setDualTargetPositionTolerance(double tolerance1, Object otherArg, double tolerance2) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".TargetPositionTolerance");
            if (otherArg instanceof DcMotorAccess) {
                DcMotorAccess other = (DcMotorAccess)otherArg;
                if (this.dcMotor instanceof DcMotorEx) {
                    ((DcMotorEx)this.dcMotor).setTargetPositionTolerance((int)tolerance1);
                }
                if (other.dcMotor instanceof DcMotorEx) {
                    ((DcMotorEx)other.dcMotor).setTargetPositionTolerance((int)tolerance2);
                }
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"setVelocity"})
    public void setDualVelocity(double velocity1, Object otherArg, double velocity2) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Velocity");
            if (otherArg instanceof DcMotorAccess) {
                DcMotorAccess other = (DcMotorAccess)otherArg;
                if (this.dcMotor instanceof DcMotorEx) {
                    ((DcMotorEx)this.dcMotor).setVelocity(velocity1);
                }
                if (other.dcMotor instanceof DcMotorEx) {
                    ((DcMotorEx)other.dcMotor).setVelocity(velocity2);
                }
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotor.class, DcMotorEx.class}, methodName={"setZeroPowerBehavior"})
    public void setDualZeroPowerBehavior(String zeroPowerBehavior1String, Object otherArg, String zeroPowerBehavior2String) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".ZeroPowerBehavior");
            DcMotor.ZeroPowerBehavior zeroPowerBehavior1 = this.checkArg(zeroPowerBehavior1String, DcMotor.ZeroPowerBehavior.class, "first");
            DcMotor.ZeroPowerBehavior zeroPowerBehavior2 = this.checkArg(zeroPowerBehavior2String, DcMotor.ZeroPowerBehavior.class, "second");
            if (zeroPowerBehavior1 != null && zeroPowerBehavior2 != null && otherArg instanceof DcMotorAccess) {
                DcMotorAccess other = (DcMotorAccess)otherArg;
                this.dcMotor.setZeroPowerBehavior(zeroPowerBehavior1);
                other.dcMotor.setZeroPowerBehavior(zeroPowerBehavior2);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"setMotorEnable"})
    public void setMotorEnable() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setMotorEnable");
            if (this.dcMotor instanceof DcMotorEx) {
                ((DcMotorEx)this.dcMotor).setMotorEnable();
            } else {
                this.reportWarning("This DcMotor is not a DcMotorEx.");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"setMotorDisable"})
    public void setMotorDisable() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setMotorDisable");
            if (this.dcMotor instanceof DcMotorEx) {
                ((DcMotorEx)this.dcMotor).setMotorDisable();
            } else {
                this.reportWarning("This DcMotor is not a DcMotorEx.");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"isMotorEnabled"})
    public boolean isMotorEnabled() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isMotorEnabled");
            if (this.dcMotor instanceof DcMotorEx) {
                boolean bl = ((DcMotorEx)this.dcMotor).isMotorEnabled();
                return bl;
            }
            this.reportWarning("This DcMotor is not a DcMotorEx.");
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"setVelocity"})
    public void setVelocity(double angularRate) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setVelocity");
            if (this.dcMotor instanceof DcMotorEx) {
                ((DcMotorEx)this.dcMotor).setVelocity(angularRate);
            } else {
                this.reportWarning("This DcMotor is not a DcMotorEx.");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"setVelocity"})
    public void setVelocity_withAngleUnit(double angularRate, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setVelocity");
            AngleUnit angleUnit = this.checkArg(angleUnitString, AngleUnit.class, "");
            if (angleUnit != null) {
                if (this.dcMotor instanceof DcMotorEx) {
                    ((DcMotorEx)this.dcMotor).setVelocity(angularRate, angleUnit);
                } else {
                    this.reportWarning("This DcMotor is not a DcMotorEx.");
                }
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"getVelocity"})
    public double getVelocity() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getVelocity");
            if (this.dcMotor instanceof DcMotorEx) {
                double d = ((DcMotorEx)this.dcMotor).getVelocity();
                return d;
            }
            this.reportWarning("This DcMotor is not a DcMotorEx.");
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"getVelocity"})
    public double getVelocity_withAngleUnit(String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getVelocity");
            AngleUnit angleUnit = this.checkArg(angleUnitString, AngleUnit.class, "");
            if (angleUnit != null) {
                if (this.dcMotor instanceof DcMotorEx) {
                    double d = ((DcMotorEx)this.dcMotor).getVelocity(angleUnit);
                    return d;
                }
                this.reportWarning("This DcMotor is not a DcMotorEx.");
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"setVelocityPIDFCoefficients"})
    public void setVelocityPIDFCoefficients(double p, double i, double d, double f) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setVelocityPIDFCoefficients");
            if (this.dcMotor instanceof DcMotorEx) {
                ((DcMotorEx)this.dcMotor).setVelocityPIDFCoefficients(p, i, d, f);
            } else {
                this.reportWarning("This DcMotor is not a DcMotorEx.");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"setPositionPIDFCoefficients"})
    public void setPositionPIDFCoefficients(double p) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setPositionPIDFCoefficients");
            if (this.dcMotor instanceof DcMotorEx) {
                ((DcMotorEx)this.dcMotor).setPositionPIDFCoefficients(p);
            } else {
                this.reportWarning("This DcMotor is not a DcMotorEx.");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"setPIDFCoefficients"})
    public void setPIDFCoefficients(String runModeString, Object pidfCoefficientsArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setPIDFCoefficients");
            DcMotor.RunMode runMode = this.checkArg(runModeString, DcMotor.RunMode.class, "");
            PIDFCoefficients pidfCoefficients = this.checkArg(pidfCoefficientsArg, PIDFCoefficients.class, "");
            if (runMode != null && pidfCoefficients != null) {
                if (this.dcMotor instanceof DcMotorEx) {
                    ((DcMotorEx)this.dcMotor).setPIDFCoefficients(runMode, pidfCoefficients);
                } else {
                    this.reportWarning("This DcMotor is not a DcMotorEx.");
                }
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"getPIDFCoefficients"})
    public PIDFCoefficients getPIDFCoefficients(String runModeString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getPIDFCoefficients");
            DcMotor.RunMode runMode = this.checkArg(runModeString, DcMotor.RunMode.class, "");
            if (runMode != null) {
                if (this.dcMotor instanceof DcMotorEx) {
                    PIDFCoefficients pIDFCoefficients = ((DcMotorEx)this.dcMotor).getPIDFCoefficients(runMode);
                    return pIDFCoefficients;
                }
                this.reportWarning("This DcMotor is not a DcMotorEx.");
            }
            PIDFCoefficients pIDFCoefficients = null;
            return pIDFCoefficients;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"setTargetPositionTolerance"})
    public void setTargetPositionTolerance(int tolerance) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".TargetPositionTolerance");
            if (this.dcMotor instanceof DcMotorEx) {
                ((DcMotorEx)this.dcMotor).setTargetPositionTolerance(tolerance);
            } else {
                this.reportWarning("This DcMotor is not a DcMotorEx.");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"getTargetPositionTolerance"})
    public int getTargetPositionTolerance() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".TargetPositionTolerance");
            if (this.dcMotor instanceof DcMotorEx) {
                int n = ((DcMotorEx)this.dcMotor).getTargetPositionTolerance();
                return n;
            }
            this.reportWarning("This DcMotor is not a DcMotorEx.");
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"getCurrent"})
    public double getCurrent(String currentUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getCurrent");
            CurrentUnit currentUnit = this.checkArg(currentUnitString, CurrentUnit.class, "");
            if (currentUnit != null) {
                if (this.dcMotor instanceof DcMotorEx) {
                    double d = ((DcMotorEx)this.dcMotor).getCurrent(currentUnit);
                    return d;
                }
                this.reportWarning("This DcMotor is not a DcMotorEx.");
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"getCurrentAlert"})
    public double getCurrentAlert(String currentUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getCurrentAlert");
            CurrentUnit currentUnit = this.checkArg(currentUnitString, CurrentUnit.class, "");
            if (currentUnit != null) {
                if (this.dcMotor instanceof DcMotorEx) {
                    double d = ((DcMotorEx)this.dcMotor).getCurrentAlert(currentUnit);
                    return d;
                }
                this.reportWarning("This DcMotor is not a DcMotorEx.");
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"setCurrentAlert"})
    public void setCurrentAlert(double current, String currentUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setCurrentAlert");
            CurrentUnit currentUnit = this.checkArg(currentUnitString, CurrentUnit.class, "");
            if (currentUnit != null) {
                if (this.dcMotor instanceof DcMotorEx) {
                    ((DcMotorEx)this.dcMotor).setCurrentAlert(current, currentUnit);
                } else {
                    this.reportWarning("This DcMotor is not a DcMotorEx.");
                }
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DcMotorEx.class}, methodName={"isOverCurrent"})
    public boolean isOverCurrent() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isOverCurrent");
            if (this.dcMotor instanceof DcMotorEx) {
                boolean bl = ((DcMotorEx)this.dcMotor).isOverCurrent();
                return bl;
            }
            this.reportWarning("This DcMotor is not a DcMotorEx.");
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

