/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.robotcore.hardware.DigitalChannel;
import com.qualcomm.robotcore.hardware.HardwareMap;

class DigitalChannelAccess
extends HardwareAccess<DigitalChannel> {
    private final DigitalChannel digitalChannel;

    DigitalChannelAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, DigitalChannel.class);
        this.digitalChannel = (DigitalChannel)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={DigitalChannel.class}, methodName={"setMode"})
    public void setMode(String modeString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Mode");
            DigitalChannel.Mode mode = this.checkArg(modeString, DigitalChannel.Mode.class, "");
            if (mode != null) {
                this.digitalChannel.setMode(mode);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DigitalChannel.class}, methodName={"getMode"})
    public String getMode() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Mode");
            DigitalChannel.Mode mode = this.digitalChannel.getMode();
            if (mode != null) {
                String string = mode.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DigitalChannel.class}, methodName={"setState"})
    public void setState(boolean state) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".State");
            this.digitalChannel.setState(state);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={DigitalChannel.class}, methodName={"getState"})
    public boolean getState() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".State");
            boolean bl = this.digitalChannel.getState();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

