/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.robotcore.hardware.DistanceSensor;
import com.qualcomm.robotcore.hardware.HardwareMap;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

class DistanceSensorAccess
extends HardwareAccess<DistanceSensor> {
    private final DistanceSensor distanceSensor;

    DistanceSensorAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, DistanceSensor.class);
        this.distanceSensor = (DistanceSensor)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={DistanceSensor.class}, methodName={"getDistance"})
    public double getDistance(String distanceUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getDistance");
            DistanceUnit distanceUnit = this.checkDistanceUnit(distanceUnitString);
            if (distanceUnit != null) {
                double d = this.distanceSensor.getDistance(distanceUnit);
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

