/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.qualcomm.robotcore.util.ElapsedTime;

class ElapsedTimeAccess
extends Access {
    ElapsedTimeAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "ElapsedTime");
    }

    private ElapsedTime checkElapsedTime(Object elapsedTimeArg) {
        return this.checkArg(elapsedTimeArg, ElapsedTime.class, "timer");
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, constructor=true)
    public ElapsedTime create() {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            ElapsedTime elapsedTime = new ElapsedTime();
            return elapsedTime;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, constructor=true)
    public ElapsedTime create_withStartTime(long startTime) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            ElapsedTime elapsedTime = new ElapsedTime(startTime);
            return elapsedTime;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, constructor=true)
    public ElapsedTime create_withResolution(String resolutionString) {
        try {
            this.startBlockExecution(BlockType.CREATE, "");
            ElapsedTime.Resolution resolution = this.checkArg(resolutionString, ElapsedTime.Resolution.class, "resolution");
            if (resolution != null) {
                ElapsedTime elapsedTime = new ElapsedTime(resolution);
                return elapsedTime;
            }
            ElapsedTime elapsedTime = null;
            return elapsedTime;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, methodName={"startTime"})
    public double getStartTime(Object elapsedTimeArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".StartTime");
            ElapsedTime elapsedTime = this.checkElapsedTime(elapsedTimeArg);
            if (elapsedTime != null) {
                double d = elapsedTime.startTime();
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, methodName={"time"})
    public double getTime(Object elapsedTimeArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Time");
            ElapsedTime elapsedTime = this.checkElapsedTime(elapsedTimeArg);
            if (elapsedTime != null) {
                double d = elapsedTime.time();
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, methodName={"seconds"})
    public double getSeconds(Object elapsedTimeArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Seconds");
            ElapsedTime elapsedTime = this.checkElapsedTime(elapsedTimeArg);
            if (elapsedTime != null) {
                double d = elapsedTime.seconds();
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, methodName={"milliseconds"})
    public double getMilliseconds(Object elapsedTimeArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Milliseconds");
            ElapsedTime elapsedTime = this.checkElapsedTime(elapsedTimeArg);
            if (elapsedTime != null) {
                double d = elapsedTime.milliseconds();
                return d;
            }
            double d = 0.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, methodName={"getResolution"})
    public String getResolution(Object elapsedTimeArg) {
        try {
            ElapsedTime.Resolution resolution;
            this.startBlockExecution(BlockType.GETTER, ".Resolution");
            ElapsedTime elapsedTime = this.checkElapsedTime(elapsedTimeArg);
            if (elapsedTime != null && (resolution = elapsedTime.getResolution()) != null) {
                String string = resolution.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, methodName={"toString"})
    public String getAsText(Object elapsedTimeArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AsText");
            ElapsedTime elapsedTime = this.checkElapsedTime(elapsedTimeArg);
            if (elapsedTime != null) {
                String string = elapsedTime.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, methodName={"reset"})
    public void reset(Object elapsedTimeArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".reset");
            ElapsedTime elapsedTime = this.checkElapsedTime(elapsedTimeArg);
            if (elapsedTime != null) {
                elapsedTime.reset();
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, methodName={"log"})
    public void log(Object elapsedTimeArg, String label) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".log");
            ElapsedTime elapsedTime = this.checkElapsedTime(elapsedTimeArg);
            if (elapsedTime != null) {
                elapsedTime.log(label);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ElapsedTime.class}, methodName={"toString"})
    public String toText(Object elapsedTimeArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            ElapsedTime elapsedTime = this.checkElapsedTime(elapsedTimeArg);
            if (elapsedTime != null) {
                String string = elapsedTime.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

