/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.ExposureControl;

class ExposureControlAccess
extends Access {
    ExposureControlAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "ExposureControl");
    }

    private ExposureControl checkExposureControl(Object exposureControlArg) {
        return this.checkArg(exposureControlArg, ExposureControl.class, "exposureControl");
    }

    private ExposureControl.Mode checkMode(String modeString) {
        return this.checkArg(modeString, ExposureControl.Mode.class, "Mode");
    }

    private TimeUnit checkTimeUnit(String timeUnitString) {
        return this.checkArg(timeUnitString, TimeUnit.class, "timeUnit");
    }

    @JavascriptInterface
    @Block(classes={ExposureControl.class}, methodName={"getMode"})
    public String getMode(Object exposureControlArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getMode");
            ExposureControl exposureControl = this.checkExposureControl(exposureControlArg);
            if (exposureControl != null) {
                String string = exposureControl.getMode().toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ExposureControl.class}, methodName={"setMode"})
    public boolean setMode(Object exposureControlArg, String modeString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setMode");
            ExposureControl exposureControl = this.checkExposureControl(exposureControlArg);
            ExposureControl.Mode mode = this.checkMode(modeString);
            if (exposureControl != null && mode != null) {
                boolean bl = exposureControl.setMode(mode);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ExposureControl.class}, methodName={"isModeSupported"})
    public boolean isModeSupported(Object exposureControlArg, String modeString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isModeSupported");
            ExposureControl exposureControl = this.checkExposureControl(exposureControlArg);
            ExposureControl.Mode mode = this.checkMode(modeString);
            if (exposureControl != null && mode != null) {
                boolean bl = exposureControl.isModeSupported(mode);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ExposureControl.class}, methodName={"getMinExposure"})
    public long getMinExposure(Object exposureControlArg, String timeUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getMinExposure");
            ExposureControl exposureControl = this.checkExposureControl(exposureControlArg);
            TimeUnit timeUnit = this.checkTimeUnit(timeUnitString);
            if (exposureControl != null && timeUnit != null) {
                long l = exposureControl.getMinExposure(timeUnit);
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ExposureControl.class}, methodName={"getMaxExposure"})
    public long getMaxExposure(Object exposureControlArg, String timeUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getMaxExposure");
            ExposureControl exposureControl = this.checkExposureControl(exposureControlArg);
            TimeUnit timeUnit = this.checkTimeUnit(timeUnitString);
            if (exposureControl != null && timeUnit != null) {
                long l = exposureControl.getMaxExposure(timeUnit);
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ExposureControl.class}, methodName={"getExposure"})
    public long getExposure(Object exposureControlArg, String timeUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getExposure");
            ExposureControl exposureControl = this.checkExposureControl(exposureControlArg);
            TimeUnit timeUnit = this.checkTimeUnit(timeUnitString);
            if (exposureControl != null && timeUnit != null) {
                long l = exposureControl.getExposure(timeUnit);
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ExposureControl.class}, methodName={"setExposure"})
    public boolean setExposure(Object exposureControlArg, long duration, String timeUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setExposure");
            ExposureControl exposureControl = this.checkExposureControl(exposureControlArg);
            TimeUnit timeUnit = this.checkTimeUnit(timeUnitString);
            if (exposureControl != null && timeUnit != null) {
                boolean bl = exposureControl.setExposure(duration, timeUnit);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ExposureControl.class}, methodName={"isExposureSupported"})
    public boolean isExposureSupported(Object exposureControlArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isExposureSupported");
            ExposureControl exposureControl = this.checkExposureControl(exposureControlArg);
            if (exposureControl != null) {
                boolean bl = exposureControl.isExposureSupported();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ExposureControl.class}, methodName={"getAePriority"})
    public boolean getAePriority(Object exposureControlArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getAePriority");
            ExposureControl exposureControl = this.checkExposureControl(exposureControlArg);
            if (exposureControl != null) {
                boolean bl = exposureControl.getAePriority();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ExposureControl.class}, methodName={"setAePriority"})
    public boolean setAePriority(Object exposureControlArg, boolean priority) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setAePriority");
            ExposureControl exposureControl = this.checkExposureControl(exposureControlArg);
            if (exposureControl != null) {
                boolean bl = exposureControl.setAePriority(priority);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

