/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.FocusControl;

class FocusControlAccess
extends Access {
    FocusControlAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "FocusControl");
    }

    private FocusControl checkFocusControl(Object focusControlArg) {
        return this.checkArg(focusControlArg, FocusControl.class, "focusControl");
    }

    private FocusControl.Mode checkMode(String modeString) {
        return this.checkArg(modeString, FocusControl.Mode.class, "Mode");
    }

    @JavascriptInterface
    @Block(classes={FocusControl.class}, methodName={"getMode"})
    public String getMode(Object focusControlArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "FocusControl", ".getMode");
            FocusControl focusControl = this.checkFocusControl(focusControlArg);
            if (focusControl != null) {
                String string = focusControl.getMode().toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={FocusControl.class}, methodName={"setMode"})
    public boolean setMode(Object focusControlArg, String modeString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "FocusControl", ".setMode");
            FocusControl focusControl = this.checkFocusControl(focusControlArg);
            FocusControl.Mode mode = this.checkMode(modeString);
            if (focusControl != null && mode != null) {
                boolean bl = focusControl.setMode(mode);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={FocusControl.class}, methodName={"isModeSupported"})
    public boolean isModeSupported(Object focusControlArg, String modeString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "FocusControl", ".isModeSupported");
            FocusControl focusControl = this.checkFocusControl(focusControlArg);
            FocusControl.Mode mode = this.checkMode(modeString);
            if (focusControl != null && mode != null) {
                boolean bl = focusControl.isModeSupported(mode);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={FocusControl.class}, methodName={"getMinFocusLength"})
    public double getMinFocusLength(Object focusControlArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "FocusControl", ".getMinFocusLength");
            FocusControl focusControl = this.checkFocusControl(focusControlArg);
            if (focusControl != null) {
                double d = focusControl.getMinFocusLength();
                return d;
            }
            double d = -1.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={FocusControl.class}, methodName={"getMaxFocusLength"})
    public double getMaxFocusLength(Object focusControlArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "FocusControl", ".getMaxFocusLength");
            FocusControl focusControl = this.checkFocusControl(focusControlArg);
            if (focusControl != null) {
                double d = focusControl.getMaxFocusLength();
                return d;
            }
            double d = -1.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={FocusControl.class}, methodName={"getFocusLength"})
    public double getFocusLength(Object focusControlArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "FocusControl", ".getFocusLength");
            FocusControl focusControl = this.checkFocusControl(focusControlArg);
            if (focusControl != null) {
                double d = focusControl.getFocusLength();
                return d;
            }
            double d = -1.0;
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={FocusControl.class}, methodName={"setFocusLength"})
    public boolean setFocusLength(Object focusControlArg, double focusLength) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "FocusControl", ".setFocusLength");
            FocusControl focusControl = this.checkFocusControl(focusControlArg);
            if (focusControl != null) {
                boolean bl = focusControl.setFocusLength(focusLength);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={FocusControl.class}, methodName={"isFocusLengthSupported"})
    public boolean isFocusLengthSupported(Object focusControlArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, "FocusControl", ".isFocusLengthSupported");
            FocusControl focusControl = this.checkFocusControl(focusControlArg);
            if (focusControl != null) {
                boolean bl = focusControl.isFocusLengthSupported();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

