/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.qualcomm.robotcore.hardware.Gamepad;

class GamepadAccess
extends Access {
    private final Gamepad gamepad;

    GamepadAccess(BlocksOpMode blocksOpMode, String identifier, Gamepad gamepad) {
        super(blocksOpMode, identifier, identifier);
        this.gamepad = gamepad;
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"left_stick_x"})
    public float getLeftStickX() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LeftStickX");
            if (this.gamepad != null) {
                float f = this.gamepad.left_stick_x;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"left_stick_y"})
    public float getLeftStickY() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LeftStickY");
            if (this.gamepad != null) {
                float f = this.gamepad.left_stick_y;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"right_stick_x"})
    public float getRightStickX() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RightStickX");
            if (this.gamepad != null) {
                float f = this.gamepad.right_stick_x;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"right_stick_y"})
    public float getRightStickY() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RightStickY");
            if (this.gamepad != null) {
                float f = this.gamepad.right_stick_y;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"dpad_up"})
    public boolean getDpadUp() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".DpadUp");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.dpad_up;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"dpad_down"})
    public boolean getDpadDown() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".DpadDown");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.dpad_down;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"dpad_left"})
    public boolean getDpadLeft() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".DpadLeft");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.dpad_left;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"dpad_right"})
    public boolean getDpadRight() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".DpadRight");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.dpad_right;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"a"})
    public boolean getA() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".A");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.a;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"b"})
    public boolean getB() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".B");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.b;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"x"})
    public boolean getX() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".X");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.x;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"y"})
    public boolean getY() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Y");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.y;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"guide"})
    public boolean getGuide() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Guide");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.guide;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"start"})
    public boolean getStart() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Start");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.start;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"back"})
    public boolean getBack() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Back");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.back;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"left_bumper"})
    public boolean getLeftBumper() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LeftBumper");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.left_bumper;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"right_bumper"})
    public boolean getRightBumper() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RightBumper");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.right_bumper;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"left_stick_button"})
    public boolean getLeftStickButton() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LeftStickButton");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.left_stick_button;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"right_stick_button"})
    public boolean getRightStickButton() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RightStickButton");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.right_stick_button;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"left_trigger"})
    public float getLeftTrigger() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".LeftTrigger");
            if (this.gamepad != null) {
                float f = this.gamepad.left_trigger;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"right_trigger"})
    public float getRightTrigger() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RightTrigger");
            if (this.gamepad != null) {
                float f = this.gamepad.right_trigger;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, methodName={"atRest"})
    public boolean getAtRest() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AtRest");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.atRest();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"circle"})
    public boolean getCircle() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Circle");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.circle;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"cross"})
    public boolean getCross() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Cross");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.cross;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"options"})
    public boolean getOptions() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Options");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.options;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"ps"})
    public boolean getPS() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".PS");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.ps;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"share"})
    public boolean getShare() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Share");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.share;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"square"})
    public boolean getSquare() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Square");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.square;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"touchpad"})
    public boolean getTouchpad() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Touchpad");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.touchpad;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"touchpad_finger_1"})
    public boolean getTouchpadFinger1() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".TouchpadFinger1");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.touchpad_finger_1;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"touchpad_finger_1_x"})
    public float getTouchpadFinger1X() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".TouchpadFinger1X");
            if (this.gamepad != null) {
                float f = this.gamepad.touchpad_finger_1_x;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"touchpad_finger_1_y"})
    public float getTouchpadFinger1Y() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".TouchpadFinger1Y");
            if (this.gamepad != null) {
                float f = this.gamepad.touchpad_finger_1_y;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"touchpad_finger_2"})
    public boolean getTouchpadFinger2() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".TouchpadFinger2");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.touchpad_finger_2;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"touchpad_finger_2_x"})
    public float getTouchpadFinger2X() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".TouchpadFinger2X");
            if (this.gamepad != null) {
                float f = this.gamepad.touchpad_finger_2_x;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"touchpad_finger_2_y"})
    public float getTouchpadFinger2Y() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".TouchpadFinger2Y");
            if (this.gamepad != null) {
                float f = this.gamepad.touchpad_finger_2_y;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, fieldName={"triangle"})
    public boolean getTriangle() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Triangle");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.triangle;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, methodName={"rumble"})
    public void rumble_with1(int millis) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rumble");
            if (this.gamepad != null) {
                this.gamepad.rumble(millis);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, methodName={"rumble"})
    public void rumble_with3(double rumble1, double rumble2, int millis) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rumble");
            if (this.gamepad != null) {
                this.gamepad.rumble(rumble1, rumble2, millis);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, methodName={"stopRumble"})
    public void stopRumble() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".stopRumble");
            if (this.gamepad != null) {
                this.gamepad.stopRumble();
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, methodName={"rumbleBlips"})
    public void rumbleBlips(int count) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".rumbleBlips");
            if (this.gamepad != null) {
                this.gamepad.rumbleBlips(count);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, methodName={"isRumbling"})
    public boolean isRumbling() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isRumbling");
            if (this.gamepad != null) {
                boolean bl = this.gamepad.isRumbling();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    private Gamepad.RumbleEffect checkRumbleEffect(Object rumbleEffectArg) {
        return this.checkArg(rumbleEffectArg, Gamepad.RumbleEffect.class, "rumbleEffect");
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, methodName={"runRumbleEffect"})
    public void runRumbleEffect(Object rumbleEffectArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".runRumbleEffect");
            Gamepad.RumbleEffect rumbleEffect = this.checkRumbleEffect(rumbleEffectArg);
            if (this.gamepad != null && rumbleEffect != null) {
                this.gamepad.runRumbleEffect(rumbleEffect);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, methodName={"setLedColor"})
    public void setLedColor(double r, double g, double b, int millis) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setLedColor");
            if (this.gamepad != null) {
                this.gamepad.setLedColor(r, g, b, millis);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    private Gamepad.LedEffect checkLedEffect(Object ledEffectArg) {
        return this.checkArg(ledEffectArg, Gamepad.LedEffect.class, "ledEffect");
    }

    @JavascriptInterface
    @Block(classes={Gamepad.class}, methodName={"runLedEffect"})
    public void runLedEffect(Object ledEffectArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".runLedEffect");
            Gamepad.LedEffect ledEffect = this.checkLedEffect(ledEffectArg);
            if (this.gamepad != null && ledEffect != null) {
                this.gamepad.runLedEffect(ledEffect);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

