/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.modernrobotics.ModernRoboticsI2cGyro;
import com.qualcomm.robotcore.hardware.GyroSensor;
import com.qualcomm.robotcore.hardware.Gyroscope;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.OrientationSensor;
import java.util.Set;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.Axis;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;

class GyroSensorAccess
extends HardwareAccess<GyroSensor> {
    private final GyroSensor gyroSensor;

    GyroSensorAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, GyroSensor.class);
        this.gyroSensor = (GyroSensor)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={GyroSensor.class, ModernRoboticsI2cGyro.class}, methodName={"getHeading"})
    public int getHeading() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Heading");
            int n = this.gyroSensor.getHeading();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cGyro.class}, methodName={"setHeadingMode"})
    public void setHeadingMode(String headingModeString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".HeadingMode");
            ModernRoboticsI2cGyro.HeadingMode headingMode = this.checkArg(headingModeString, ModernRoboticsI2cGyro.HeadingMode.class, "");
            if (headingMode != null) {
                if (this.gyroSensor instanceof ModernRoboticsI2cGyro) {
                    ((ModernRoboticsI2cGyro)this.gyroSensor).setHeadingMode(headingMode);
                } else {
                    this.reportWarning("This GyroSensor is not a ModernRoboticsI2cGyro.");
                }
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cGyro.class}, methodName={"getHeadingMode"})
    public String getHeadingMode() {
        try {
            Object headingMode;
            this.startBlockExecution(BlockType.GETTER, ".HeadingMode");
            if (this.gyroSensor instanceof ModernRoboticsI2cGyro) {
                headingMode = ((ModernRoboticsI2cGyro)this.gyroSensor).getHeadingMode();
                if (headingMode != null) {
                    String string = headingMode.toString();
                    return string;
                }
            } else {
                this.reportWarning("This GyroSensor is not a ModernRoboticsI2cGyro.");
            }
            headingMode = "";
            return headingMode;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cGyro.class}, methodName={"setI2cAddress"})
    public void setI2cAddress7Bit(int i2cAddr7Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress7Bit");
            if (this.gyroSensor instanceof ModernRoboticsI2cGyro) {
                ((ModernRoboticsI2cGyro)this.gyroSensor).setI2cAddress(I2cAddr.create7bit((int)i2cAddr7Bit));
            } else {
                this.reportWarning("This GyroSensor is not a ModernRoboticsI2cGyro.");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cGyro.class}, methodName={"getI2cAddress"})
    public int getI2cAddress7Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress7Bit");
            if (this.gyroSensor instanceof ModernRoboticsI2cGyro) {
                I2cAddr i2cAddr = ((ModernRoboticsI2cGyro)this.gyroSensor).getI2cAddress();
                if (i2cAddr != null) {
                    int n = i2cAddr.get7Bit();
                    return n;
                }
            } else {
                this.reportWarning("This GyroSensor is not a ModernRoboticsI2cGyro.");
            }
            int i2cAddr = 0;
            return i2cAddr;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cGyro.class}, methodName={"setI2cAddress"})
    public void setI2cAddress8Bit(int i2cAddr8Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress8Bit");
            if (this.gyroSensor instanceof ModernRoboticsI2cGyro) {
                ((ModernRoboticsI2cGyro)this.gyroSensor).setI2cAddress(I2cAddr.create8bit((int)i2cAddr8Bit));
            } else {
                this.reportWarning("This GyroSensor is not a ModernRoboticsI2cGyro.");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cGyro.class}, methodName={"getI2cAddress"})
    public int getI2cAddress8Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress8Bit");
            if (this.gyroSensor instanceof ModernRoboticsI2cGyro) {
                I2cAddr i2cAddr = ((ModernRoboticsI2cGyro)this.gyroSensor).getI2cAddress();
                if (i2cAddr != null) {
                    int n = i2cAddr.get8Bit();
                    return n;
                }
            } else {
                this.reportWarning("This GyroSensor is not a ModernRoboticsI2cGyro.");
            }
            int i2cAddr = 0;
            return i2cAddr;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={ModernRoboticsI2cGyro.class}, methodName={"getIntegratedZValue"})
    public int getIntegratedZValue() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".IntegratedZValue");
            if (this.gyroSensor instanceof ModernRoboticsI2cGyro) {
                int n = ((ModernRoboticsI2cGyro)this.gyroSensor).getIntegratedZValue();
                return n;
            }
            this.reportWarning("This GyroSensor is not a ModernRoboticsI2cGyro.");
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={GyroSensor.class, ModernRoboticsI2cGyro.class}, methodName={"rawX"})
    public int getRawX() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RawX");
            int n = this.gyroSensor.rawX();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={GyroSensor.class, ModernRoboticsI2cGyro.class}, methodName={"rawY"})
    public int getRawY() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RawY");
            int n = this.gyroSensor.rawY();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={GyroSensor.class, ModernRoboticsI2cGyro.class}, methodName={"rawZ"})
    public int getRawZ() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RawZ");
            int n = this.gyroSensor.rawZ();
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={GyroSensor.class, ModernRoboticsI2cGyro.class}, methodName={"getRotationFraction"})
    public double getRotationFraction() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".RotationFraction");
            double d = this.gyroSensor.getRotationFraction();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={GyroSensor.class, ModernRoboticsI2cGyro.class}, methodName={"calibrate"})
    public void calibrate() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".calibrate");
            this.gyroSensor.calibrate();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={GyroSensor.class, ModernRoboticsI2cGyro.class}, methodName={"isCalibrating"})
    public boolean isCalibrating() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isCalibrating");
            boolean bl = this.gyroSensor.isCalibrating();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={GyroSensor.class, ModernRoboticsI2cGyro.class}, methodName={"resetZAxisIntegrator"})
    public void resetZAxisIntegrator() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".resetZAxisIntegrator");
            this.gyroSensor.resetZAxisIntegrator();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gyroscope.class, ModernRoboticsI2cGyro.class}, methodName={"getAngularVelocityAxes"})
    public String getAngularVelocityAxes() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AngularVelocityAxes");
            if (this.gyroSensor instanceof Gyroscope) {
                Set axes = ((Gyroscope)this.gyroSensor).getAngularVelocityAxes();
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                String delimiter = "";
                for (Axis axis : axes) {
                    sb.append(delimiter).append("\"").append(axis.toString()).append("\"");
                    delimiter = ",";
                }
                sb.append("]");
                String string = sb.toString();
                return string;
            }
            this.reportWarning("This GyroSensor is not a Gyroscope.");
            String axes = "[]";
            return axes;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Gyroscope.class, ModernRoboticsI2cGyro.class}, methodName={"getAngularVelocity"})
    public AngularVelocity getAngularVelocity(String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getAngularVelocity");
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (angleUnit != null) {
                if (this.gyroSensor instanceof Gyroscope) {
                    AngularVelocity angularVelocity = ((Gyroscope)this.gyroSensor).getAngularVelocity(angleUnit);
                    return angularVelocity;
                }
                this.reportWarning("This GyroSensor is not a Gyroscope.");
                AngularVelocity angularVelocity = new AngularVelocity(angleUnit, 0.0f, 0.0f, 0.0f, 0L);
                return angularVelocity;
            }
            AngularVelocity angularVelocity = null;
            return angularVelocity;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OrientationSensor.class, ModernRoboticsI2cGyro.class}, methodName={"getAngularOrientationAxes"})
    public String getAngularOrientationAxes() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".AngularOrientationAxes");
            if (this.gyroSensor instanceof OrientationSensor) {
                Set axes = ((OrientationSensor)this.gyroSensor).getAngularOrientationAxes();
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                String delimiter = "";
                for (Axis axis : axes) {
                    sb.append(delimiter).append("\"").append(axis.toString()).append("\"");
                    delimiter = ",";
                }
                sb.append("]");
                String string = sb.toString();
                return string;
            }
            this.reportWarning("This GyroSensor is not a OrientationSensor.");
            String axes = "[]";
            return axes;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={OrientationSensor.class, ModernRoboticsI2cGyro.class}, methodName={"getAngularOrientation"})
    public Orientation getAngularOrientation(String axesReferenceString, String axesOrderString, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getAngularOrientation");
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (axesReference != null && axesOrder != null && angleUnit != null) {
                if (this.gyroSensor instanceof OrientationSensor) {
                    Orientation orientation = ((OrientationSensor)this.gyroSensor).getAngularOrientation(axesReference, axesOrder, angleUnit);
                    return orientation;
                }
                this.reportWarning("This GyroSensor is not a OrientationSensor.");
                Orientation orientation = new Orientation(axesReference, axesOrder, angleUnit, 0.0f, 0.0f, 0.0f, 0L);
                return orientation;
            }
            Orientation orientation = null;
            return orientation;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

