/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareType;
import com.google.blocks.ftcrobotcontroller.runtime.AccelerationSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.AnalogInputAccess;
import com.google.blocks.ftcrobotcontroller.runtime.BNO055IMUAccess;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.CRServoAccess;
import com.google.blocks.ftcrobotcontroller.runtime.ColorRangeSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.ColorSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.CompassSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.DcMotorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.DigitalChannelAccess;
import com.google.blocks.ftcrobotcontroller.runtime.DistanceSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.GyroSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.HuskyLensAccess;
import com.google.blocks.ftcrobotcontroller.runtime.ImuAccess;
import com.google.blocks.ftcrobotcontroller.runtime.IrSeekerSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.LedAccess;
import com.google.blocks.ftcrobotcontroller.runtime.LightSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.Limelight3AAccess;
import com.google.blocks.ftcrobotcontroller.runtime.MaxSonarI2CXLAccess;
import com.google.blocks.ftcrobotcontroller.runtime.MrI2cCompassSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.MrI2cRangeSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.OctoQuadAccess;
import com.google.blocks.ftcrobotcontroller.runtime.OpticalDistanceSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.RevBlinkinLedDriverAccess;
import com.google.blocks.ftcrobotcontroller.runtime.ServoAccess;
import com.google.blocks.ftcrobotcontroller.runtime.ServoControllerAccess;
import com.google.blocks.ftcrobotcontroller.runtime.SparkFunLEDStickAccess;
import com.google.blocks.ftcrobotcontroller.runtime.SparkFunOTOSAccess;
import com.google.blocks.ftcrobotcontroller.runtime.TouchSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.UltrasonicSensorAccess;
import com.google.blocks.ftcrobotcontroller.runtime.VoltageSensorAccess;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.HardwareMap;

abstract class HardwareAccess<DEVICE_TYPE extends HardwareDevice>
extends Access {
    protected final HardwareItem hardwareItem;
    protected final DEVICE_TYPE hardwareDevice;

    protected HardwareAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap, Class<DEVICE_TYPE> deviceType) {
        super(blocksOpMode, hardwareItem.identifier, hardwareItem.visibleName);
        this.hardwareItem = hardwareItem;
        HardwareDevice hardwareDevice = null;
        try {
            hardwareDevice = (HardwareDevice)hardwareMap.get(deviceType, hardwareItem.deviceName);
        }
        catch (Exception e) {
            String message;
            try {
                hardwareMap.get(hardwareItem.deviceName);
                message = "The name \"" + hardwareItem.deviceName + "\" is present in the active configuration, but it does not correspond to a " + deviceType.getSimpleName() + ".";
            }
            catch (Exception ee) {
                message = "The name \"" + hardwareItem.deviceName + "\" is not present in the active configuration.";
            }
            this.reportHardwareError(message);
        }
        this.hardwareDevice = hardwareDevice;
    }

    static HardwareAccess newHardwareAccess(BlocksOpMode blocksOpMode, HardwareType hardwareType, HardwareMap hardwareMap, HardwareItem hardwareItem) {
        switch (hardwareType) {
            case ACCELERATION_SENSOR: {
                return new AccelerationSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case ANALOG_INPUT: {
                return new AnalogInputAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case BNO055IMU: {
                return new BNO055IMUAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case COLOR_RANGE_SENSOR: {
                return new ColorRangeSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case COLOR_SENSOR: {
                return new ColorSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case COMPASS_SENSOR: {
                return new CompassSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case CR_SERVO: {
                return new CRServoAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case DC_MOTOR: {
                return new DcMotorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case DIGITAL_CHANNEL: {
                return new DigitalChannelAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case DISTANCE_SENSOR: {
                return new DistanceSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case GYRO_SENSOR: {
                return new GyroSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case HUSKY_LENS: {
                return new HuskyLensAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case IMU: {
                return new ImuAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case IR_SEEKER_SENSOR: {
                return new IrSeekerSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case LED: {
                return new LedAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case LIMELIGHT_3A: {
                return new Limelight3AAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case LIGHT_SENSOR: {
                return new LightSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case LYNX_MODULE: {
                return null;
            }
            case MAX_SONAR_I2CXL: {
                return new MaxSonarI2CXLAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case MR_I2C_COMPASS_SENSOR: {
                return new MrI2cCompassSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case MR_I2C_RANGE_SENSOR: {
                return new MrI2cRangeSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case OCTOQUAD: {
                return new OctoQuadAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case OPTICAL_DISTANCE_SENSOR: {
                return new OpticalDistanceSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case REV_BLINKIN_LED_DRIVER: {
                return new RevBlinkinLedDriverAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case SERVO: {
                return new ServoAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case SERVO_CONTROLLER: {
                return new ServoControllerAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case SPARKFUN_LED_STICK: {
                return new SparkFunLEDStickAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case SPARKFUN_OTOS: {
                return new SparkFunOTOSAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case TOUCH_SENSOR: {
                return new TouchSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case ULTRASONIC_SENSOR: {
                return new UltrasonicSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case VOLTAGE_SENSOR: {
                return new VoltageSensorAccess(blocksOpMode, hardwareItem, hardwareMap);
            }
            case WEBCAM_NAME: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown hardware type " + (Object)((Object)hardwareType));
    }
}

