/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.dfrobot.HuskyLens;
import com.qualcomm.robotcore.hardware.HardwareMap;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;

class HuskyLensAccess
extends HardwareAccess<HuskyLens> {
    private final HuskyLens huskyLens;

    HuskyLensAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, HuskyLens.class);
        this.huskyLens = (HuskyLens)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={HuskyLens.class}, methodName={"knock"})
    public boolean knock() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".knock");
            boolean bl = this.huskyLens.knock();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={HuskyLens.class}, methodName={"selectAlgorithm"})
    public void selectAlgorithm(String algorithmString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".selectAlgorithm");
            HuskyLens.Algorithm algorithm = this.checkArg(algorithmString, HuskyLens.Algorithm.class, "");
            if (algorithm != null) {
                this.huskyLens.selectAlgorithm(algorithm);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={HuskyLens.class}, methodName={"blocks"})
    public String blocks() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".blocks");
            String string = SimpleGson.getInstance().toJson((Object)this.huskyLens.blocks());
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={HuskyLens.class}, methodName={"blocks"})
    public String blocks_withId(int id) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".blocks");
            String string = SimpleGson.getInstance().toJson((Object)this.huskyLens.blocks(id));
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={HuskyLens.class}, methodName={"arrows"})
    public String arrows() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".arrows");
            String string = SimpleGson.getInstance().toJson((Object)this.huskyLens.arrows());
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={HuskyLens.class}, methodName={"arrows"})
    public String arrows_withId(int id) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".arrows");
            String string = SimpleGson.getInstance().toJson((Object)this.huskyLens.arrows(id));
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    static String huskyLensBlockToText(String json) {
        HuskyLens.Block block = (HuskyLens.Block)SimpleGson.getInstance().fromJson(json, HuskyLens.Block.class);
        return block.toString();
    }

    static String huskyLensArrowToText(String json) {
        HuskyLens.Arrow arrow = (HuskyLens.Arrow)SimpleGson.getInstance().fromJson(json, HuskyLens.Arrow.class);
        return arrow.toString();
    }
}

