/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.IMU;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.firstinspires.ftc.robotcore.external.navigation.YawPitchRollAngles;

class ImuAccess
extends HardwareAccess<IMU> {
    private final IMU imu;

    ImuAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, IMU.class);
        this.imu = (IMU)this.hardwareDevice;
    }

    private IMU.Parameters checkImuParameters(Object parametersArg) {
        return this.checkArg(parametersArg, IMU.Parameters.class, "parameters");
    }

    @JavascriptInterface
    @Block(classes={IMU.class}, methodName={"initialize"})
    public void initialize(Object parametersArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".initialize");
            IMU.Parameters parameters = this.checkImuParameters(parametersArg);
            if (parameters != null && !this.imu.initialize(parameters)) {
                this.reportWarning("IMU initialization failed");
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IMU.class}, methodName={"getRobotAngularVelocity"})
    public AngularVelocity getRobotAngularVelocity(String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getRobotAngularVelocity");
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (angleUnit != null) {
                AngularVelocity angularVelocity = this.imu.getRobotAngularVelocity(angleUnit);
                return angularVelocity;
            }
            AngularVelocity angularVelocity = null;
            return angularVelocity;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IMU.class}, methodName={"getRobotOrientation"})
    public Orientation getRobotOrientation(String axesReferenceString, String axesOrderString, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getRobotOrientation");
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (axesReference != null && axesOrder != null && angleUnit != null) {
                Orientation orientation = this.imu.getRobotOrientation(axesReference, axesOrder, angleUnit);
                return orientation;
            }
            Orientation orientation = null;
            return orientation;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IMU.class}, methodName={"getRobotOrientationAsQuaternion"})
    public Quaternion getRobotOrientationAsQuaternion() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getRobotOrientationAsQuaternion");
            Quaternion quaternion = this.imu.getRobotOrientationAsQuaternion();
            return quaternion;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IMU.class}, methodName={"getRobotYawPitchRollAngles"})
    public YawPitchRollAngles getRobotYawPitchRollAngles() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getRobotYawPitchRollAngles");
            YawPitchRollAngles yawPitchRollAngles = this.imu.getRobotYawPitchRollAngles();
            return yawPitchRollAngles;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IMU.class}, methodName={"resetYaw"})
    public void resetYaw() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".resetYaw");
            this.imu.resetYaw();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

