/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.modernrobotics.ModernRoboticsI2cIrSeekerSensorV3;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.IrSeekerSensor;

class IrSeekerSensorAccess
extends HardwareAccess<IrSeekerSensor> {
    private final IrSeekerSensor irSeekerSensor;

    IrSeekerSensorAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, IrSeekerSensor.class);
        this.irSeekerSensor = (IrSeekerSensor)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={IrSeekerSensor.class, ModernRoboticsI2cIrSeekerSensorV3.class}, methodName={"setSignalDetectedThreshold"})
    public void setSignalDetectedThreshold(double threshold) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".SignalDetectedThreshold");
            this.irSeekerSensor.setSignalDetectedThreshold(threshold);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IrSeekerSensor.class, ModernRoboticsI2cIrSeekerSensorV3.class}, methodName={"getSignalDetectedThreshold"})
    public double getSignalDetectedThreshold() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".SignalDetectedThreshold");
            double d = this.irSeekerSensor.getSignalDetectedThreshold();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IrSeekerSensor.class, ModernRoboticsI2cIrSeekerSensorV3.class}, methodName={"setMode"})
    public void setMode(String modeString) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".Mode");
            IrSeekerSensor.Mode mode = this.checkArg(modeString, IrSeekerSensor.Mode.class, "");
            if (mode != null) {
                this.irSeekerSensor.setMode(mode);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IrSeekerSensor.class, ModernRoboticsI2cIrSeekerSensorV3.class}, methodName={"getMode"})
    public String getMode() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Mode");
            IrSeekerSensor.Mode mode = this.irSeekerSensor.getMode();
            if (mode != null) {
                String string = mode.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IrSeekerSensor.class, ModernRoboticsI2cIrSeekerSensorV3.class}, methodName={"signalDetected"})
    public boolean getIsSignalDetected() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".IsSignalDetected");
            boolean bl = this.irSeekerSensor.signalDetected();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IrSeekerSensor.class, ModernRoboticsI2cIrSeekerSensorV3.class}, methodName={"getAngle"})
    public double getAngle() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Angle");
            double d = this.irSeekerSensor.getAngle();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IrSeekerSensor.class, ModernRoboticsI2cIrSeekerSensorV3.class}, methodName={"getStrength"})
    public double getStrength() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".Strength");
            double d = this.irSeekerSensor.getStrength();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IrSeekerSensor.class, ModernRoboticsI2cIrSeekerSensorV3.class}, methodName={"setI2cAddress"})
    public void setI2cAddress7Bit(int i2cAddr7Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress7Bit");
            this.irSeekerSensor.setI2cAddress(I2cAddr.create7bit((int)i2cAddr7Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IrSeekerSensor.class, ModernRoboticsI2cIrSeekerSensorV3.class}, methodName={"getI2cAddress"})
    public int getI2cAddress7Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress7Bit");
            I2cAddr i2cAddr = this.irSeekerSensor.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get7Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IrSeekerSensor.class, ModernRoboticsI2cIrSeekerSensorV3.class}, methodName={"setI2cAddress"})
    public void setI2cAddress8Bit(int i2cAddr8Bit) {
        try {
            this.startBlockExecution(BlockType.SETTER, ".I2cAddress8Bit");
            this.irSeekerSensor.setI2cAddress(I2cAddr.create8bit((int)i2cAddr8Bit));
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={IrSeekerSensor.class, ModernRoboticsI2cIrSeekerSensorV3.class}, methodName={"getI2cAddress"})
    public int getI2cAddress8Bit() {
        try {
            this.startBlockExecution(BlockType.GETTER, ".I2cAddress8Bit");
            I2cAddr i2cAddr = this.irSeekerSensor.getI2cAddress();
            if (i2cAddr != null) {
                int n = i2cAddr.get8Bit();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

