/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.qualcomm.hardware.limelightvision.LLResult;
import org.firstinspires.ftc.robotcore.external.navigation.Pose3D;

class LLResultAccess
extends Access {
    LLResultAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "LLResult");
    }

    private LLResult checkLLResult(Object llResultArg) {
        return this.checkArg(llResultArg, LLResult.class, "llResult");
    }

    @JavascriptInterface
    @Block(classes={LLResult.class}, methodName={"getStaleness"})
    public long getStaleness(Object llResultArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getStaleness");
            LLResult llResult = this.checkLLResult(llResultArg);
            if (llResultArg != null) {
                long l = llResult.getStaleness();
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LLResult.class}, methodName={"toString"})
    public String toText(Object llResultArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            LLResult llResult = this.checkLLResult(llResultArg);
            if (llResultArg != null) {
                String string = llResult.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(exclusiveToBlocks=true)
    public String pose3DToText(String json) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            Pose3D pose3D = LLResultAccess.fromJson(json, Pose3D.class);
            String string = pose3D.toString();
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    static String llResultToJson(LLResult llResult) {
        StringBuilder json = new StringBuilder();
        json.append("{").append("\"PythonOutput\":").append(LLResultAccess.toJson(llResult.getPythonOutput())).append(",").append("\"FiducialResults\":").append(LLResultAccess.toJson(llResult.getFiducialResults())).append(",").append("\"ColorResults\":").append(LLResultAccess.toJson(llResult.getColorResults())).append(",").append("\"ControlHubTimeStamp\":").append(llResult.getControlHubTimeStamp()).append(",").append("\"ControlHubTimeStampNanos\":").append(llResult.getControlHubTimeStampNanos()).append(",").append("\"FocusMetric\":").append(llResult.getFocusMetric()).append(",").append("\"Botpose\":").append(LLResultAccess.toJson(llResult.getBotpose())).append(",").append("\"Botpose_MT2\":").append(LLResultAccess.toJson(llResult.getBotpose_MT2())).append(",").append("\"BotposeTagCount\":").append(llResult.getBotposeTagCount()).append(",").append("\"BotposeSpan\":").append(llResult.getBotposeSpan()).append(",").append("\"BotposeAvgDist\":").append(llResult.getBotposeAvgDist()).append(",").append("\"BotposeAvgArea\":").append(llResult.getBotposeAvgArea()).append(",").append("\"CaptureLatency\":").append(llResult.getCaptureLatency()).append(",").append("\"Tx\":").append(llResult.getTx()).append(",").append("\"Ty\":").append(llResult.getTy()).append(",").append("\"TxNC\":").append(llResult.getTxNC()).append(",").append("\"TyNC\":").append(llResult.getTyNC()).append(",").append("\"Ta\":").append(llResult.getTa()).append(",").append("\"PipelineIndex\":").append(llResult.getPipelineIndex()).append(",").append("\"TargetingLatency\":").append(llResult.getTargetingLatency()).append(",").append("\"Timestamp\":").append(llResult.getTimestamp()).append(",").append("\"PipelineType\":\"").append(llResult.getPipelineType()).append("\"").append(",").append("\"IsValid\":\"").append(llResult.isValid()).append("\"").append("}");
        return json.toString();
    }
}

