/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.LED;

class LedAccess
extends HardwareAccess<LED> {
    private final LED led;

    LedAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, LED.class);
        this.led = (LED)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={LED.class}, methodName={"enable"})
    public void enableLed(boolean enable) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".enableLed");
            this.led.enable(enable);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LED.class}, methodName={"isLightOn"})
    public boolean isLightOn() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isLightOn");
            boolean bl = this.led.isLightOn();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LED.class}, methodName={"on"})
    public void on() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".on");
            this.led.on();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LED.class}, methodName={"off"})
    public void off() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".off");
            this.led.off();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

