/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.hardware.HardwareItem;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.google.blocks.ftcrobotcontroller.runtime.HardwareAccess;
import com.qualcomm.hardware.limelightvision.LLResult;
import com.qualcomm.hardware.limelightvision.LLStatus;
import com.qualcomm.hardware.limelightvision.Limelight3A;
import com.qualcomm.robotcore.hardware.HardwareMap;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;

class Limelight3AAccess
extends HardwareAccess<Limelight3A> {
    private final Limelight3A limelight3a;

    Limelight3AAccess(BlocksOpMode blocksOpMode, HardwareItem hardwareItem, HardwareMap hardwareMap) {
        super(blocksOpMode, hardwareItem, hardwareMap, Limelight3A.class);
        this.limelight3a = (Limelight3A)this.hardwareDevice;
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"start"})
    public void start() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".start");
            this.limelight3a.start();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"pause"})
    public void pause() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".pause");
            this.limelight3a.pause();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"stop"})
    public void stop() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".stop");
            this.limelight3a.stop();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"isRunning"})
    public boolean isRunning() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isRunning");
            boolean bl = this.limelight3a.isRunning();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"setPollRateHz"})
    public void setPollRateHz(int rateHz) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".setPollRateHz");
            this.limelight3a.setPollRateHz(rateHz);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"getTimeSinceLastUpdate"})
    public long getTimeSinceLastUpdate() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getTimeSinceLastUpdate");
            long l = this.limelight3a.getTimeSinceLastUpdate();
            return l;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"isConnected"})
    public boolean isConnected() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isConnected");
            boolean bl = this.limelight3a.isConnected();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"getLatestResult"})
    public Object getLatestResult() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getLatestResult");
            LLResult lLResult = this.limelight3a.getLatestResult();
            return lLResult;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"getStatus"})
    public Object getStatus() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getStatus");
            LLStatus lLStatus = this.limelight3a.getStatus();
            return lLStatus;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"reloadPipeline"})
    public boolean reloadPipeline() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".reloadPipeline");
            boolean bl = this.limelight3a.reloadPipeline();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"pipelineSwitch"})
    public boolean pipelineSwitch(int index) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".pipelineSwitch");
            boolean bl = this.limelight3a.pipelineSwitch(index);
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"updatePythonInputs"})
    public boolean updatePythonInputs_with8Doubles(double input1, double input2, double input3, double input4, double input5, double input6, double input7, double input8) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".updatePythonInputs");
            boolean bl = this.limelight3a.updatePythonInputs(input1, input2, input3, input4, input5, input6, input7, input8);
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"updatePythonInputs"})
    public boolean updatePythonInputs_withArray(String jsonInputs) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".updatePythonInputs");
            double[] inputs = (double[])SimpleGson.getInstance().fromJson(jsonInputs, double[].class);
            boolean bl = this.limelight3a.updatePythonInputs(inputs);
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"updateRobotOrientation"})
    public boolean updateRobotOrientation(double yaw) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".updateRobotOrientation");
            boolean bl = this.limelight3a.updateRobotOrientation(yaw);
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={Limelight3A.class}, methodName={"shutdown"})
    public void shutdown() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".shutdown");
            this.limelight3a.shutdown();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

