/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import com.qualcomm.robotcore.eventloop.opmode.LinearOpMode;
import com.qualcomm.robotcore.eventloop.opmode.OpMode;

class LinearOpModeAccess
extends Access {
    private final BlocksOpMode blocksOpMode;

    LinearOpModeAccess(BlocksOpMode blocksOpMode, String identifier, String projectName) {
        super(blocksOpMode, identifier, projectName);
        this.blocksOpMode = blocksOpMode;
    }

    @JavascriptInterface
    @Block(classes={LinearOpMode.class}, methodName={"waitForStart"})
    public void waitForStart() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".waitForStart");
            this.blocksOpMode.waitForStartForBlocks();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LinearOpMode.class}, methodName={"idle"})
    public void idle() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".idle");
            this.blocksOpMode.idle();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LinearOpMode.class}, methodName={"sleep"})
    public void sleep(double millis) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".sleep");
            this.blocksOpMode.sleepForBlocks((long)millis);
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LinearOpMode.class}, methodName={"opModeInInit"})
    public boolean opModeInInit() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".opModeInInit");
            boolean bl = this.blocksOpMode.opModeInInit();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LinearOpMode.class}, methodName={"opModeIsActive"})
    public boolean opModeIsActive() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".opModeIsActive");
            boolean bl = this.blocksOpMode.opModeIsActive();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LinearOpMode.class}, methodName={"isStarted"})
    public boolean isStarted() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isStarted");
            boolean bl = this.blocksOpMode.isStartedForBlocks();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LinearOpMode.class}, methodName={"isStopRequested"})
    public boolean isStopRequested() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".isStopRequested");
            boolean bl = this.blocksOpMode.isStopRequestedForBlocks();
            return bl;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LinearOpMode.class, OpMode.class}, methodName={"getRuntime"})
    public double getRuntime() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getRuntime");
            double d = this.blocksOpMode.getRuntime();
            return d;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LinearOpMode.class, OpMode.class}, methodName={"resetRuntime"})
    public void resetRuntime() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".resetRuntime");
            this.blocksOpMode.resetRuntime();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LinearOpMode.class, OpMode.class}, methodName={"requestOpModeStop"})
    public void requestOpModeStop() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".requestOpModeStop");
            this.blocksOpMode.requestOpModeStop();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={LinearOpMode.class, OpMode.class}, methodName={"terminateOpModeNow"})
    public void terminateOpModeNow() {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".terminateOpModeNow");
            this.blocksOpMode.terminateOpModeNowForBlocks();
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

