/*
 * Decompiled with CFR 0.152.
 */
package com.google.blocks.ftcrobotcontroller.runtime;

import android.webkit.JavascriptInterface;
import com.google.blocks.ftcrobotcontroller.runtime.Access;
import com.google.blocks.ftcrobotcontroller.runtime.Block;
import com.google.blocks.ftcrobotcontroller.runtime.BlockType;
import com.google.blocks.ftcrobotcontroller.runtime.BlocksOpMode;
import org.firstinspires.ftc.robotcore.external.matrices.MatrixF;
import org.firstinspires.ftc.robotcore.external.matrices.SliceMatrixF;
import org.firstinspires.ftc.robotcore.external.matrices.VectorF;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;

class MatrixFAccess
extends Access {
    MatrixFAccess(BlocksOpMode blocksOpMode, String identifier) {
        super(blocksOpMode, identifier, "MatrixF");
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"numRows"})
    public int getNumRows(Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".NumRows");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                int n = matrix.numRows();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"numCols"})
    public int getNumCols(Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.GETTER, ".NumCols");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                int n = matrix.numCols();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"slice"})
    public MatrixF slice(Object matrixArg, int row, int col, int numRows, int numCols) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".slice");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                SliceMatrixF sliceMatrixF = matrix.slice(row, col, numRows, numCols);
                return sliceMatrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"identityMatrix"})
    public MatrixF identityMatrix(int dim) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".identityMatrix");
            MatrixF matrixF = MatrixF.identityMatrix((int)dim);
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"diagonalMatrix"})
    public MatrixF diagonalMatrix(int dim, int scale) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".diagonalMatrix");
            MatrixF matrixF = MatrixF.diagonalMatrix((int)dim, (float)scale);
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"diagonalMatrix"})
    public MatrixF diagonalMatrix_withVector(Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".diagonalMatrix");
            VectorF vector = this.checkVectorF(vectorArg);
            if (vector != null) {
                MatrixF matrixF = MatrixF.diagonalMatrix((VectorF)vector);
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"get"})
    public float get(Object matrixArg, int row, int col) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".get");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                float f = matrix.get(row, col);
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"put"})
    public void put(Object matrixArg, int row, int col, float value) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".put");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                matrix.put(row, col, value);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"getRow"})
    public VectorF getRow(Object matrixArg, int row) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getRow");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                VectorF vectorF = matrix.getRow(row);
                return vectorF;
            }
            VectorF vectorF = null;
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"getColumn"})
    public VectorF getColumn(Object matrixArg, int col) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getColumn");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                VectorF vectorF = matrix.getColumn(col);
                return vectorF;
            }
            VectorF vectorF = null;
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"toString"})
    public String toText(Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toText");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                String string = matrix.toString();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"transform"})
    public VectorF transform(Object matrixArg, Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".transform");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            VectorF vector = this.checkVectorF(vectorArg);
            if (matrix != null && vector != null) {
                VectorF vectorF = matrix.transform(vector);
                return vectorF;
            }
            VectorF vectorF = null;
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"formatAsTransform"})
    public String formatAsTransform(Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".formatAsTransform");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                String string = matrix.formatAsTransform();
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"formatAsTransform"})
    public String formatAsTransform_withArgs(Object matrixArg, String axesReferenceString, String axesOrderString, String angleUnitString) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".formatAsTransform");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            AxesReference axesReference = this.checkAxesReference(axesReferenceString);
            AxesOrder axesOrder = this.checkAxesOrder(axesOrderString);
            AngleUnit angleUnit = this.checkAngleUnit(angleUnitString);
            if (matrix != null && axesReference != null && axesOrder != null && angleUnit != null) {
                String string = matrix.formatAsTransform(axesReference, axesOrder, angleUnit);
                return string;
            }
            String string = "";
            return string;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"transposed"})
    public MatrixF transposed(Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".transposed");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                MatrixF matrixF = matrix.transposed();
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"multiplied"})
    public MatrixF multiplied_withMatrix(Object matrix1Arg, Object matrix2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".multiplied");
            MatrixF matrix1 = this.checkArg(matrix1Arg, MatrixF.class, "matrix1");
            MatrixF matrix2 = this.checkArg(matrix2Arg, MatrixF.class, "matrix2");
            if (matrix1 != null && matrix2 != null) {
                MatrixF matrixF = matrix1.multiplied(matrix2);
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"multiplied"})
    public MatrixF multiplied_withScale(Object matrixArg, float scale) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".multiplied");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                MatrixF matrixF = matrix.multiplied(scale);
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"multiplied"})
    public VectorF multiplied_withVector(Object matrixArg, Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".multiplied");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            VectorF vector = this.checkVectorF(vectorArg);
            if (matrix != null && vector != null) {
                VectorF vectorF = matrix.multiplied(vector);
                return vectorF;
            }
            VectorF vectorF = null;
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"multiply"})
    public void multiply_withMatrix(Object matrix1Arg, Object matrix2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".multiply");
            MatrixF matrix1 = this.checkArg(matrix1Arg, MatrixF.class, "matrix1");
            MatrixF matrix2 = this.checkArg(matrix2Arg, MatrixF.class, "matrix2");
            if (matrix1 != null && matrix2 != null) {
                matrix1.multiply(matrix2);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"multiply"})
    public void multiply_withScale(Object matrixArg, float scale) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".multiply");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                matrix.multiply(scale);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"multiply"})
    public void multiply_withVector(Object matrixArg, Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".multiply");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            VectorF vector = this.checkVectorF(vectorArg);
            if (matrix != null && vector != null) {
                matrix.multiply(vector);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"toVector"})
    public VectorF toVector(Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".toVector");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                VectorF vectorF = matrix.toVector();
                return vectorF;
            }
            VectorF vectorF = null;
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"added"})
    public MatrixF added_withMatrix(Object matrix1Arg, Object matrix2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".added");
            MatrixF matrix1 = this.checkArg(matrix1Arg, MatrixF.class, "matrix1");
            MatrixF matrix2 = this.checkArg(matrix2Arg, MatrixF.class, "matrix2");
            if (matrix1 != null && matrix2 != null) {
                MatrixF matrixF = matrix1.added(matrix2);
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"added"})
    public MatrixF added_withVector(Object matrixArg, Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".added");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            VectorF vector = this.checkVectorF(vectorArg);
            if (matrix != null && vector != null) {
                MatrixF matrixF = matrix.added(vector);
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"add"})
    public void add_withMatrix(Object matrix1Arg, Object matrix2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".add");
            MatrixF matrix1 = this.checkArg(matrix1Arg, MatrixF.class, "matrix1");
            MatrixF matrix2 = this.checkArg(matrix2Arg, MatrixF.class, "matrix2");
            if (matrix1 != null && matrix2 != null) {
                matrix1.add(matrix2);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"add"})
    public void add_withVector(Object matrixArg, Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".add");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            VectorF vector = this.checkVectorF(vectorArg);
            if (matrix != null && vector != null) {
                matrix.add(vector);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"subtracted"})
    public MatrixF subtracted_withMatrix(Object matrix1Arg, Object matrix2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".subtracted");
            MatrixF matrix1 = this.checkArg(matrix1Arg, MatrixF.class, "matrix1");
            MatrixF matrix2 = this.checkArg(matrix2Arg, MatrixF.class, "matrix2");
            if (matrix1 != null && matrix2 != null) {
                MatrixF matrixF = matrix1.subtracted(matrix2);
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"subtracted"})
    public MatrixF subtracted_withVector(Object matrixArg, Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".subtracted");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            VectorF vector = this.checkVectorF(vectorArg);
            if (matrix != null && vector != null) {
                MatrixF matrixF = matrix.subtracted(vector);
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"subtract"})
    public void subtract_withMatrix(Object matrix1Arg, Object matrix2Arg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".subtract");
            MatrixF matrix1 = this.checkArg(matrix1Arg, MatrixF.class, "matrix1");
            MatrixF matrix2 = this.checkArg(matrix2Arg, MatrixF.class, "matrix2");
            if (matrix1 != null && matrix2 != null) {
                matrix1.subtract(matrix2);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"subtract"})
    public void subtract_withVector(Object matrixArg, Object vectorArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".subtract");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            VectorF vector = this.checkVectorF(vectorArg);
            if (matrix != null && vector != null) {
                matrix.subtract(vector);
            }
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"getTranslation"})
    public VectorF getTranslation(Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".getTranslation");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                VectorF vectorF = matrix.getTranslation();
                return vectorF;
            }
            VectorF vectorF = null;
            return vectorF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }

    @JavascriptInterface
    @Block(classes={MatrixF.class}, methodName={"inverted"})
    public MatrixF inverted(Object matrixArg) {
        try {
            this.startBlockExecution(BlockType.FUNCTION, ".inverted");
            MatrixF matrix = this.checkMatrixF(matrixArg);
            if (matrix != null) {
                MatrixF matrixF = matrix.inverted();
                return matrixF;
            }
            MatrixF matrixF = null;
            return matrixF;
        }
        catch (Throwable e) {
            this.blocksOpMode.handleFatalException(e);
            throw new AssertionError("impossible", e);
        }
        finally {
            this.endBlockExecution();
        }
    }
}

